/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.preferences.ColorIcon;

public class SwitchableColorCtrl {
    private final JCheckBox _chkSwitch;
    private final JLabel _lblColor = new JLabel();
    private final ActionListener _checkBoxListener = e -> this.onAdjustCaretColor();
    private ColorIcon _colorIcon;
    private String _colorChooserDialogTitle;

    public SwitchableColorCtrl(String checkBoxText, String colorChooserDialogTitle) {
        this._chkSwitch = new JCheckBox(checkBoxText);
        this._chkSwitch.addActionListener(this._checkBoxListener);
        this._colorChooserDialogTitle = colorChooserDialogTitle;
        this._lblColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwitchableColorCtrl.this.onColorLabelClicked();
            }
        });
    }

    private void onColorLabelClicked() {
        if (!this._chkSwitch.isSelected()) {
            this._chkSwitch.doClick();
        } else {
            Color color;
            Color initialColor = null;
            if (-1 != this.getColorRGB()) {
                initialColor = new Color(this.getColorRGB());
            }
            if (null == (color = JColorChooser.showDialog(this._chkSwitch, this._colorChooserDialogTitle, initialColor))) {
                return;
            }
            this.adjustLabel(color.getRGB());
        }
    }

    public int getColorRGB() {
        int retColorRGB = -1;
        if (this._chkSwitch.isSelected()) {
            retColorRGB = this._colorIcon.getColor().getRGB();
        }
        return retColorRGB;
    }

    public void setColorRGB(int colorRGB) {
        this._chkSwitch.removeActionListener(this._checkBoxListener);
        this._chkSwitch.setSelected(-1 != colorRGB);
        this._chkSwitch.addActionListener(this._checkBoxListener);
        this.adjustLabel(colorRGB);
    }

    private void onAdjustCaretColor() {
        Color color = null;
        if (this._chkSwitch.isSelected()) {
            color = JColorChooser.showDialog(this._chkSwitch, this._colorChooserDialogTitle, null);
        }
        if (null != color) {
            this.adjustLabel(color.getRGB());
        } else {
            this._chkSwitch.removeActionListener(this._checkBoxListener);
            this._chkSwitch.setSelected(false);
            this.adjustLabel(-1);
            this._chkSwitch.addActionListener(this._checkBoxListener);
        }
    }

    private void adjustLabel(int caretColorRGB) {
        if (-1 == caretColorRGB) {
            this._lblColor.setBorder(BorderFactory.createEtchedBorder());
            this._colorIcon.setColor(this._chkSwitch.getBackground());
        } else {
            this._lblColor.setBorder(BorderFactory.createLineBorder(Color.black));
            this._colorIcon.setColor(new Color(caretColorRGB));
        }
    }

    public void setEnabled(boolean useRSyntaxControl) {
        this._chkSwitch.setEnabled(useRSyntaxControl);
    }

    JPanel createCaretColorPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
        ret.add((Component)this._chkSwitch, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
        this._lblColor.setPreferredSize(new Dimension(16, 16));
        this._colorIcon = new ColorIcon(14, 14);
        this._colorIcon.setBorderColor(null);
        this._lblColor.setIcon((Icon)this._colorIcon);
        ret.add((Component)this._lblColor, gbc);
        return ret;
    }
}

