/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxStyle;
import net.sourceforge.squirrel_sql.plugins.syntax.theme.SyntaxTheme;
import net.sourceforge.squirrel_sql.plugins.syntax.theme.SyntaxThemeFactory;

public class SyntaxPreferences
implements Serializable {
    public static final int NO_COLOR = -1;
    private transient PropertyChangeReporter _propChgReporter;
    private boolean _usePlainTextControl = false;
    private boolean _useRSyntaxTextArea = true;
    private boolean _textLimitLineVisible = false;
    private int _textLimitLineWidth = 80;
    private int _tabLength = 5;
    private boolean _replaceTabsBySpaces = false;
    private boolean _highlightCurrentLine = true;
    private boolean _lineNumbersEnabled = false;
    private boolean _useCopyAsRtf = false;
    private boolean _insertPairedQuotes;
    private SyntaxTheme _syntaxTheme;

    public SyntaxPreferences() {
        this.initSyntaxTheme(SyntaxThemeFactory.createDefaultLightTheme());
    }

    public void initSyntaxTheme(SyntaxTheme syntaxTheme) {
        this._syntaxTheme = syntaxTheme;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public boolean getUseRSyntaxTextArea() {
        return this._useRSyntaxTextArea;
    }

    public void setUseRSyntaxTextArea(boolean data) {
        if (this._useRSyntaxTextArea != data) {
            this.getPropertyChangeReporter().firePropertyChange("useRSyntaxControl", this._useRSyntaxTextArea, data);
            this._useRSyntaxTextArea = data;
        }
    }

    public boolean getUsePlainTextControl() {
        return this._usePlainTextControl;
    }

    public void setUsePlainTextControl(boolean data) {
        if (this._usePlainTextControl != data) {
            this.getPropertyChangeReporter().firePropertyChange("usePlainControl", this._usePlainTextControl, data);
            this._usePlainTextControl = data;
        }
    }

    public boolean isTextLimitLineVisible() {
        return this._textLimitLineVisible;
    }

    public void setTextLimitLineVisible(boolean data) {
        if (this._textLimitLineVisible != data) {
            Boolean oldValue = this._textLimitLineVisible;
            this._textLimitLineVisible = data;
            this.getPropertyChangeReporter().firePropertyChange("textLimitLineVisible", (Object)oldValue, (Object)this._textLimitLineVisible);
        }
    }

    public boolean isReplaceTabsBySpaces() {
        return this._replaceTabsBySpaces;
    }

    public void setReplaceTabsBySpaces(boolean data) {
        if (this._replaceTabsBySpaces != data) {
            Boolean oldValue = this._replaceTabsBySpaces;
            this._replaceTabsBySpaces = data;
            this.getPropertyChangeReporter().firePropertyChange("replaceTabsBySpaces", (Object)oldValue, (Object)this._replaceTabsBySpaces);
        }
    }

    public int getTabLength() {
        return this._tabLength;
    }

    public void setTabLength(int data) {
        if (this._tabLength != data) {
            Integer oldValue = this._tabLength;
            this._tabLength = data;
            this.getPropertyChangeReporter().firePropertyChange("tabLength", (Object)oldValue, (Object)this._tabLength);
        }
    }

    public int getTextLimitLineWidth() {
        return this._textLimitLineWidth;
    }

    public void setTextLimitLineWidth(int data) {
        if (this._textLimitLineWidth != data) {
            Integer oldValue = this._textLimitLineWidth;
            this._textLimitLineWidth = data;
            this.getPropertyChangeReporter().firePropertyChange("textLimitLineWidth", (Object)oldValue, (Object)this._textLimitLineWidth);
        }
    }

    public boolean isHighlightCurrentLine() {
        return this._highlightCurrentLine;
    }

    public void setHighlightCurrentLine(boolean data) {
        if (this._highlightCurrentLine != data) {
            Boolean oldValue = this._highlightCurrentLine;
            this._highlightCurrentLine = data;
            this.getPropertyChangeReporter().firePropertyChange("highlightCurrentLine", (Object)oldValue, (Object)this._highlightCurrentLine);
        }
    }

    public boolean isLineNumbersEnabled() {
        return this._lineNumbersEnabled;
    }

    public int getCurrentLineHighlightColorRGB() {
        return this._syntaxTheme.getCurrentLineHighlightColorRGB();
    }

    public void setCurrentLineHighlightColorRGB(int data) {
        if (this._syntaxTheme.getCurrentLineHighlightColorRGB() != data) {
            int oldValue = this._syntaxTheme.getCurrentLineHighlightColorRGB();
            this._syntaxTheme.setCurrentLineHighlightColorRGB(data);
            this.getPropertyChangeReporter().firePropertyChange("currentLineHighlightColorRGB", oldValue, this._syntaxTheme.getCurrentLineHighlightColorRGB());
        }
    }

    public void setLineNumbersEnabled(boolean data) {
        if (this._lineNumbersEnabled != data) {
            Boolean oldValue = this._lineNumbersEnabled;
            this._lineNumbersEnabled = data;
            this.getPropertyChangeReporter().firePropertyChange("lineNumbersEnabled", (Object)oldValue, (Object)this._lineNumbersEnabled);
        }
    }

    public int getCaretColorRGB() {
        return this._syntaxTheme.getCaretColorRGB();
    }

    public void setCaretColorRGB(int caretColorRGB) {
        int oldValue = this._syntaxTheme.getCaretColorRGB();
        this._syntaxTheme.setCaretColorRGB(caretColorRGB);
        this.getPropertyChangeReporter().firePropertyChange("caretColorRGB", oldValue, this._syntaxTheme.getCaretColorRGB());
    }

    public SyntaxStyle getCommentStyle() {
        return this._syntaxTheme.getCommentStyle();
    }

    public void setCommentStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getCommentStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getCommentStyle();
            this._syntaxTheme.setCommentStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("commentStyle", (Object)oldValue, (Object)this._syntaxTheme.getCommentStyle());
        }
    }

    public SyntaxStyle getDataTypeStyle() {
        return this._syntaxTheme.getDataTypeStyle();
    }

    public void setDataTypeStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getDataTypeStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getDataTypeStyle();
            this._syntaxTheme.setDataTypeStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("dataTypeStyle", (Object)oldValue, (Object)this._syntaxTheme.getDataTypeStyle());
        }
    }

    public SyntaxStyle getErrorStyle() {
        return this._syntaxTheme.getErrorStyle();
    }

    public void setErrorStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getErrorStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getErrorStyle();
            this._syntaxTheme.setErrorStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("errorStyle", (Object)oldValue, (Object)this._syntaxTheme.getErrorStyle());
        }
    }

    public SyntaxStyle getFunctionStyle() {
        return this._syntaxTheme.getFunctionStyle();
    }

    public void setFunctionStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getFunctionStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getFunctionStyle();
            this._syntaxTheme.setFunctionStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("functionStyle", (Object)oldValue, (Object)this._syntaxTheme.getFunctionStyle());
        }
    }

    public SyntaxStyle getIdentifierStyle() {
        return this._syntaxTheme.getIdentifierStyle();
    }

    public void setIdentifierStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getIdentifierStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getIdentifierStyle();
            this._syntaxTheme.setIdentifierStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("identifierStyle", (Object)oldValue, (Object)this._syntaxTheme.getIdentifierStyle());
        }
    }

    public SyntaxStyle getLiteralStyle() {
        return this._syntaxTheme.getLiteralStyle();
    }

    public void setLiteralStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getLiteralStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getLiteralStyle();
            this._syntaxTheme.setLiteralStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("literalStyle", (Object)oldValue, (Object)this._syntaxTheme.getLiteralStyle());
        }
    }

    public SyntaxStyle getTableStyle() {
        return this._syntaxTheme.getTableStyle();
    }

    public void setTableStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getTableStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getTableStyle();
            this._syntaxTheme.setTableStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("tableStyle", (Object)oldValue, (Object)this._syntaxTheme.getTableStyle());
        }
    }

    public SyntaxStyle getColumnStyle() {
        return this._syntaxTheme.getColumnStyle();
    }

    public void setColumnStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getColumnStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getColumnStyle();
            this._syntaxTheme.setColumnStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("columnStyle", (Object)oldValue, (Object)this._syntaxTheme.getColumnStyle());
        }
    }

    public SyntaxStyle getOperatorStyle() {
        return this._syntaxTheme.getOperatorStyle();
    }

    public void setOperatorStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getOperatorStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getOperatorStyle();
            this._syntaxTheme.setOperatorStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("operatorStyle", (Object)oldValue, (Object)this._syntaxTheme.getOperatorStyle());
        }
    }

    public SyntaxStyle getReservedWordStyle() {
        return this._syntaxTheme.getReservedWordStyle();
    }

    public void setReservedWordStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getReservedWordStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getReservedWordStyle();
            this._syntaxTheme.setReservedWordStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("reservedWordStyle", (Object)oldValue, (Object)this._syntaxTheme.getReservedWordStyle());
        }
    }

    public SyntaxStyle getSeparatorStyle() {
        return this._syntaxTheme.getSeparatorStyle();
    }

    public void setSeparatorStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getSeparatorStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getSeparatorStyle();
            this._syntaxTheme.setSeparatorStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("separatorStyle", (Object)oldValue, (Object)this._syntaxTheme.getSeparatorStyle());
        }
    }

    public SyntaxStyle getWhiteSpaceStyle() {
        return this._syntaxTheme.getWhiteSpaceStyle();
    }

    public void setWhiteSpaceStyle(SyntaxStyle data) {
        if (data == null) {
            throw new IllegalArgumentException("SyntaxStyle==null");
        }
        if (this._syntaxTheme.getWhiteSpaceStyle() != data) {
            SyntaxStyle oldValue = this._syntaxTheme.getWhiteSpaceStyle();
            this._syntaxTheme.setWhiteSpaceStyle(data);
            this.getPropertyChangeReporter().firePropertyChange("whiteSpaceStyle", (Object)oldValue, (Object)this._syntaxTheme.getWhiteSpaceStyle());
        }
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter((Object)this);
        }
        return this._propChgReporter;
    }

    public boolean isUseCopyAsRtf() {
        return this._useCopyAsRtf;
    }

    public void setUseCopyAsRtf(boolean useCopyAsRtf) {
        this._useCopyAsRtf = useCopyAsRtf;
    }

    public boolean isInsertPairedQuotes() {
        return this._insertPairedQuotes;
    }

    public void setInsertPairedQuotes(boolean insertPairedQuotes) {
        this._insertPairedQuotes = insertPairedQuotes;
    }

    public static interface IPropertyNames {
        public static final String COLUMN_STYLE = "columnStyle";
        public static final String COMMENT_STYLE = "commentStyle";
        public static final String DATA_TYPE_STYLE = "dataTypeStyle";
        public static final String ERROR_STYLE = "errorStyle";
        public static final String FUNCTION_STYLE = "functionStyle";
        public static final String IDENTIFIER_STYLE = "identifierStyle";
        public static final String LITERAL_STYLE = "literalStyle";
        public static final String OPERATOR_STYLE = "operatorStyle";
        public static final String RESERVED_WORD_STYLE = "reservedWordStyle";
        public static final String SEPARATOR_STYLE = "separatorStyle";
        public static final String TABLE_STYLE = "tableStyle";
        public static final String USE_RSYNTAX_CONTROL = "useRSyntaxControl";
        public static final String USE_PLAIN_CONTROL = "usePlainControl";
        public static final String WHITE_SPACE_STYLE = "whiteSpaceStyle";
        public static final String TEXT_LIMIT_LINE_VISIBLE = "textLimitLineVisible";
        public static final String TAB_LENGTH = "tabLength";
        public static final String REPLACE_TABS_BY_SPACES = "replaceTabsBySpaces";
        public static final String TEXT_LIMIT_LINE_WIDTH = "textLimitLineWidth";
        public static final String HIGHLIGHT_CURRENT_LINE = "highlightCurrentLine";
        public static final String CURRENT_LINE_HIGHLIGHT_COLOR_RGB = "currentLineHighlightColorRGB";
        public static final String LINE_NUMBERS_ENABLED = "lineNumbersEnabled";
        public static final String CARET_COLOR_RGB = "caretColorRGB";
    }
}

