/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.HashMap;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupAccessor;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.CommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ConfigureAutoCorrectAction;
import net.sourceforge.squirrel_sql.plugins.syntax.DuplicateLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.GoToLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.MarkSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.RepeatLastFindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ReplaceAction;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.UncommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.UnmarkAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirreLRSyntaxTextAreaUI;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.action.SquirrelCopyAsRtfAction;

public class ToolsPopupHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ToolsPopupHandler.class);
    private SyntaxPlugin _syntaxPugin;

    ToolsPopupHandler(SyntaxPlugin syntaxPugin) {
        this._syntaxPugin = syntaxPugin;
    }

    void initToolsPopup(HashMap<String, Object> props, ISQLEntryPanel isqlEntryPanel) {
        ToolsPopupAccessor tpa = (ToolsPopupAccessor)props.get(ToolsPopupAccessor.class.getName());
        if (null == tpa) {
            return;
        }
        SyntaxPluginResources rsrc = this._syntaxPugin.getResources();
        IApplication app = this._syntaxPugin.getApplication();
        tpa.addToToolsPopup(I18n.FIND, (Action)((Object)new FindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.FIND_SELECTED, (Action)((Object)new FindSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.REPEAT_LAST_FIND, (Action)((Object)new RepeatLastFindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.MARK_SELECTED, (Action)((Object)new MarkSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.REPLACE, (Action)((Object)new ReplaceAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.UNMARK, (Action)((Object)new UnmarkAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.GO_TO_LINE, (Action)((Object)new GoToLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.AUTO_CORR, (Action)((Object)new ConfigureAutoCorrectAction(app, rsrc, this._syntaxPugin)));
        tpa.addToToolsPopup(I18n.DUP_LINE, (Action)((Object)new DuplicateLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.COMMENT, (Action)((Object)new CommentAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(I18n.UNCOMMENT, (Action)((Object)new UncommentAction(app, rsrc, isqlEntryPanel)));
        if (isqlEntryPanel.getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)isqlEntryPanel.getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke()));
            tpa.addToToolsPopup(I18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke()));
            tpa.addToToolsPopup(I18n.TO_LOWER_CASE, toLowerAction);
            tpa.addToToolsPopup(I18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }

    void initToolsPopup(ActionCollection coll, ISQLPanelAPI sqlPanelAPI) {
        sqlPanelAPI.addToToolsPopUp(I18n.FIND, coll.get(FindAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.FIND_SELECTED, coll.get(FindSelectedAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.REPEAT_LAST_FIND, coll.get(RepeatLastFindAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.MARK_SELECTED, coll.get(MarkSelectedAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.REPLACE, coll.get(ReplaceAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.UNMARK, coll.get(UnmarkAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.GO_TO_LINE, coll.get(GoToLineAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.AUTO_CORR, coll.get(ConfigureAutoCorrectAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.DUP_LINE, coll.get(DuplicateLineAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.COMMENT, coll.get(CommentAction.class));
        sqlPanelAPI.addToToolsPopUp(I18n.UNCOMMENT, coll.get(UncommentAction.class));
        if (sqlPanelAPI.getSQLEntryPanel().getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)sqlPanelAPI.getSQLEntryPanel().getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke()));
            sqlPanelAPI.addToToolsPopUp(I18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke()));
            sqlPanelAPI.addToToolsPopUp(I18n.TO_LOWER_CASE, toLowerAction);
            sqlPanelAPI.addToToolsPopUp(I18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }

    static interface I18n {
        public static final String TO_UPPER_CASE = s_stringMgr.getString("SyntaxPlugin.touppercase");
        public static final String TO_LOWER_CASE = s_stringMgr.getString("SyntaxPlugin.tolowercase");
        public static final String FIND = s_stringMgr.getString("SyntaxPlugin.find");
        public static final String FIND_SELECTED = s_stringMgr.getString("SyntaxPlugin.findselected");
        public static final String REPEAT_LAST_FIND = s_stringMgr.getString("SyntaxPlugin.repeatLastFind");
        public static final String MARK_SELECTED = s_stringMgr.getString("SyntaxPlugin.markSelected");
        public static final String REPLACE = s_stringMgr.getString("SyntaxPlugin.replace");
        public static final String UNMARK = s_stringMgr.getString("SyntaxPlugin.unmark");
        public static final String GO_TO_LINE = s_stringMgr.getString("SyntaxPlugin.gotoline");
        public static final String AUTO_CORR = s_stringMgr.getString("SyntaxPlugin.autocorr");
        public static final String DUP_LINE = s_stringMgr.getString("SyntaxPlugin.duplicateline");
        public static final String COMMENT = s_stringMgr.getString("SyntaxPlugin.comment");
        public static final String UNCOMMENT = s_stringMgr.getString("SyntaxPlugin.uncomment");
        public static final String COPY_AS_RTF = s_stringMgr.getString("SyntaxPlugin.copyasrtf");
    }
}

