/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxUtil;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;

public class CtrlDownHyperlinkHandler {
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;
    private Timer _hyperlinkDelayTimer;
    private boolean _showTablesAsHyperlink;

    public CtrlDownHyperlinkHandler(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        if (!Main.getApplication().getSquirrelPreferences().getSessionProperties().getAllowCtrlMouseClickJumpToObjectTree()) {
            return;
        }
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
        this._hyperlinkDelayTimer = new Timer(200, e -> this.onDelayTimer());
        this._hyperlinkDelayTimer.setRepeats(false);
        this._squirrelRSyntaxTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CtrlDownHyperlinkHandler.this.onKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CtrlDownHyperlinkHandler.this.onKeyReleased(e);
            }
        });
        this._squirrelRSyntaxTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CtrlDownHyperlinkHandler.this.onFocusLost();
            }
        });
    }

    private void onDelayTimer() {
        this.setShowTablesAsHyperlink(true);
    }

    private void setShowTablesAsHyperlink(boolean b) {
        boolean oldVal = this._showTablesAsHyperlink;
        this._showTablesAsHyperlink = b;
        if (oldVal != b) {
            RSyntaxUtil.forceHighlightUpdate(this._squirrelRSyntaxTextArea);
        }
    }

    private void onFocusLost() {
        this.clearHyperlink();
    }

    private void clearHyperlink() {
        this._hyperlinkDelayTimer.stop();
        SwingUtilities.invokeLater(() -> this.setShowTablesAsHyperlink(false));
    }

    private void onKeyPressed(KeyEvent e) {
        if ((e.getExtendedKeyCode() == 17 || e.getExtendedKeyCode() == 18 || e.getExtendedKeyCode() == 16) && 0 == (e.getModifiersEx() & 0x40) && 0 == (e.getModifiersEx() & 0x200)) {
            this._hyperlinkDelayTimer.start();
            return;
        }
        this.clearHyperlink();
    }

    private void onKeyReleased(KeyEvent e) {
        if (e.getExtendedKeyCode() == 17) {
            this.clearHyperlink();
        }
    }

    public boolean isShowTablesAsHyperlink() {
        return this._showTablesAsHyperlink;
    }
}

