/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxUtil;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;

public class RSyntaxHighlightTokenMatcher
implements ISyntaxHighlightTokenMatcher {
    private ISession _sess;
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;
    private CaseInsensitiveString _caseInsensitiveStringBuffer = new CaseInsensitiveString();
    private Hashtable<CaseInsensitiveString, String> _knownTables = new Hashtable();
    private Vector<SQLTokenListener> _sqlTokenListeners = new Vector();
    private Vector<ErrorInfo> _currentErrorInfos = new Vector();

    public RSyntaxHighlightTokenMatcher(ISession sess, SquirrelRSyntaxTextArea squirrelRSyntaxTextArea, final IIdentifier sqlEntryPanelIdentifier, final RSyntaxPropertiesWrapper rSyntaxPropertiesWrapper) {
        this._sess = sess;
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RSyntaxHighlightTokenMatcher.this.initParsing(rSyntaxPropertiesWrapper, sqlEntryPanelIdentifier);
            }
        });
    }

    private void initParsing(RSyntaxPropertiesWrapper rSyntaxPropertiesWrapper, IIdentifier sqlEntryPanelIdentifier) {
        IParserEventsProcessor parserEventsProcessor = rSyntaxPropertiesWrapper.getParserEventsProcessor(sqlEntryPanelIdentifier, this._sess);
        if (null != parserEventsProcessor) {
            parserEventsProcessor.addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

                public void errorsFound(ErrorInfo[] errorInfos) {
                    RSyntaxHighlightTokenMatcher.this.onErrorsFound(errorInfos);
                }
            });
        }
    }

    private void onErrorsFound(ErrorInfo[] errorInfos) {
        boolean errorsChanged = false;
        if (this._currentErrorInfos.size() == errorInfos.length) {
            for (int i = 0; i < errorInfos.length; ++i) {
                if (errorInfos[i].matches(this._currentErrorInfos.get(i))) continue;
                errorsChanged = true;
                break;
            }
        } else {
            errorsChanged = true;
        }
        if (errorsChanged) {
            Vector<ErrorInfo> oldErrorInfos = new Vector<ErrorInfo>(this._currentErrorInfos);
            this._currentErrorInfos.clear();
            this._currentErrorInfos.addAll(Arrays.asList(errorInfos));
            this.forceHighlightUpdateOnErrorPositions(oldErrorInfos);
        }
    }

    private void forceHighlightUpdateOnErrorPositions(Vector<ErrorInfo> oldErrorInfos) {
        RSyntaxUtil.forceHighlightUpdate(this._squirrelRSyntaxTextArea);
    }

    public boolean isError(int offset, int len) {
        for (int i = 0; i < this._currentErrorInfos.size(); ++i) {
            ErrorInfo errInf = this._currentErrorInfos.elementAt(i);
            int editorBeginPos = errInf.beginPos - 1;
            int editorEndPos = errInf.endPos - 1;
            if (offset > editorBeginPos || editorEndPos > offset + len) continue;
            return true;
        }
        return false;
    }

    public boolean isTable(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len, true);
        int tableExtRes = this._sess.getSchemaInfo().isTableExt(this._caseInsensitiveStringBuffer);
        if (2 == tableExtRes || 1 == tableExtRes) {
            String table = this._knownTables.get(this._caseInsensitiveStringBuffer);
            if (null == table) {
                table = new String(buffer, offset, len);
                this._knownTables.put(new CaseInsensitiveString(table), table);
            }
            if (1 == tableExtRes) {
                this._squirrelRSyntaxTextArea.repaint();
            }
            this.fireTableOrViewFound(table);
            return true;
        }
        return false;
    }

    private void fireTableOrViewFound(String tableOrViewName) {
        for (int i = 0; i < this._sqlTokenListeners.size(); ++i) {
            SQLTokenListener sqlTokenListener = this._sqlTokenListeners.elementAt(i);
            sqlTokenListener.tableOrViewFound(tableOrViewName);
        }
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this.removeSQLTokenListener(tl);
        this._sqlTokenListeners.add(tl);
    }

    public boolean isFunction(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len, true);
        if (this._sess.getSchemaInfo().isFunction(this._caseInsensitiveStringBuffer)) {
            return true;
        }
        return this._sess.getSchemaInfo().isProcedure(this._caseInsensitiveStringBuffer);
    }

    public boolean isDataType(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        return this._sess.getSchemaInfo().isDataType(this._caseInsensitiveStringBuffer);
    }

    public boolean isStatementSeparator(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        String statSep = this._sess.getQueryTokenizer().getSQLStatementSeparator();
        if (statSep.length() != len) {
            return false;
        }
        for (int i = 0; i < statSep.length(); ++i) {
            if (buffer[offset + i] == statSep.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumn(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len, true);
        return this._sess.getSchemaInfo().isColumn(this._caseInsensitiveStringBuffer);
    }

    public boolean isKeyword(char[] buffer, int offset, int len) {
        this._caseInsensitiveStringBuffer.setCharBuffer(buffer, offset, len);
        return this._sess.getSchemaInfo().isKeyword(this._caseInsensitiveStringBuffer);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._sqlTokenListeners.remove(tl);
    }
}

