/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.Component;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.gui.dnd.FileEditorDropTargetListener;
import net.sourceforge.squirrel_sql.client.session.BaseSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.PrioritizedCaretMouseListener;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintHandler;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class RSyntaxSQLEntryPanel
extends BaseSQLEntryPanel {
    private static final ILogger s_log = LoggerController.createLogger(RSyntaxSQLEntryPanel.class);
    private SquirrelRSyntaxTextArea _textArea;
    private ISession _session;
    private RSyntaxPropertiesWrapper _propertiesWrapper;
    private DropTarget dt;
    private RTextScrollPane _textScrollPane;

    RSyntaxSQLEntryPanel(ISession session, SyntaxPreferences prefs, HashMap<String, Object> props) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._session = session;
        this._propertiesWrapper = new RSyntaxPropertiesWrapper(props);
        this._textArea = new SquirrelRSyntaxTextArea(session, prefs, this._propertiesWrapper, this.getIdentifier());
        this._textScrollPane = new RTextScrollPane((RTextArea)this._textArea);
        this._textScrollPane.setLineNumbersEnabled(prefs.isLineNumbersEnabled());
        this.dt = new DropTarget((Component)((Object)this._textArea), (DropTargetListener)new FileEditorDropTargetListener(session));
        this._textArea.setDragEnabled(false);
    }

    public int getCaretLineNumber() {
        int pos = this.getCaretPosition();
        return this.getLineOfPosition(pos);
    }

    public int getLineOfPosition(int pos) {
        Document doc = this._textArea.getDocument();
        Element docElem = doc.getDefaultRootElement();
        return docElem.getElementIndex(pos);
    }

    public JTextArea getTextComponent() {
        return this._textArea;
    }

    public boolean getDoesTextComponentHaveScroller() {
        return false;
    }

    public String getText() {
        return this._textArea.getText();
    }

    public void setFont(Font font) {
    }

    public String getSelectedText() {
        return this._textArea.getSelectedText();
    }

    public void setText(String text) {
        this.setText(StringUtilities.removeCarriageReturn((String)text), true);
        this.triggerParser();
    }

    public void setText(String text, boolean select) {
        text = StringUtilities.removeCarriageReturn((String)text);
        this._textArea.setText(text);
        if (select) {
            this.setSelectionEnd(this._textArea.getDocument().getLength());
            this.setSelectionStart(0);
        }
        this.triggerParser();
        this.setCaretPosition(0);
    }

    public void appendText(String sqlScript) {
        sqlScript = StringUtilities.removeCarriageReturn((String)sqlScript);
        this.appendText(sqlScript, false);
    }

    public void appendText(String sqlScript, boolean select) {
        sqlScript = StringUtilities.removeCarriageReturn((String)sqlScript);
        Document doc = this._textArea.getDocument();
        try {
            int start = 0;
            if (select) {
                start = doc.getLength();
            }
            doc.insertString(doc.getLength(), sqlScript, null);
            if (select) {
                this.setSelectionEnd(doc.getLength());
                this.setSelectionStart(start);
            }
            this.triggerParser();
        }
        catch (Exception ex) {
            s_log.error((Object)"Error appending text to text area", (Throwable)ex);
        }
    }

    public int getCaretPosition() {
        return this._textArea.getCaretPosition();
    }

    public void setCaretPosition(int value) {
        this._textArea.setCaretPosition(value);
    }

    public void setTabSize(int tabSize) {
        this._textArea.getDocument().putProperty("tabSize", tabSize);
    }

    public int getSelectionStart() {
        return this._textArea.getSelectionStart();
    }

    public void setSelectionStart(int pos) {
        this._textArea.setSelectionStart(pos);
    }

    public int getSelectionEnd() {
        return this._textArea.getSelectionEnd();
    }

    public void setSelectionEnd(int pos) {
        this._textArea.setSelectionEnd(pos);
    }

    public void replaceSelection(String sqlScript) {
        sqlScript = StringUtilities.removeCarriageReturn((String)sqlScript);
        this._textArea.replaceSelection(sqlScript);
        this.triggerParser();
    }

    public void triggerParser() {
        IParserEventsProcessor parserEventsProcessor = this._propertiesWrapper.getParserEventsProcessor(this.getIdentifier(), this._session);
        if (null != parserEventsProcessor) {
            parserEventsProcessor.triggerParser();
        }
    }

    public void setTextAreaPaintListener(TextAreaPaintListener textAreaPaintListener) {
        this._textArea.setTextAreaPaintListener(textAreaPaintListener);
    }

    public TextAreaPaintHandler getTextAreaPaintHandler() {
        return this._textArea.getTextAreaPaintHandler();
    }

    public void setPrioritizedCaretMouseListener(PrioritizedCaretMouseListener prioritizedCaretMouseListener) {
        this._textArea.setPrioritizedCaretMouseListener(prioritizedCaretMouseListener);
    }

    public boolean hasFocus() {
        return this._textArea.hasFocus();
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(() -> this._textArea.requestFocus());
    }

    public void addMouseListener(MouseListener lis) {
        this._textArea.addMouseListener(lis);
    }

    public void removeMouseListener(MouseListener lis) {
        this._textArea.removeMouseListener(lis);
    }

    public void updateFromPreferences() {
        this._textArea.updateFromPreferences();
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this._textArea.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this._textArea.getDocument().removeUndoableEditListener(listener);
    }

    public int getCaretLinePosition() {
        String textTillCarret = this.getText().substring(0, this.getCaretPosition());
        int lineFeedIndex = textTillCarret.lastIndexOf(10);
        if (-1 == lineFeedIndex) {
            return this.getCaretPosition();
        }
        return this.getCaretPosition() - lineFeedIndex - 1;
    }

    public void addCaretListener(CaretListener lis) {
        this._textArea.removeCaretListener(lis);
        this._textArea.addCaretListener(lis);
    }

    public void removeCaretListener(CaretListener lis) {
        this._textArea.removeCaretListener(lis);
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this._textArea.addSQLTokenListeners(this._session, tl);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._textArea.removeSQLTokenListeners(this._session, tl);
    }

    public ISession getSession() {
        return this._session;
    }

    public boolean hasOwnUndoableManager() {
        return true;
    }

    public IUndoHandler createUndoHandler() {
        return this._textArea.createUndoHandler();
    }

    public void setUndoManager(UndoManager manager) {
    }

    public void sessionEnding() {
        this._textArea.sessionEnding();
        this._session = null;
    }

    public JScrollPane getTextAreaEmbeddedInScrollPane() {
        return this._textScrollPane;
    }
}

