/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextActionUtil;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextBeginAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextBeginLineAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextCopyAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextCutAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextEndAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextEndLineAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPasteAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextSelectAllAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SQuirrelSelectWordAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaDefaultInputMap;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class SquirreLRSyntaxTextAreaUI
extends RSyntaxTextAreaUI {
    private static final KeyStroke RS_KEY_STROKE_TO_UPPER_CASE = KeyStroke.getKeyStroke(85, 192);
    private static final KeyStroke RS_KEY_STROKE_TO_LOWER_CASE = KeyStroke.getKeyStroke(76, 192);
    private static final KeyStroke RS_KEY_STROKE_LINE_UP = KeyStroke.getKeyStroke(38, 192);
    private static final KeyStroke RS_KEY_STROKE_LINE_DOWN = KeyStroke.getKeyStroke(40, 192);
    private static final KeyStroke RS_KEY_STROKE_SELECT_WORD = KeyStroke.getKeyStroke(87, 128);
    private static final EditorKit _squirrel_defaultKit = new RSyntaxTextAreaEditorKit(){

        public Action[] getActions() {
            return TextAction.augmentList(super.getActions(), new Action[]{new SQuirrelSelectWordAction(), new SQuirrelCopyAction(), new SQuirrelCutAction()});
        }
    };
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;

    public SquirreLRSyntaxTextAreaUI(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        super((JComponent)((Object)squirrelRSyntaxTextArea));
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
    }

    protected InputMap getRTextAreaInputMap() {
        InputMapUIResource map = new InputMapUIResource();
        InputMap shared = (InputMap)UIManager.get("RSyntaxTextAreaUI.inputMap");
        if (shared == null) {
            shared = new RSyntaxTextAreaDefaultInputMap();
            this.modifyKeystrokes(shared);
            UIManager.put("RSyntaxTextAreaUI.inputMap", shared);
        }
        map.setParent(shared);
        return map;
    }

    private void modifyKeystrokes(InputMap sharedIM) {
        sharedIM.remove(KeyStroke.getKeyStroke(32, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(74, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(68, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(10, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(109, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(38, 512));
        sharedIM.remove(KeyStroke.getKeyStroke(40, 512));
        sharedIM.remove(KeyStroke.getKeyStroke(86, 192));
        sharedIM.remove(KeyStroke.getKeyStroke(75, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(127, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(' '));
        sharedIM.put(SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke(), "RTA.UpperCaseAction");
        sharedIM.put(SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke(), "RTA.LowerCaseAction");
        sharedIM.put(SquirreLRSyntaxTextAreaUI.getLineUpKeyStroke(), "RTA.LineUpAction");
        sharedIM.put(SquirreLRSyntaxTextAreaUI.getLineDownKeyStroke(), "RTA.LineDownAction");
        sharedIM.put(SquirreLRSyntaxTextAreaUI.getSelectWordStroke(), "select-word");
        sharedIM.remove(KeyStroke.getKeyStroke(82, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(90, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(89, 128));
        sharedIM.remove(KeyStroke.getKeyStroke(67, 128));
        sharedIM.put(TextCopyAction.getKeyStroke(), "copy-to-clipboard");
        sharedIM.remove(KeyStroke.getKeyStroke(88, 128));
        sharedIM.put(TextCutAction.getKeyStroke(), "cut-to-clipboard");
        sharedIM.remove(KeyStroke.getKeyStroke(86, 128));
        sharedIM.put(TextPasteAction.getKeyStroke(), "paste-from-clipboard");
        sharedIM.remove(KeyStroke.getKeyStroke(65, 128));
        sharedIM.put(TextSelectAllAction.getKeyStroke(), "select-all");
        sharedIM.remove(KeyStroke.getKeyStroke(36, 0));
        sharedIM.put(TextBeginLineAction.getKeyStroke(), "caret-begin-line");
        sharedIM.remove(KeyStroke.getKeyStroke(35, 0));
        sharedIM.put(TextEndLineAction.getKeyStroke(), "caret-end-line");
        sharedIM.remove(KeyStroke.getKeyStroke(36, 128));
        sharedIM.put(TextBeginAction.getKeyStroke(), "caret-begin");
        sharedIM.remove(KeyStroke.getKeyStroke(35, 128));
        sharedIM.put(TextEndAction.getKeyStroke(), "caret-end");
    }

    public IUndoHandler createUndoHandler() {
        return new IUndoHandler(){

            public Action getUndoAction() {
                return SquirreLRSyntaxTextAreaUI.this.onGetUndoAction();
            }

            public Action getRedoAction() {
                return SquirreLRSyntaxTextAreaUI.this.onGetRedoAction();
            }
        };
    }

    private Action onGetUndoAction() {
        return SquirreLRSyntaxTextAreaUI.getActionForName(this._squirrelRSyntaxTextArea, "RTA.UndoAction");
    }

    private Action onGetRedoAction() {
        return SquirreLRSyntaxTextAreaUI.getActionForName(this._squirrelRSyntaxTextArea, "RTA.RedoAction");
    }

    public static Action getActionForName(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea, String actionName) {
        Action[] actions;
        for (Action action : actions = squirrelRSyntaxTextArea.getUI().getEditorKit((JTextComponent)((Object)squirrelRSyntaxTextArea)).getActions()) {
            if (!actionName.equals(action.getValue("Name"))) continue;
            return action;
        }
        throw new IllegalStateException("Action " + actionName + "not found");
    }

    public static KeyStroke getToUpperCaseKeyStroke() {
        return KeyStroke.getKeyStroke(Main.getApplication().getShortcutManager().registerAccelerator("RTA.UpperCaseAction", RS_KEY_STROKE_TO_UPPER_CASE));
    }

    public static KeyStroke getToLowerCaseKeyStroke() {
        return KeyStroke.getKeyStroke(Main.getApplication().getShortcutManager().registerAccelerator("RTA.LowerCaseAction", RS_KEY_STROKE_TO_LOWER_CASE));
    }

    public static KeyStroke getLineUpKeyStroke() {
        return KeyStroke.getKeyStroke(Main.getApplication().getShortcutManager().registerAccelerator("RTA.LineUpAction", RS_KEY_STROKE_LINE_UP));
    }

    public static KeyStroke getLineDownKeyStroke() {
        return KeyStroke.getKeyStroke(Main.getApplication().getShortcutManager().registerAccelerator("RTA.LineDownAction", RS_KEY_STROKE_LINE_DOWN));
    }

    public static KeyStroke getSelectWordStroke() {
        return KeyStroke.getKeyStroke(Main.getApplication().getShortcutManager().registerAccelerator("select-word", RS_KEY_STROKE_SELECT_WORD));
    }

    public EditorKit getEditorKit(JTextComponent tc) {
        return _squirrel_defaultKit;
    }

    private static class SQuirrelCutAction
    extends RTextAreaEditorKit.CutAction {
        private SQuirrelCutAction() {
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            TextActionUtil.wrapCutActionToSelectLineOnEmptySelection((JTextComponent)textArea, (ActionEvent)e, () -> SQuirrelCutAction.super.actionPerformedImpl(e, textArea));
        }
    }

    private static class SQuirrelCopyAction
    extends RTextAreaEditorKit.CopyAction {
        private SQuirrelCopyAction() {
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            TextActionUtil.wrapCopyActionToSelectLineOnEmptySelection((JTextComponent)textArea, (ActionEvent)e, () -> SQuirrelCopyAction.super.actionPerformedImpl(e, textArea));
        }
    }
}

