/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;

public class OracleInternalFrame
extends SessionDialogWidget {
    private static final String PREF_KEY_ORACLE_FRAME_REPL = "@@";
    private static final String PREF_KEY_ORACLE_FRAME_WIDTH = "Squirrel.oracle.@@_WIDTH";
    private static final String PREF_KEY_ORACLE_FRAME_HEIGHT = "Squirrel.oracle.@@_HEIGHT";
    private static final String PREF_KEY_ORACLE_FRAME_STAY_ON_TOP = "Squirrel.oracle.@@_STAY_ON_TOP";
    private static final String PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC = "Squirrel.oracle.@@_AUTO_REFRESH_SEC";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OracleInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(OracleInternalFrame.class);
    private String _repl = "";

    public OracleInternalFrame(ISession session, String title) {
        super(title, true, true, true, true, session);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    protected void initFromPrefs(String repl, OracleInternalFrameCallback callBack) {
        this._repl = repl;
        int width = Props.getInt((String)PREF_KEY_ORACLE_FRAME_WIDTH.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)400);
        int height = Props.getInt((String)PREF_KEY_ORACLE_FRAME_HEIGHT.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)200);
        boolean stayOnTop = Props.getBoolean((String)PREF_KEY_ORACLE_FRAME_STAY_ON_TOP.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (boolean)false);
        int autoRefeshPeriod = Props.getInt((String)PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)10);
        autoRefeshPeriod = Math.max(1, autoRefeshPeriod);
        callBack.createPanelAndToolBar(stayOnTop, autoRefeshPeriod);
        SwingUtilities.invokeLater(() -> this.sizeAndDisplay(width, height));
    }

    private void sizeAndDisplay(int width, int height) {
        Rectangle rectMain = this.getSession().getApplication().getMainFrame().getDesktopContainer().getBounds();
        Rectangle rect = new Rectangle();
        rect.width = Math.min(rectMain.width, width);
        rect.height = Math.min(rectMain.height, height);
        try {
            this.setMaximum(false);
        }
        catch (PropertyVetoException e) {
            s_log.error((Object)e);
        }
        this.setBounds(rect);
        DialogWidget.centerWithinDesktop((DialogWidget)this);
        this.setVisible(true);
    }

    protected void internalFrameClosing(boolean stayOnTop, int autoRefreshPeriod) {
        Rectangle rect = this.getBounds();
        if (rect != null) {
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_WIDTH.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.width);
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_HEIGHT.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.height);
        }
        Props.putBoolean((String)PREF_KEY_ORACLE_FRAME_STAY_ON_TOP.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (boolean)stayOnTop);
        Props.putInt((String)PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)autoRefreshPeriod);
    }
}

