/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle;

import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;

public class OracleToolBar
extends ToolBar {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OracleToolBar.class);
    private final ISession _session;
    private final OracleInternalFrame _oracleInternalFrame;
    private JCheckBox _stayOnTop;

    public OracleToolBar(ISession session, OracleInternalFrame oracleInternalFrame) {
        this._session = session;
        this._oracleInternalFrame = oracleInternalFrame;
    }

    protected void addStayOnTop(boolean stayOnTop) {
        this._stayOnTop = new JCheckBox(s_stringMgr.getString("oracle.dboutputStayOnTop"), false);
        this._stayOnTop.setSelected(stayOnTop);
        this._stayOnTop.setVisible(this._session.getApplication().getDesktopStyle().supportsLayers());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OracleToolBar.this.onStayOnTopChanged(OracleToolBar.this._stayOnTop.isSelected());
                OracleToolBar.this._stayOnTop.addActionListener(e -> OracleToolBar.this.onStayOnTopChanged(OracleToolBar.this._stayOnTop.isSelected()));
            }
        });
        this.add(this._stayOnTop);
    }

    private void onStayOnTopChanged(boolean selected) {
        if (selected) {
            this._oracleInternalFrame.setLayer((int)JLayeredPane.PALETTE_LAYER);
        } else {
            this._oracleInternalFrame.setLayer((int)JLayeredPane.DEFAULT_LAYER);
        }
        this._oracleInternalFrame.toFront();
    }

    public boolean isStayOnTop() {
        return this._stayOnTop.isSelected();
    }
}

