/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.SGAtrace;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleToolBar;
import net.sourceforge.squirrel_sql.plugins.oracle.SGAtrace.GetSGATraceAction;
import net.sourceforge.squirrel_sql.plugins.oracle.SGAtrace.SGATracePanel;

public class SGATraceInternalFrame
extends OracleInternalFrame {
    private static final String PREF_PART_SGA_FRAME = "SGAFrame";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SGATraceInternalFrame.class);
    private SGATracePanel _sgaTracePanel;
    private SGATraceToolBar _toolBar;
    private transient Resources _resources;

    public SGATraceInternalFrame(ISession session, Resources resources) {
        super(session, s_stringMgr.getString("oracle.sgaTitle", new Object[]{session.getTitle()}));
        this._resources = resources;
        this.createGUI();
    }

    private void createGUI() {
        this.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public boolean widgetClosing(WidgetEvent e) {
                SGATraceInternalFrame.super.internalFrameClosing(SGATraceInternalFrame.this._toolBar.isStayOnTop(), SGATraceInternalFrame.this._sgaTracePanel.getAutoRefreshPeriod());
                SGATraceInternalFrame.this._sgaTracePanel.setAutoRefresh(false);
                return true;
            }
        });
        ImageIcon icon = this._resources.getIcon(((Object)((Object)this)).getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        OracleInternalFrameCallback cb = (stayOnTop, autoRefreshPeriod) -> this.onCreatePanelAndToolBar(stayOnTop, autoRefreshPeriod);
        this.initFromPrefs(PREF_PART_SGA_FRAME, cb);
    }

    private void onCreatePanelAndToolBar(boolean stayOnTop, int autoRefreshPeriod) {
        this._sgaTracePanel = new SGATracePanel(this.getSession(), autoRefreshPeriod);
        this._toolBar = new SGATraceToolBar(this.getSession(), stayOnTop, autoRefreshPeriod);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)((Object)this._toolBar), "North");
        contentPanel.add((Component)this._sgaTracePanel, "Center");
        this.setContentPane(contentPanel);
    }

    private class SGATraceToolBar
    extends OracleToolBar {
        SGATraceToolBar(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            super(session, SGATraceInternalFrame.this);
            this.createGUI(session, stayOnTop, autoRefeshPeriod);
        }

        private void createGUI(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            IApplication app = session.getApplication();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add((Action)((Object)new GetSGATraceAction(app, SGATraceInternalFrame.this._resources, SGATraceInternalFrame.this._sgaTracePanel)));
            this.addStayOnTop(stayOnTop);
            JCheckBox autoRefresh = new JCheckBox(s_stringMgr.getString("oracle.enableAutoRefresh"), false);
            autoRefresh.addActionListener(e -> SGATraceInternalFrame.this._sgaTracePanel.setAutoRefresh(autoRefresh.isSelected()));
            this.add(autoRefresh);
            SpinnerNumberModel model = new SpinnerNumberModel(autoRefeshPeriod, 1, 60, 5);
            JSpinner refreshRate = new JSpinner(model);
            refreshRate.addChangeListener(e -> SGATraceInternalFrame.this._sgaTracePanel.setAutoRefreshPeriod(model.getNumber().intValue()));
            this.add(refreshRate);
            this.add(new JLabel(s_stringMgr.getString("oracle.refreshSecons")));
        }
    }
}

