/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.SGAtrace;

import java.awt.BorderLayout;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OraclePlugin;
import net.sourceforge.squirrel_sql.plugins.oracle.common.AutoWidthResizeTable;

public class SGATracePanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SGATracePanel.class);
    private static final String sgaTraceSQL = "  SELECT a.SQL_Text,          a.First_Load_Time,          b.username,          a.Parse_Calls,          a.Executions,          a.Sorts,          a.Disk_Reads,          a.Buffer_Gets,          a.Rows_Processed,          DECODE ( a.Executions,                   0,                   'N/A',                   ROUND ( a.Sorts / a.Executions,                           3 ) ),          DECODE ( a.Executions,                   0,                   'N/A',                   ROUND ( a.Disk_Reads / a.Executions,                           3 ) ),          DECODE ( a.Executions,                   0,                   'N/A',                   ROUND ( a.Buffer_Gets / a.Executions,                           3 ) ),          DECODE ( a.Executions,                   0,                   'N/A',                   ROUND ( a.Rows_Processed / a.Executions,                           3 ) ),          DECODE ( a.Rows_Processed,                   0,                   'N/A',                   ROUND ( a.Sorts / a.Rows_Processed,                           3 ) ),          DECODE ( a.Rows_Processed,                   0,                   'N/A',                   ROUND ( a.Disk_Reads / a.Rows_Processed,                           3 ) ) ,          DECODE ( a.Rows_Processed,                   0,                   'N/A',                   ROUND ( a.Buffer_Gets / a.Rows_Processed,                           3 ) ),          a.Address || ':' || a.Hash_Value     FROM v$sqlarea a,          sys.all_users b    WHERE a.parsing_user_id = b.user_id ";
    private ISession _session;
    private AutoWidthResizeTable _sgaTrace;
    private boolean hasResized = false;
    private Timer _refreshTimer = new Timer(true);
    private boolean _autoRefresh = false;
    private int _refreshPeriod = 10;

    public SGATracePanel(ISession session, int autoRefreshPeriod) {
        this._session = session;
        this._refreshPeriod = autoRefreshPeriod;
        this.createGUI();
    }

    public ISession getSession() {
        return this._session;
    }

    private void resetTimer() {
        if (this._refreshTimer != null) {
            this._refreshTimer.cancel();
            this._refreshTimer = null;
        }
        if (this._autoRefresh && this._refreshPeriod > 0) {
            this._refreshTimer = new Timer(true);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    GUIUtils.processOnSwingEventThread(() -> SGATracePanel.this.populateSGATrace());
                }
            };
            this._refreshTimer.scheduleAtFixedRate(timerTask, this._refreshPeriod * 1000, (long)(this._refreshPeriod * 1000));
        }
    }

    public void setAutoRefresh(boolean enable) {
        if (enable != this._autoRefresh) {
            this._autoRefresh = enable;
            this.resetTimer();
        }
    }

    public void setAutoRefreshPeriod(int seconds) {
        if (this._refreshPeriod != seconds) {
            this._refreshPeriod = seconds;
            this.resetTimer();
        }
    }

    public int getAutoRefreshPeriod() {
        return this._refreshPeriod;
    }

    private DefaultTableModel createTableModel() {
        DefaultTableModel tm = new DefaultTableModel();
        tm.addColumn(s_stringMgr.getString("oracle.sqlText"));
        tm.addColumn(s_stringMgr.getString("oracle.firstLoadTime"));
        tm.addColumn(s_stringMgr.getString("oracle.parseSchema"));
        tm.addColumn(s_stringMgr.getString("oracle.parseCalla"));
        tm.addColumn(s_stringMgr.getString("oracle.execution"));
        tm.addColumn(s_stringMgr.getString("oracle.sorts"));
        tm.addColumn(s_stringMgr.getString("oracle.diskReads"));
        tm.addColumn(s_stringMgr.getString("oracle.bufferGets"));
        tm.addColumn(s_stringMgr.getString("oracle.rows"));
        tm.addColumn(s_stringMgr.getString("oracle.sortsPerExec"));
        tm.addColumn(s_stringMgr.getString("oracle.diskReadsPerExec"));
        tm.addColumn(s_stringMgr.getString("oracle.bufferPerExec"));
        tm.addColumn(s_stringMgr.getString("oracle.rowsPerExec"));
        tm.addColumn(s_stringMgr.getString("oracle.sortsPerExec"));
        tm.addColumn(s_stringMgr.getString("oracle.diskReadsPerRow"));
        tm.addColumn(s_stringMgr.getString("oracle.buffer.getsPerRow"));
        return tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateSGATrace() {
        ResultSet rs;
        PreparedStatement s;
        block8: {
            if (!OraclePlugin.checkObjectAccessible(this._session, sgaTraceSQL)) {
                return;
            }
            s = null;
            rs = null;
            try {
                DefaultTableModel tm;
                s = this._session.getSQLConnection().getConnection().prepareStatement(sgaTraceSQL);
                if (!s.execute()) break block8;
                rs = s.getResultSet();
                if (this._sgaTrace.getModel().getColumnCount() > 0 && this._sgaTrace.getModel() instanceof DefaultTableModel) {
                    tm = (DefaultTableModel)this._sgaTrace.getModel();
                    tm.setRowCount(0);
                } else {
                    tm = this.createTableModel();
                }
                while (rs.next()) {
                    String sqlText = rs.getString(1);
                    String flt = rs.getString(2);
                    String schema = rs.getString(3);
                    String calls = rs.getString(4);
                    String executions = rs.getString(5);
                    String sorts = rs.getString(6);
                    String diskReads = rs.getString(7);
                    String bufGets = rs.getString(8);
                    String rows = rs.getString(9);
                    String sortsExec = rs.getString(10);
                    String diskReadsExec = rs.getString(11);
                    String rowsExec = rs.getString(12);
                    String sortsRows = rs.getString(13);
                    String diskReadsRow = rs.getString(14);
                    String bufGetsRow = rs.getString(15);
                    tm.addRow(new Object[]{sqlText, flt, schema, calls, executions, sorts, diskReads, bufGets, rows, sortsExec, diskReadsExec, rowsExec, sortsRows, diskReadsRow, bufGetsRow});
                }
                this._sgaTrace.setModel(tm);
                if (this.hasResized) break block8;
                this.hasResized = true;
                this._sgaTrace.resizeColumnWidth(300);
            }
            catch (SQLException ex) {
                try {
                    this._session.showErrorMessage((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs);
                    SQLUtilities.closeStatement(s);
                    throw throwable;
                }
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)s);
            }
        }
        SQLUtilities.closeResultSet(rs);
        SQLUtilities.closeStatement((Statement)s);
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this._sgaTrace = new AutoWidthResizeTable(new DefaultTableModel());
        this._sgaTrace.setAutoResizeMode(0);
        this._sgaTrace.setAutoCreateRowSorter(true);
        this.add(new JScrollPane(this._sgaTrace));
        this.populateSGATrace();
    }
}

