/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.constraint;

import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.AbstractConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintColumnInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintInfo;

public class FKConstraintSource
extends AbstractConstraintSource {
    public FKConstraintSource(ISession session, ConstraintInfo ci) {
        super(session, ci);
    }

    private String createReferencesClause() throws Exception {
        List<ConstraintColumnInfo> cols = this.readConstraintColumns(this.ci.getROwner(), this.ci.getRConstraintName());
        String colsString = this.columnNamesAsCSV(cols);
        String clause = "REFERENCES " + this.ci.getROwner() + "." + cols.get(0).getTableName() + " ( " + colsString + " )";
        return clause;
    }

    protected String buildDeleteClause() {
        String clause = null;
        if (!"NO ACTION".equals(this.ci.getDeleteRule())) {
            clause = "ON DELETE " + this.ci.getDeleteRule();
        }
        return clause;
    }

    @Override
    public void buildConstraintClause() throws Exception {
        this.constraintClause = "CONSTRAINT " + this.ci.getConstraintName() + " FOREIGN KEY ( " + this.columnNamesAsCSV(this.columns) + " ) \n";
        this.constraintClause = this.constraintClause + this.createReferencesClause();
        String deleteClause = this.buildDeleteClause();
        if (deleteClause != null) {
            this.constraintClause = this.constraintClause + " \n  " + this.buildDeleteClause();
        }
    }
}

