/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.dboutput;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleToolBar;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.ClearDBOutputAction;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.DBOutputPanel;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.GetDBOutputAction;

public class DBOutputInternalFrame
extends OracleInternalFrame {
    private static final String PREF_PART_DB_OUTPUT_FRAME = "DBOutputFrame";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBOutputInternalFrame.class);
    private DBOutputPanel _dbOutputPanel;
    private DBOutputToolBar _toolBar;
    private Resources _resources;

    public DBOutputInternalFrame(ISession session, Resources resources) {
        super(session, s_stringMgr.getString("oracle.dbOutputTitle", new Object[]{session.getTitle()}));
        this._resources = resources;
        this.createGUI(session);
    }

    private void createGUI(ISession session) {
        this.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public boolean widgetClosing(WidgetEvent e) {
                DBOutputInternalFrame.this.onWidgetClosing();
                return true;
            }
        });
        ImageIcon icon = this._resources.getIcon(((Object)((Object)this)).getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        OracleInternalFrameCallback cb = (stayOnTop, autoRefreshPeriod) -> this.onCreatePanelAndToolBar(stayOnTop, autoRefreshPeriod);
        this.initFromPrefs(PREF_PART_DB_OUTPUT_FRAME, cb);
    }

    private void onCreatePanelAndToolBar(boolean stayOnTop, int autoRefreshPeriod) {
        this._dbOutputPanel = new DBOutputPanel(this.getSession(), autoRefreshPeriod);
        this._toolBar = new DBOutputToolBar(this.getSession(), stayOnTop, autoRefreshPeriod);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)((Object)this._toolBar), "North");
        contentPanel.add((Component)this._dbOutputPanel, "Center");
        this.setContentPane(contentPanel);
        this._dbOutputPanel.setAutoRefreshPeriod(autoRefreshPeriod);
    }

    private void onWidgetClosing() {
        this.internalFrameClosing(this._toolBar.isStayOnTop(), this._dbOutputPanel.getAutoRefreshPeriod());
        this._dbOutputPanel.setAutoRefresh(false);
    }

    private class DBOutputToolBar
    extends OracleToolBar {
        private JCheckBox _autoRefresh;

        DBOutputToolBar(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            super(session, DBOutputInternalFrame.this);
            this.createGUI(session, stayOnTop, autoRefeshPeriod);
        }

        private void createGUI(ISession session, boolean stayOnTop, int autoRefreshPeriod) {
            IApplication app = session.getApplication();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add((Action)((Object)new GetDBOutputAction(app, DBOutputInternalFrame.this._resources, DBOutputInternalFrame.this._dbOutputPanel)));
            this.add((Action)((Object)new ClearDBOutputAction(app, DBOutputInternalFrame.this._resources, DBOutputInternalFrame.this._dbOutputPanel)));
            this.addStayOnTop(stayOnTop);
            this._autoRefresh = new JCheckBox(s_stringMgr.getString("oracle.dboutputEnableAutoRefer"), false);
            this._autoRefresh.addActionListener(e -> DBOutputInternalFrame.this._dbOutputPanel.setAutoRefresh(this._autoRefresh.isSelected()));
            this.add(this._autoRefresh);
            SpinnerNumberModel model = new SpinnerNumberModel(autoRefreshPeriod, 1, 60, 5);
            JSpinner refreshRate = new JSpinner(model);
            refreshRate.addChangeListener(e -> DBOutputInternalFrame.this._dbOutputPanel.setAutoRefreshPeriod(model.getNumber().intValue()));
            this.add(refreshRate);
            this.add(new JLabel(s_stringMgr.getString("oracle.Seconds2")));
        }
    }
}

