/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StatementExecutionTimeOutHandler;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ConstraintParentInfo;

public class ConstraintParentExpander
implements INodeExpander {
    private static String SQL = "select constraint_name from all_constraints where owner = ? and table_name = ? order by constraint_name asc";
    private IObjectTypes _objectTypes;

    public ConstraintParentExpander(IObjectTypes objectTypes) {
        this._objectTypes = objectTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        IDatabaseObjectInfo tableInfo = ((ConstraintParentInfo)parentDbinfo).getTableInfo();
        String schemaName = parentDbinfo.getSchemaName();
        try (PreparedStatement pstmt = StatementExecutionTimeOutHandler.prepareStatement((ISQLConnection)conn, (String)SQL);){
            pstmt.setString(1, tableInfo.getSchemaName());
            pstmt.setString(2, tableInfo.getSimpleName());
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    DatabaseObjectInfo doi = new DatabaseObjectInfo(null, schemaName, rs.getString(1), this._objectTypes.getConstraint(), (ISQLDatabaseMetaData)md);
                    childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)doi));
                }
            }
        }
        return childNodes;
    }
}

