/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.SQLException;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.DatabaseExpander;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.InstanceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.SessionDetailsTab;

public class DefaultDatabaseExpander
extends DatabaseExpander {
    private IObjectTypes _objectTypes;

    public DefaultDatabaseExpander(ISession session, IObjectTypes objectTypes) {
        super(session);
        this._objectTypes = objectTypes;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        try {
            List childNodes = super.createChildren(session, parentNode);
            SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
            DatabaseObjectInfo dboInfo = new DatabaseObjectInfo(null, null, "USERS", this._objectTypes.getUserParent(), (ISQLDatabaseMetaData)md);
            ObjectTreeNode node = new ObjectTreeNode(session, (IDatabaseObjectInfo)dboInfo);
            childNodes.add(node);
            if (InstanceDetailsTab.isAccessible(session)) {
                dboInfo = new DatabaseObjectInfo(null, null, "INSTANCES", this._objectTypes.getInstanceParent(), (ISQLDatabaseMetaData)md);
                node = new ObjectTreeNode(session, (IDatabaseObjectInfo)dboInfo);
                childNodes.add(node);
            }
            if (SessionDetailsTab.isAccessible(session)) {
                dboInfo = new DatabaseObjectInfo(null, null, "SESSIONS", this._objectTypes.getSessionParent(), (ISQLDatabaseMetaData)md);
                node = new ObjectTreeNode(session, (IDatabaseObjectInfo)dboInfo);
                childNodes.add(node);
            }
            return childNodes;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

