/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ConstraintParentInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.OracleTableIndexExtractor;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.TriggerParentInfo;

public class TableExpander
implements INodeExpander {
    private IObjectTypes _objectTypes;

    public TableExpander(IObjectTypes objectTypes) {
        this._objectTypes = objectTypes;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String schemaName = parentDbinfo.getSchemaName();
        TriggerParentInfo dbinfo = new TriggerParentInfo(parentDbinfo, schemaName, md, this._objectTypes);
        this.addNode(session, childNodes, (IDatabaseObjectInfo)dbinfo, new INodeExpander[0]);
        ConstraintParentInfo cstrinfo = new ConstraintParentInfo(parentDbinfo, schemaName, md, this._objectTypes);
        this.addNode(session, childNodes, (IDatabaseObjectInfo)cstrinfo, new INodeExpander[0]);
        IndexParentInfo indexInfo = new IndexParentInfo(parentDbinfo, schemaName, md);
        IndexParentExpander tableIndexExpander = new IndexParentExpander();
        tableIndexExpander.setTableIndexExtractor((ITableIndexExtractor)new OracleTableIndexExtractor());
        this.addNode(session, childNodes, (IDatabaseObjectInfo)indexInfo, new INodeExpander[]{tableIndexExpander});
        return childNodes;
    }

    private void addNode(ISession session, List<ObjectTreeNode> childNodes, IDatabaseObjectInfo node, INodeExpander ... expanders) {
        ObjectTreeNode child = new ObjectTreeNode(session, node);
        for (INodeExpander expander : expanders) {
            child.addExpander(expander);
        }
        childNodes.add(child);
    }
}

