/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.prefs.OraclePreferenceBean;

public class OraclePluginPreferencesPanel
extends PluginQueryTokenizerPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OraclePluginPreferencesPanel.class);
    private static final JCheckBox excludeRecycleBinTablesCheckBox = new JCheckBox(i18n.HIDE_RECYCLE_BIN_CB_LABEL);
    private static final JCheckBox showErrorOffsetCheckBox = new JCheckBox(i18n.SHOW_ERROR_OFFSET_LABEL);
    private static final JCheckBox initSessionTimezoneCheckBox = new JCheckBox(i18n.SESSION_TIMEZONE_LABEL);
    private static final JTextField sessionTimezoneTextField = new JTextField();

    public OraclePluginPreferencesPanel(PluginQueryTokenizerPreferencesManager prefsMgr) {
        super(prefsMgr, "Oracle");
        this.setName("OraclePluginPreferencesPanel");
    }

    protected JPanel createTopPanel() {
        JPanel result = super.createTopPanel();
        int lastY = this.lastY;
        this.addRecycleBinCheckBox(result, 0, lastY++);
        this.addShowErrorOffsetCheckBox(result, 0, lastY++);
        this.addSessionTimezoneCheckBox(result, 0, lastY++);
        this.addSessionTimezoneTextField(result, 0, lastY++);
        return result;
    }

    private void addRecycleBinCheckBox(JPanel result, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 0, 0);
        excludeRecycleBinTablesCheckBox.setToolTipText(i18n.HIDE_RECYCLE_BIN_CB_TT);
        result.add((Component)excludeRecycleBinTablesCheckBox, c);
    }

    private void addShowErrorOffsetCheckBox(JPanel result, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 0, 0);
        showErrorOffsetCheckBox.setToolTipText(i18n.SHOW_ERROR_OFFSET_TT);
        result.add((Component)showErrorOffsetCheckBox, c);
    }

    private void addSessionTimezoneCheckBox(JPanel result, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 0, 0);
        initSessionTimezoneCheckBox.setToolTipText(i18n.SESSION_TIMEZONE_TT);
        initSessionTimezoneCheckBox.setName("initSessionTimezoneCheckBox");
        result.add((Component)initSessionTimezoneCheckBox, c);
        initSessionTimezoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sessionTimezoneTextField.setEnabled(initSessionTimezoneCheckBox.isSelected());
            }
        });
    }

    private void addSessionTimezoneTextField(JPanel result, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 35, 0, 0);
        sessionTimezoneTextField.setToolTipText(i18n.SESSION_TIMEZONE_TT);
        sessionTimezoneTextField.setName("sessionTimezoneTextField");
        result.add((Component)sessionTimezoneTextField, c);
    }

    protected void loadData() {
        super.loadData();
        IQueryTokenizerPreferenceBean prefs = this._prefsManager.getPreferences();
        OraclePreferenceBean oraclePrefs = (OraclePreferenceBean)prefs;
        excludeRecycleBinTablesCheckBox.setSelected(oraclePrefs.isExcludeRecycleBinTables());
        showErrorOffsetCheckBox.setSelected(oraclePrefs.isShowErrorOffset());
        if (oraclePrefs.getInitSessionTimezone()) {
            initSessionTimezoneCheckBox.setSelected(true);
            sessionTimezoneTextField.setEnabled(true);
        } else {
            initSessionTimezoneCheckBox.setSelected(false);
            sessionTimezoneTextField.setEnabled(false);
        }
        if (oraclePrefs.getSessionTimezone() != null && !"".equals(oraclePrefs.getSessionTimezone())) {
            sessionTimezoneTextField.setText(oraclePrefs.getSessionTimezone());
        } else {
            sessionTimezoneTextField.setText(TimeZone.getDefault().getID());
        }
    }

    protected void save() {
        IQueryTokenizerPreferenceBean prefs = this._prefsManager.getPreferences();
        OraclePreferenceBean oraclePrefs = (OraclePreferenceBean)prefs;
        oraclePrefs.setExcludeRecycleBinTables(excludeRecycleBinTablesCheckBox.isSelected());
        oraclePrefs.setShowErrorOffset(showErrorOffsetCheckBox.isSelected());
        oraclePrefs.setInitSessionTimezone(initSessionTimezoneCheckBox.isSelected());
        if (initSessionTimezoneCheckBox.isSelected()) {
            oraclePrefs.setSessionTimezone(sessionTimezoneTextField.getText());
        }
        super.save();
    }

    static interface i18n {
        public static final String HIDE_RECYCLE_BIN_CB_LABEL = s_stringMgr.getString("OraclePluginPreferencesPanel.hideRecycleBinCheckBoxLabel");
        public static final String HIDE_RECYCLE_BIN_CB_TT = s_stringMgr.getString("OraclePluginPreferencesPanel.hideRecycleBinCheckBoxToolTip");
        public static final String SESSION_TIMEZONE_LABEL = s_stringMgr.getString("OraclePluginPreferencesPanel.sessionTimezoneLabel");
        public static final String SESSION_TIMEZONE_TT = s_stringMgr.getString("OraclePluginPreferencesPanel.sessionTimezoneTT");
        public static final String SHOW_ERROR_OFFSET_LABEL = s_stringMgr.getString("OraclePluginPreferencesPanel.showErrorOffsetLabel");
        public static final String SHOW_ERROR_OFFSET_TT = s_stringMgr.getString("OraclePluginPreferencesPanel.showErrorOffsetTT");
    }
}

