/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.types;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class OracleXmlTypeDataTypeComponent
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final String XML_TYPE_CLASSNAME = "oracle.xdb.XMLType";
    private static Class<?> XML_TYPE_CLASS = null;
    private static ILogger s_log = LoggerController.createLogger(OracleXmlTypeDataTypeComponent.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OracleXmlTypeDataTypeComponent.class);

    public boolean canDoFileIO() {
        return true;
    }

    public String getClassName() {
        return "java.lang.String";
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"getDefaultValue: not yet implemented");
        }
        return dbDefaultValue;
    }

    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        return super.getWhereClauseValue(value, md);
    }

    public boolean isEditableInCell(Object originalValue) {
        return !i18n.CELL_ERROR_MSG.equals(originalValue);
    }

    public boolean isEditableInPopup(Object originalValue) {
        return !i18n.CELL_ERROR_MSG.equals(originalValue);
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public Object readResultSet(ResultSet rs, int idx, boolean limitDataRead) throws SQLException {
        Object result = null;
        try {
            Object o = rs.getObject(idx);
            if (o == null) {
                return "<null>";
            }
            if ("oracle.sql.OPAQUE".equals(o.getClass().getName())) {
                Object stringValueResult;
                Method createXmlMethod = this.getCreateXmlMethod(o.getClass());
                Object xmlTypeObj = createXmlMethod.invoke(null, o);
                Method getStringValMethod = XML_TYPE_CLASS.getMethod("getStringVal", null);
                result = stringValueResult = getStringValMethod.invoke(xmlTypeObj, (Object[])null);
            } else if (XML_TYPE_CLASSNAME.equals(o.getClass().getName())) {
                Object stringValueResult;
                XML_TYPE_CLASS = o.getClass();
                Method getStringValMethod = XML_TYPE_CLASS.getMethod("getStringVal", null);
                result = stringValueResult = getStringValMethod.invoke(o, (Object[])null);
            } else {
                result = o;
            }
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)"Perhaps the XDK, which contains the class oracle.xdb.XMLType is not in the CLASSPATH?", (Throwable)e);
        }
        catch (Exception e) {
            s_log.error((Object)"Unexpected exception while attempting to read SYS.XMLType column", (Throwable)e);
        }
        if (result == null) {
            result = i18n.CELL_ERROR_MSG;
        }
        return result;
    }

    private Method getCreateXmlMethod(Class<?> ... argClasses) throws ClassNotFoundException, NoSuchMethodException {
        Method createXmlMethod;
        block9: {
            if (XML_TYPE_CLASS == null) {
                XML_TYPE_CLASS = Class.forName(XML_TYPE_CLASSNAME);
            }
            createXmlMethod = null;
            try {
                createXmlMethod = XML_TYPE_CLASS.getMethod("createXML", argClasses);
            }
            catch (SecurityException e) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("getCreateXmlMethod: unable to get method named createXML in class oracle.xdb.XMLType: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                if (!s_log.isDebugEnabled()) break block9;
                s_log.debug((Object)("getCreateXmlMethod: unable to get method named createXML in class oracle.xdb.XMLType: " + e.getMessage()), (Throwable)e);
            }
        }
        if (createXmlMethod == null) {
            try {
                createXmlMethod = XML_TYPE_CLASS.getMethod("createXml", argClasses);
            }
            catch (SecurityException e) {
                s_log.error((Object)("getCreateXmlMethod: Unable to get method named createXml or createXML in class oracle.xdb.XMLType: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (NoSuchMethodException e) {
                s_log.error((Object)("getCreateXmlMethod: Unable to get method named createXml or createXML in class oracle.xdb.XMLType: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
        return createXmlMethod;
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setObject(position, null);
        } else {
            try {
                Class[] args = new Class[]{Connection.class, String.class};
                Method createXmlMethod = this.getCreateXmlMethod(args);
                Object xmlTypeObj = createXmlMethod.invoke(null, pstmt.getConnection(), value.toString());
                pstmt.setObject(position, xmlTypeObj);
            }
            catch (Exception e) {
                s_log.error((Object)("setPreparedStatementValue: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    static interface i18n {
        public static final String CELL_ERROR_MSG = s_stringMgr.getString("OracleXmlTypeDataTypeComponent.cellErrorMsg");
    }
}

