/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelEventDispatcher;
import net.sourceforge.squirrel_sql.plugins.graph.QueryData;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ColumnInfoXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.QueryDataXmlBean;

public class ColumnInfo {
    private String _columnName;
    private String _columnType;
    private int _columnSize;
    private int _decimalDigits;
    private boolean _isPrimaryKey;
    private boolean _nullable;
    private int _index;
    private String _importedFromTable;
    private String _importedColumn;
    private String _constraintName;
    private String _toString;
    private QueryData _queryData = new QueryData();
    private ColumnInfoModelEventDispatcher _columnInfoModelEventDispatcher;
    private boolean _hidden;

    public ColumnInfo(String columnName, String columnType, int columnSize, int decimalDigits, boolean nullable) {
        this._columnName = columnName;
        this._columnType = columnType;
        this._columnSize = columnSize;
        this._decimalDigits = decimalDigits;
        this._nullable = nullable;
        String decimalDigitsString = 0 == this._decimalDigits ? "" : "," + this._decimalDigits;
        this._toString = this._columnName + "  " + this._columnType + "(" + this._columnSize + decimalDigitsString + ") " + (this._nullable ? "NULL" : "NOT NULL");
    }

    public ColumnInfo(ColumnInfoXmlBean xmlBean) {
        this(xmlBean.getColumnName(), xmlBean.getColumnType(), xmlBean.getColumnSize(), xmlBean.getDecimalDigits(), xmlBean.isNullable());
        this._hidden = xmlBean.isHidden();
        this._queryData = new QueryData(xmlBean.getQueryDataXmlBean());
        this._index = xmlBean.getIndex();
        if (xmlBean.isPrimaryKey()) {
            this.markPrimaryKey();
        }
        if (null != xmlBean.getImportedFromTable()) {
            this.setDBImportData(xmlBean.getImportedFromTable(), xmlBean.getImportedColumn(), xmlBean.getConstraintName());
        }
    }

    public ColumnInfoXmlBean getXmlBean() {
        ColumnInfoXmlBean ret = new ColumnInfoXmlBean();
        ret.setColumnName(this._columnName);
        ret.setColumnType(this._columnType);
        ret.setColumnSize(this._columnSize);
        ret.setDecimalDigits(this._decimalDigits);
        ret.setNullable(this._nullable);
        ret.setPrimaryKey(this._isPrimaryKey);
        ret.setIndex(this._index);
        ret.setImportedFromTable(this._importedFromTable);
        ret.setImportedColumn(this._importedColumn);
        ret.setConstraintName(this._constraintName);
        ret.setHidden(this._hidden);
        QueryDataXmlBean queryDataXmlBean = new QueryDataXmlBean();
        queryDataXmlBean.setOperatorIndex(this._queryData.getOperator().getIndex());
        queryDataXmlBean.setAggregateFunctionIndex(this._queryData.getAggregateFunction().getIndex());
        queryDataXmlBean.setFilterValue(this._queryData.getFilterValue());
        queryDataXmlBean.setInSelectClause(this._queryData.isInSelectClause());
        queryDataXmlBean.setSortingIndex(this._queryData.getSorting().getIndex());
        ret.setQueryDataXmlBean(queryDataXmlBean);
        return ret;
    }

    public String toString() {
        return this._toString;
    }

    public String getName() {
        return this._columnName;
    }

    public void setDBImportData(String importedFromTable, String importedColumn, String constraintName) {
        this._importedFromTable = importedFromTable;
        this._importedColumn = importedColumn;
        this._constraintName = constraintName;
        String fkString = " (FK)";
        if (null != importedColumn && !this._toString.endsWith(fkString)) {
            this._toString = this._toString + fkString;
        }
    }

    public String getDBConstraintName() {
        return this._constraintName;
    }

    public int getIndex() {
        return this._index;
    }

    public void markPrimaryKey() {
        this._isPrimaryKey = true;
        this._toString = this._toString + " (PK)";
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public String getConstraintToolTipText() {
        if (null == this._importedFromTable) {
            return null;
        }
        return this._importedFromTable + "." + this._importedColumn + " (" + this._constraintName + ")";
    }

    public String getDBImportedTableName() {
        return this._importedFromTable;
    }

    public QueryData getQueryData() {
        return this._queryData;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public void setQueryData(QueryData queryData) {
        this._queryData = queryData;
    }

    public void setColumnInfoModelEventDispatcher(ColumnInfoModelEventDispatcher columnInfoModelEventDispatcher) {
        this._columnInfoModelEventDispatcher = columnInfoModelEventDispatcher;
    }

    public ColumnInfoModelEventDispatcher getColumnInfoModelEventDispatcher() {
        return this._columnInfoModelEventDispatcher;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        return this._columnName.equalsIgnoreCase(((ColumnInfo)obj)._columnName);
    }

    public int hashCode() {
        return this._columnName.hashCode();
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isHidden() {
        return this._hidden;
    }
}

