/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelEventDispatcher;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.OrderType;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;

public class ColumnInfoModel {
    private ColumnInfo[] _colInfos = new ColumnInfo[0];
    private ColumnInfo[] _orderedColumnInfos = new ColumnInfo[0];
    private ArrayList<ColumnInfoModelListener> _listeners = new ArrayList();
    private ColumnInfoModelEventDispatcher _columnInfoModelEventDispatcher = new ColumnInfoModelEventDispatcher(){

        @Override
        public void fireChanged(TableFramesModelChangeType changeType) {
            ColumnInfoModel.this.fireChanged(changeType);
        }
    };

    public int getColCount() {
        return this._colInfos.length;
    }

    public ColumnInfo getColAt(int ix) {
        return this._colInfos[ix];
    }

    public ColumnInfo[] getAll() {
        return this._colInfos;
    }

    public void orderBy(OrderType orderType) {
        if (OrderType.ORDER_DB == orderType) {
            this._orderedColumnInfos = this._colInfos;
        } else {
            this._orderedColumnInfos = new ColumnInfo[this._colInfos.length];
            System.arraycopy(this._colInfos, 0, this._orderedColumnInfos, 0, this._colInfos.length);
            Arrays.sort(this._orderedColumnInfos, orderType.getComparator());
        }
        for (int i = 0; i < this._orderedColumnInfos.length; ++i) {
            this._orderedColumnInfos[i].setIndex(i);
        }
        this.fireChanged(TableFramesModelChangeType.COLUMN_SORTING);
    }

    public ColumnInfo findColumnInfo(String colName) {
        return GraphUtil.findColumnInfo(colName, this._colInfos);
    }

    public ColumnInfo getOrderedColAt(int ix) {
        return this._orderedColumnInfos[ix];
    }

    public void addColumnInfoModelListener(ColumnInfoModelListener listener) {
        this._listeners.add(listener);
    }

    public void querySelectAll(boolean b) {
        for (ColumnInfo colInfo : this._colInfos) {
            colInfo.getQueryData().setInSelectClause(b);
        }
        this.fireChanged(TableFramesModelChangeType.COLUMN_SELECT_ALL);
    }

    public void clearAllFilters() {
        for (ColumnInfo colInfo : this._colInfos) {
            colInfo.getQueryData().clearFilter();
        }
        this.fireChanged(TableFramesModelChangeType.COLUMN_WHERE_ALL);
    }

    private void fireChanged(TableFramesModelChangeType changeType) {
        ColumnInfoModelListener[] listeners;
        for (ColumnInfoModelListener listener : listeners = this._listeners.toArray(new ColumnInfoModelListener[this._listeners.size()])) {
            listener.columnInfosChanged(changeType);
        }
    }

    public void initCols(ColumnInfo[] refreshedCols, OrderType columnOrderType) {
        for (ColumnInfo colInfoNew : refreshedCols) {
            for (ColumnInfo colInfoOld : this._colInfos) {
                if (!colInfoNew.getColumnName().equalsIgnoreCase(colInfoOld.getColumnName())) continue;
                colInfoNew.setQueryData(colInfoOld.getQueryData());
                colInfoNew.setHidden(colInfoOld.isHidden());
            }
            colInfoNew.setColumnInfoModelEventDispatcher(this._columnInfoModelEventDispatcher);
        }
        this._colInfos = refreshedCols;
        this.orderBy(columnOrderType);
    }
}

