/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.IColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.TableToolTipProvider;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndColumn;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndEvent;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndHandler;

public class ColumnTextArea
extends JTextArea
implements DndColumn,
IColumnTextArea {
    private TableToolTipProvider _toolTipProvider;
    private DndHandler _dndHandler;
    private ColumnInfoModel _columnInfoModel;

    public ColumnTextArea(TableToolTipProvider toolTipProvider, DndCallback dndCallback, ISession session) {
        this._toolTipProvider = toolTipProvider;
        this.setToolTipText("Just to make getToolTiptext() to be called");
        this._dndHandler = new DndHandler(dndCallback, this, session);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this._toolTipProvider.getToolTipText(event);
    }

    public void setColumnInfoModel(ColumnInfoModel columnInfoModel) {
        this._columnInfoModel = columnInfoModel;
        this._columnInfoModel.addColumnInfoModelListener(new ColumnInfoModelListener(){

            @Override
            public void columnInfosChanged(TableFramesModelChangeType changeType) {
                if (TableFramesModelChangeType.COLUMN_SORTING == changeType) {
                    ColumnTextArea.this.initColumnInfos();
                }
            }
        });
        this.initColumnInfos();
    }

    private void initColumnInfos() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._columnInfoModel.getColCount(); ++i) {
            if (this._columnInfoModel.getOrderedColAt(i).isHidden()) continue;
            sb.append(this._columnInfoModel.getOrderedColAt(i)).append('\n');
        }
        this.setText(sb.toString());
    }

    @Override
    public DndEvent getDndEvent() {
        return this._dndHandler.getDndEvent();
    }

    @Override
    public void setDndEvent(DndEvent dndEvent) {
        this._dndHandler.setDndEvent(dndEvent);
    }

    @Override
    public Point getLocationInColumnTextArea() {
        return new Point(0, 0);
    }

    @Override
    public int getColumnHeight() {
        FontMetrics fm = this.getGraphics().getFontMetrics(this.getFont());
        return fm.getHeight();
    }

    @Override
    public int getMaxWidth() {
        int maxSize = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this._columnInfoModel.getColCount(); ++i) {
            int buf = fm.stringWidth(this._columnInfoModel.getColAt(i).toString());
            if (maxSize >= buf) continue;
            maxSize = buf;
        }
        return maxSize;
    }
}

