/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ScrollableDesktopPane;
import net.sourceforge.squirrel_sql.fw.gui.RectangleSelectionHandler;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewAdapter;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewListener;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesGraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.GraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopManager;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPrintable;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrame;

public class GraphDesktopPane
extends ScrollableDesktopPane
implements GraphPrintable {
    private Vector<GraphComponent> _graphComponents = new Vector();
    private transient ConstraintViewListener _constraintViewListener;
    private transient Set<TableFrame> _groupFrames = new HashSet<TableFrame>();
    private RectangleSelectionHandler _rectangleSelectionHandler;
    private double _formatWidthInPixel;
    private double _formatHeightInPixel;
    private double _formatScale;
    private boolean _isPrinting;
    private ImageIcon _desktopImage;
    private boolean _showStartupImage;

    public GraphDesktopPane(IApplication app, ImageIcon desktopImage, RectangleSelectionHandler rectangleSelectionHandler) {
        super(app);
        this._desktopImage = desktopImage;
        if (null != this._desktopImage) {
            this._showStartupImage = true;
        }
        this._constraintViewListener = new ConstraintViewAdapter(){

            @Override
            public void foldingPointMoved(ConstraintView source) {
                GraphDesktopPane.this.revalidate();
            }
        };
        this.setDesktopManager(new GraphDesktopManager(this));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GraphDesktopPane.this.clearGroupFrames();
            }
        });
        this._rectangleSelectionHandler = rectangleSelectionHandler;
    }

    public void setGroupFrame(TableFrame f) {
        ArrayList<TableFrame> temp = new ArrayList<TableFrame>(this._groupFrames);
        this._groupFrames.clear();
        for (TableFrame current : temp) {
            current.repaint();
        }
        this._groupFrames.add(f);
        f.repaint();
    }

    public void addGroupFrame(TableFrame f) {
        this._groupFrames.add(f);
        f.repaint();
    }

    public void removeGroupFrame(TableFrame f) {
        this._groupFrames.remove(f);
        f.repaint();
    }

    public void clearGroupFrames() {
        ArrayList<TableFrame> temp = new ArrayList<TableFrame>(this._groupFrames);
        this._groupFrames.clear();
        for (TableFrame current : temp) {
            current.repaint();
        }
    }

    public List<TableFrame> getGroupFrames() {
        return new ArrayList<TableFrame>(this._groupFrames);
    }

    public boolean isGroupFrame(TableFrame f) {
        return this._groupFrames.contains(f);
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        super.paintBorder(g);
        this.paintStartupImage(g);
        this.paintGraphComponents(g);
        super.paintChildren(g);
        this._rectangleSelectionHandler.paintRectWhenNeeded(g);
    }

    private void paintStartupImage(Graphics g) {
        if (this._showStartupImage) {
            Dimension size = this.getSize();
            int x = (size.width - this._desktopImage.getIconWidth()) / 2;
            int y = (size.height - this._desktopImage.getIconHeight()) / 2;
            this._desktopImage.paintIcon(null, g, x, y);
        }
    }

    private void paintGraphComponents(Graphics g) {
        for (int i = 0; i < this._graphComponents.size(); ++i) {
            GraphComponent comp = this._graphComponents.elementAt(i);
            if (comp instanceof EdgesGraphComponent) {
                ((EdgesGraphComponent)comp).setBounds(this.getWidth(), this.getHeight());
            }
            comp.paint(g, this._isPrinting);
        }
    }

    public void putGraphComponents(GraphComponent[] graphComponents) {
        for (int i = 0; i < graphComponents.length; ++i) {
            if (this._graphComponents.contains(graphComponents[i])) continue;
            if (graphComponents[i] instanceof ConstraintView) {
                ((ConstraintView)graphComponents[i]).addConstraintViewListener(this._constraintViewListener);
            }
            this._graphComponents.add(graphComponents[i]);
        }
    }

    public void removeGraphComponents(GraphComponent[] graphComponents) {
        this._graphComponents.removeAll(Arrays.asList(graphComponents));
    }

    public Vector<GraphComponent> getGraphComponents() {
        return this._graphComponents;
    }

    public Dimension getRequiredSize() {
        Dimension reqSize = super.getRequiredSize();
        for (int i = 0; i < this._graphComponents.size(); ++i) {
            GraphComponent graphComponent = this._graphComponents.elementAt(i);
            Dimension buf = graphComponent.getRequiredSize();
            if (buf.width > reqSize.width) {
                reqSize.width = buf.width;
            }
            if (buf.height <= reqSize.height) continue;
            reqSize.height = buf.height;
        }
        return reqSize;
    }

    @Override
    public void initPrint(double formatWidthInCm, double formatHeightInCm, double formatScale) {
        int pixelByCm = (int)((double)Toolkit.getDefaultToolkit().getScreenResolution() * 0.39370078740157477 + 0.5);
        this._formatWidthInPixel = formatWidthInCm * (double)pixelByCm;
        this._formatHeightInPixel = formatHeightInCm * (double)pixelByCm;
        this._formatScale = formatScale;
    }

    @Override
    public Dimension initPrintNoScaleSinglePage() {
        Dimension size = this.getSize();
        this._formatWidthInPixel = size.width;
        this._formatHeightInPixel = size.height;
        this._formatScale = 1.0;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int pageCountVertical;
        double edgesWitdthInPixel = this._formatWidthInPixel * this._formatScale;
        double edgesHeightInPixel = this._formatHeightInPixel * this._formatScale;
        int pageCountHorizontal = this.getPageCountHorizontal(edgesWitdthInPixel);
        if (pageIndex >= pageCountHorizontal * (pageCountVertical = this.getPageCountVertical(edgesHeightInPixel))) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        AffineTransform oldTransform = g2d.getTransform();
        boolean origDoubleBufferingEnabled = RepaintManager.currentManager((JComponent)((Object)this)).isDoubleBufferingEnabled();
        try {
            this._isPrinting = true;
            RepaintManager.currentManager((JComponent)((Object)this)).setDoubleBufferingEnabled(false);
            double tx = -this.getPageWidthInPixel(pageFormat) * (double)(pageIndex % pageCountHorizontal) + pageFormat.getImageableX();
            double ty = -this.getPageHeightInPixel(pageFormat) * (double)(pageIndex / pageCountHorizontal) + pageFormat.getImageableY();
            g2d.translate(tx, ty);
            double sx = this.getPageWidthInPixel(pageFormat) / edgesWitdthInPixel;
            double sy = this.getPageHeightInPixel(pageFormat) / edgesHeightInPixel;
            g2d.scale(sx, sy);
            this.paintGraphComponents(g2d);
            super.paintChildren((Graphics)g2d);
        }
        finally {
            g2d.setTransform(oldTransform);
            RepaintManager.currentManager((JComponent)((Object)this)).setDoubleBufferingEnabled(origDoubleBufferingEnabled);
            this._isPrinting = false;
        }
        return 0;
    }

    private double getPageHeightInPixel(PageFormat pageFormat) {
        return pageFormat.getImageableHeight();
    }

    private double getPageWidthInPixel(PageFormat pageFormat) {
        return pageFormat.getImageableWidth();
    }

    public int getPageCountHorizontal(double pageWidthInPixel) {
        return this.roundPageCount((double)this.getRequiredSize().width / pageWidthInPixel);
    }

    public int getPageCountVertical(double pageHeightInPixel) {
        return this.roundPageCount((double)this.getRequiredSize().height / pageHeightInPixel);
    }

    private int roundPageCount(double d) {
        return 0.0 < d - (double)((int)d) ? (int)(d + 1.0) : (int)d;
    }

    public void hideStartupImage() {
        this._showStartupImage = false;
        this.repaint();
    }
}

