/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.AddTableAtQursorToGraph;
import net.sourceforge.squirrel_sql.plugins.graph.AddToGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.GraphController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphMainPanelTab;
import net.sourceforge.squirrel_sql.plugins.graph.NewQueryBuilderWindowAction;
import net.sourceforge.squirrel_sql.plugins.graph.link.CopyGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.link.LinkGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.link.PasteGraphAction;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;

public class GraphPlugin
extends DefaultSessionPlugin {
    private Hashtable<IIdentifier, ArrayList<GraphController>> _grapControllersBySessionID = new Hashtable();
    private static ILogger s_log = LoggerController.createLogger(GraphPlugin.class);
    private PluginResources _resources;

    public String getInternalName() {
        return "graph";
    }

    public String getDescriptiveName() {
        return "Graph";
    }

    public String getVersion() {
        return "2.0";
    }

    public String getAuthor() {
        return "Gerd Wagner";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        this._resources = new PluginResources("net.sourceforge.squirrel_sql.plugins.graph.graph", (IPlugin)this);
        this.createMenu();
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("graph");
        app.addToMenu(2, menu);
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new AddToGraphAction(app, (Resources)this._resources, this)));
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new NewQueryBuilderWindowAction(app, this._resources, this)));
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new LinkGraphAction(app, this._resources, this)));
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new CopyGraphAction(app, this._resources, this)));
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new PasteGraphAction(app, this._resources, this)));
        this.addToCollectionAndMenu(coll, menu, (Action)((Object)new AddTableAtQursorToGraph(app, this._resources, this)));
    }

    private void addToCollectionAndMenu(ActionCollection coll, JMenu graphMenu, Action action) {
        coll.add(action);
        this._resources.addToMenu(action, graphMenu);
    }

    public void unload() {
        super.unload();
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        GraphXmlSerializer[] serializers = GraphXmlSerializer.getGraphXmSerializers(this, session);
        ArrayList<GraphController> controllers = new ArrayList<GraphController>();
        for (int i = 0; i < serializers.length; ++i) {
            controllers.add(new GraphController(session, this, serializers[i], false, false));
        }
        GraphXmlSerializer[] linkedSerializers = GraphXmlSerializer.getLinkedGraphXmSerializers(this, session);
        for (int i = 0; i < linkedSerializers.length; ++i) {
            controllers.add(new GraphController(session, this, linkedSerializers[i], false, false));
        }
        this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
        IObjectTreeAPI objectTreeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        ActionCollection coll = this.getApplication().getActionCollection();
        this.initObjectTree(objectTreeAPI);
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(NewQueryBuilderWindowAction.class));
        session.addToToolbar(coll.get(LinkGraphAction.class));
        session.addToToolbar(coll.get(CopyGraphAction.class));
        session.addToToolbar(coll.get(PasteGraphAction.class));
        ISQLPanelAPI sqlPanelAPI = session.getSessionInternalFrame().getMainSQLPanelAPI();
        sqlPanelAPI.addToToolsPopUp("addtograph", coll.get(AddTableAtQursorToGraph.class));
        sqlPanelAPI.addToSQLEntryAreaMenu(coll.get(AddTableAtQursorToGraph.class));
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                GraphPlugin.this.initObjectTree(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                GraphPlugin.this.initObjectTree((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    private void initObjectTree(IObjectTreeAPI objectTreeAPI) {
        ActionCollection coll = this.getApplication().getActionCollection();
        objectTreeAPI.addToPopup(DatabaseObjectType.TABLE, coll.get(AddToGraphAction.class));
    }

    public void sessionEnding(ISession session) {
        ArrayList<GraphController> controllers = this._grapControllersBySessionID.remove(session.getIdentifier());
        for (GraphController controller : controllers) {
            controller.sessionEnding();
        }
    }

    public GraphController[] getGraphControllers(ISession session) {
        return this._grapControllersBySessionID.get(session.getIdentifier()).toArray(new GraphController[0]);
    }

    public GraphController getGraphControllerForMainTab(GraphMainPanelTab mainTab, ISession session) {
        GraphController[] graphControllers = this.getGraphControllers(session);
        GraphController graphController = null;
        for (GraphController g : graphControllers) {
            if (!g.isMyGraphMainPanelTab(mainTab)) continue;
            graphController = g;
            break;
        }
        return graphController;
    }

    public String patchName(String name, ISession session) {
        boolean incremented;
        int postfix = 0;
        if ("Objects".equals(name)) {
            ++postfix;
        }
        if ("SQL".equals(name)) {
            ++postfix;
        }
        ArrayList<GraphController> controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        do {
            incremented = false;
            for (int i = 0; null != controllers && i < controllers.size(); ++i) {
                if (0 == postfix) {
                    if (!controllers.get(i).getTitle().equals(name)) continue;
                    ++postfix;
                    incremented = true;
                    continue;
                }
                if (!controllers.get(i).getTitle().equals(name + "_" + postfix)) continue;
                ++postfix;
                incremented = true;
            }
        } while (incremented);
        if (0 == postfix) {
            return name;
        }
        return name + "_" + postfix;
    }

    public GraphController createNewGraphControllerForSession(ISession session, boolean showDndDesktopImageAtStartup) {
        return this._createNewGraphControllerForSession(session, null, showDndDesktopImageAtStartup, false);
    }

    public void createNewGraphControllerForSession(ISession session, GraphXmlSerializer graphXmlSerializer, boolean selectTab) {
        this._createNewGraphControllerForSession(session, graphXmlSerializer, false, selectTab);
    }

    private GraphController _createNewGraphControllerForSession(ISession session, GraphXmlSerializer graphXmlSerializer, boolean showDndDesktopImageAtStartup, boolean selectTab) {
        ArrayList<GraphController> controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        if (null == controllers) {
            controllers = new ArrayList();
            this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
        }
        GraphController ret = new GraphController(session, this, graphXmlSerializer, showDndDesktopImageAtStartup, selectTab);
        controllers.add(ret);
        this._grapControllersBySessionID.put(session.getIdentifier(), controllers);
        return ret;
    }

    public void removeGraphController(GraphController toRemove, ISession session) {
        ArrayList<GraphController> controllers = this._grapControllersBySessionID.get(session.getIdentifier());
        if (null == controllers) {
            return;
        }
        for (int i = 0; i < controllers.size(); ++i) {
            if (!controllers.get(i).equals(toRemove)) continue;
            controllers.remove(i);
            break;
        }
    }

    private static interface IMenuResourceKeys {
        public static final String MENU = "graph";
    }
}

