/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.DefaultController;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerFacade;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopPane;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManagerListener;
import net.sourceforge.squirrel_sql.plugins.graph.ModeMenuItem;
import net.sourceforge.squirrel_sql.plugins.graph.StartButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomPrintController;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryBuilderController;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeNodeStructure;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.PrintXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.SelectStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ZoomerXmlBean;

public class ModeManager {
    private DefaultController _defaultController;
    private ZoomPrintController _zoomPrintController;
    private QueryBuilderController _queryBuilderController;
    private ModeMenuItem _mnuMode;
    private TableFramesModel _tableFramesModel;
    private ISession _session;
    private GraphPlugin _plugin;
    private GraphControllerFacade _graphControllerFacade;
    private ArrayList<ModeManagerListener> _listeners = new ArrayList();

    public ModeManager(TableFramesModel tableFramesModel, ISession session, GraphPlugin plugin, GraphControllerFacade graphControllerFacade) {
        this._tableFramesModel = tableFramesModel;
        this._session = session;
        this._plugin = plugin;
        this._graphControllerFacade = graphControllerFacade;
        this._mnuMode = new ModeMenuItem(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModeManager.this.onModeChanged();
            }
        });
    }

    public ZoomPrintController getZoomPrintController() {
        return this._zoomPrintController;
    }

    public JPanel getBottomPanel() {
        switch (this._mnuMode.getMode()) {
            case DEFAULT: {
                return this._defaultController.getBottomPanel();
            }
            case ZOOM_PRINT: {
                return this._zoomPrintController.getBottomPanel();
            }
            case QUERY_BUILDER: {
                return this._queryBuilderController.getBottomPanel();
            }
        }
        throw new IllegalStateException("Unknown mode " + this._mnuMode.getMode());
    }

    public Zoomer getZoomer() {
        return this._zoomPrintController.getZoomer();
    }

    public void sessionEnding() {
        this._zoomPrintController.sessionEnding();
    }

    private void onModeChanged() {
        ModeManagerListener[] listeners;
        switch (this._mnuMode.getMode()) {
            case DEFAULT: {
                this._defaultController.activate(true);
                this._zoomPrintController.activate(false);
                this._queryBuilderController.activate(false);
                break;
            }
            case ZOOM_PRINT: {
                this._defaultController.activate(false);
                this._zoomPrintController.activate(true);
                this._queryBuilderController.activate(false);
                break;
            }
            case QUERY_BUILDER: {
                this._defaultController.activate(false);
                this._zoomPrintController.activate(false);
                this._queryBuilderController.activate(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + this._mnuMode.getMode());
            }
        }
        for (ModeManagerListener listener : listeners = this._listeners.toArray(new ModeManagerListener[this._listeners.size()])) {
            listener.modeChanged(this._mnuMode.getMode());
        }
        SwingUtilities.invokeLater(() -> this._tableFramesModel.recalculateAllConnections());
    }

    public ModeMenuItem getModeMenuItem() {
        return this._mnuMode;
    }

    public Mode getMode() {
        return this._mnuMode.getMode();
    }

    public void initMode(Mode mode, ZoomerXmlBean zoomerXmlBean, PrintXmlBean printXmlBean, boolean queryHideNoJoins, SelectStructureXmlBean selectStructure, WhereTreeNodeStructure whereTreeNodeStructure, OrderStructureXmlBean orderStructure, EdgesListener edgesListener, GraphDesktopPane desktopPane) {
        GraphPluginResources rsrc = new GraphPluginResources((IPlugin)this._plugin);
        StartButtonHandler startButtonHandler = new StartButtonHandler(this._graphControllerFacade, rsrc);
        this._zoomPrintController = new ZoomPrintController(zoomerXmlBean, printXmlBean, edgesListener, desktopPane, this._session, this._plugin, startButtonHandler);
        startButtonHandler = new StartButtonHandler(this._graphControllerFacade, rsrc);
        this._queryBuilderController = new QueryBuilderController(this._tableFramesModel, this._graphControllerFacade, queryHideNoJoins, selectStructure, whereTreeNodeStructure, orderStructure, this._session, this._plugin, startButtonHandler);
        startButtonHandler = new StartButtonHandler(this._graphControllerFacade, rsrc);
        this._defaultController = new DefaultController(startButtonHandler);
        this._mnuMode.setMode(mode);
    }

    public void addModeManagerListener(ModeManagerListener modeManagerListener) {
        this._listeners.remove(modeManagerListener);
        this._listeners.add(modeManagerListener);
    }

    public void removeModeManagerListener(ModeManagerListener modeManagerListener) {
        this._listeners.remove(modeManagerListener);
    }

    public void setMode(Mode mode) {
        this._mnuMode.setMode(mode);
        this.onModeChanged();
    }

    public boolean isQueryHideNoJoins() {
        return this._queryBuilderController.isHideNoJoins();
    }

    public TableFramesModel getTableFramesModel() {
        return this._tableFramesModel;
    }

    public WhereTreeNodeStructure getWhereTreeNodeStructure() {
        return this._queryBuilderController.getWhereTreeNodeStructure();
    }

    public OrderStructureXmlBean getOrderStructure() {
        return this._queryBuilderController.getOrderStructure();
    }

    public SelectStructureXmlBean getSelectStructure() {
        return this._queryBuilderController.getSelectStructure();
    }

    public void graphClosed() {
        this._queryBuilderController.graphClosed();
    }
}

