/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.util.Comparator;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;

enum OrderType {
    ORDER_DB(0),
    ORDER_NAME(1),
    ORDER_PK_CONSTRAINT(2),
    ORDER_FILTERED_SELECTED(3);

    private int _ix;

    private OrderType(int ix) {
        this._ix = ix;
    }

    public int getIx() {
        return this._ix;
    }

    static OrderType getByIx(int ix) {
        for (OrderType orderType : OrderType.values()) {
            if (orderType._ix != ix) continue;
            return orderType;
        }
        throw new IllegalArgumentException("Unknown order typ " + ix);
    }

    Comparator<ColumnInfo> getComparator() {
        if (ORDER_NAME == this) {
            return new Comparator<ColumnInfo>(){

                @Override
                public int compare(ColumnInfo c1, ColumnInfo c2) {
                    return OrderType.this.orderNameCompare(c1, c2);
                }
            };
        }
        if (ORDER_PK_CONSTRAINT == this) {
            return new Comparator<ColumnInfo>(){

                @Override
                public int compare(ColumnInfo c1, ColumnInfo c2) {
                    return OrderType.this.orderPkConstraintCompare(c1, c2);
                }
            };
        }
        if (ORDER_FILTERED_SELECTED == this) {
            return new Comparator<ColumnInfo>(){

                @Override
                public int compare(ColumnInfo c1, ColumnInfo c2) {
                    return OrderType.this.orderFilteredSelectedCompare(c1, c2);
                }
            };
        }
        throw new IllegalArgumentException("No comparator avaialble for " + this);
    }

    private int orderFilteredSelectedCompare(ColumnInfo c1, ColumnInfo c2) {
        if (c1.getQueryData().isFiltered() && !c2.getQueryData().isFiltered()) {
            return -1;
        }
        if (!c1.getQueryData().isFiltered() && c2.getQueryData().isFiltered()) {
            return 1;
        }
        if (c1.getQueryData().isInSelectClause() && !c2.getQueryData().isInSelectClause()) {
            return -1;
        }
        if (!c1.getQueryData().isInSelectClause() && c2.getQueryData().isInSelectClause()) {
            return 1;
        }
        if (c1.getQueryData().isSorted() && !c2.getQueryData().isSorted()) {
            return -1;
        }
        if (!c1.getQueryData().isSorted() && c2.getQueryData().isSorted()) {
            return 1;
        }
        return c1.getName().compareTo(c2.getName());
    }

    private int orderPkConstraintCompare(ColumnInfo c1, ColumnInfo c2) {
        if (c1.isPrimaryKey() && !c2.isPrimaryKey()) {
            return -1;
        }
        if (!c1.isPrimaryKey() && c2.isPrimaryKey()) {
            return 1;
        }
        if (null != c1.getDBConstraintName() && null == c2.getDBConstraintName()) {
            return -1;
        }
        if (null == c1.getDBConstraintName() && null != c2.getDBConstraintName()) {
            return 1;
        }
        if (null != c1.getDBConstraintName() && null != c2.getDBConstraintName()) {
            String s1 = c1.getDBConstraintName() + "_" + c1.getName();
            String s2 = c2.getDBConstraintName() + "_" + c2.getName();
            return s1.compareTo(s2);
        }
        return c1.getName().compareTo(c2.getName());
    }

    private int orderNameCompare(ColumnInfo c1, ColumnInfo c2) {
        return c1.getName().compareTo(c2.getName());
    }
}

