/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.AggregateFunctions;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.GraphColoring;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.HideColumnListener;
import net.sourceforge.squirrel_sql.plugins.graph.QueryColumnTextField;
import net.sourceforge.squirrel_sql.plugins.graph.Sorting;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterController;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryFilterListener;

class QueryColumnPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryColumnPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(QueryColumnPanel.class);
    private JCheckBox chkSelect;
    private JButton btnAggFct;
    private JButton btnFilter;
    private JButton btnSorting;
    private JButton btnHideColumn;
    private QueryColumnTextField txtColumn;
    private String _tableName;
    private ColumnInfo _columnInfo;
    private ISession _session;
    private GraphPluginResources _graphPluginResources;
    private JPopupMenu _popUpAggregate;
    private JPopupMenu _popUpSorting;
    private JPanel _pnlButtons;

    QueryColumnPanel(GraphPlugin graphPlugin, String tableName, ColumnInfo columnInfo, DndCallback dndCallback, ISession session, HideColumnListener hideColumnListener) {
        super(new BorderLayout());
        this._tableName = tableName;
        this._columnInfo = columnInfo;
        this._session = session;
        this._graphPluginResources = new GraphPluginResources((IPlugin)graphPlugin);
        this.setBorder(BorderFactory.createEmptyBorder());
        this._pnlButtons = new JPanel(new GridBagLayout());
        GraphColoring.setTableFrameBackground(this._pnlButtons);
        int xPos = 0;
        this.chkSelect = new JCheckBox();
        this.chkSelect.setToolTipText(s_stringMgr.getString("QueryColumn.select"));
        GraphColoring.setTableFrameBackground(this.chkSelect);
        this.chkSelect.setSelected(this._columnInfo.getQueryData().isInSelectClause());
        this.chkSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryColumnPanel.this.onChkSelectedChanged();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints(xPos, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._pnlButtons.add((Component)this.chkSelect, gbc);
        this.initAggregate(this._pnlButtons, ++xPos);
        this.initFilter(graphPlugin, this._pnlButtons, ++xPos);
        this.initSorting(this._pnlButtons, ++xPos);
        this.initHideColumn(this._pnlButtons, ++xPos, hideColumnListener);
        this.add((Component)this._pnlButtons, "West");
        this.txtColumn = new QueryColumnTextField(this._columnInfo.toString(), dndCallback, this._session);
        this.txtColumn.setEditable(false);
        this.txtColumn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QueryColumnPanel.this.makeWordSelectionByDoubleClickWork(e);
            }
        });
        GraphColoring.setTableFrameBackground(this.txtColumn);
        this.txtColumn.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.txtColumn, "Center");
    }

    private void makeWordSelectionByDoubleClickWork(MouseEvent e) {
        try {
            if (2 != e.getClickCount()) {
                return;
            }
            int pos = this.txtColumn.viewToModel2D(e.getPoint());
            int wordStart = Utilities.getWordStart(this.txtColumn, pos);
            int wordEnd = Utilities.getWordEnd(this.txtColumn, pos);
            this.txtColumn.setSelectionStart(wordStart);
            this.txtColumn.setSelectionEnd(wordEnd);
        }
        catch (BadLocationException ex) {
            s_log.warn((Object)"Failed to select word in column text field:", (Throwable)ex);
        }
    }

    private void initFilter(final GraphPlugin graphPlugin, JPanel pnlButtons, int xPos) {
        this.btnFilter = new JButton();
        this.initFilterButtonIcon();
        this.btnFilter.setToolTipText(s_stringMgr.getString("QueryColumn.filterButton"));
        GraphColoring.setTableFrameBackground(this.btnFilter);
        this.btnFilter.setBorder(BorderFactory.createEmptyBorder());
        this.btnFilter.setFocusable(false);
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryColumnPanel.this.showFilterDialog(graphPlugin);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints(xPos, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this.btnFilter, gbc);
    }

    private void initAggregate(JPanel pnlButtons, int xPos) {
        this.btnAggFct = new JButton();
        GraphColoring.setTableFrameBackground(this.btnAggFct);
        this.btnAggFct.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints(xPos, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        pnlButtons.add((Component)this.btnAggFct, gbc);
        this.btnAggFct.setEnabled(this.chkSelect.isSelected());
        this.btnAggFct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryColumnPanel.this.onBtnAggFct(e);
            }
        });
        this.onAggSelected(this._columnInfo.getQueryData().getAggregateFunction(), false);
        this._popUpAggregate = new JPopupMenu();
        for (final AggregateFunctions af : AggregateFunctions.values()) {
            JMenuItem menuItem = new JMenuItem(af.toString(), this._graphPluginResources.getIcon(af.getImage()));
            menuItem.putClientProperty(AggregateFunctions.CLIENT_PROP_NAME, (Object)af);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryColumnPanel.this.onAggSelected(af, true);
                }
            });
            this._popUpAggregate.add(menuItem);
        }
    }

    private void initSorting(JPanel pnlButtons, int xPos) {
        this.btnSorting = new JButton();
        GraphColoring.setTableFrameBackground(this.btnSorting);
        this.btnSorting.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints(xPos, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0);
        pnlButtons.add((Component)this.btnSorting, gbc);
        this.btnSorting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryColumnPanel.this.onBtnSorting(e);
            }
        });
        this.onSortingSelected(this._columnInfo.getQueryData().getSorting(), false);
        this._popUpSorting = new JPopupMenu();
        for (final Sorting sorting : Sorting.values()) {
            JMenuItem menuItem = new JMenuItem(sorting.toString(), this._graphPluginResources.getIcon(sorting.getImage()));
            menuItem.putClientProperty(Sorting.CLIENT_PROP_NAME, (Object)sorting);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryColumnPanel.this.onSortingSelected(sorting, true);
                }
            });
            this._popUpSorting.add(menuItem);
        }
    }

    private void initHideColumn(JPanel pnlButtons, int xPos, HideColumnListener hideColumnListener) {
        this.btnHideColumn = new JButton();
        this.btnHideColumn.setIcon(this._graphPluginResources.getIcon("eyeCrossed"));
        this.btnHideColumn.setToolTipText(s_stringMgr.getString("QueryColumnPanel.hide.column"));
        GraphColoring.setTableFrameBackground(this.btnHideColumn);
        this.btnHideColumn.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints(xPos, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0);
        pnlButtons.add((Component)this.btnHideColumn, gbc);
        this.btnHideColumn.addActionListener(e -> hideColumnListener.hideColumn(this));
    }

    private void onBtnSorting(ActionEvent e) {
        this._popUpSorting.show(this.btnSorting, 0, 0);
    }

    private void onChkSelectedChanged() {
        this._columnInfo.getQueryData().setInSelectClause(this.chkSelect.isSelected());
        this.btnAggFct.setEnabled(this.chkSelect.isSelected());
        if (!this.chkSelect.isSelected()) {
            this.onAggSelected(AggregateFunctions.NONE, false);
        }
        this._columnInfo.getColumnInfoModelEventDispatcher().fireChanged(TableFramesModelChangeType.COLUMN_SELECT);
    }

    private void onAggSelected(AggregateFunctions af, boolean fireChanged) {
        this.btnAggFct.setIcon(this._graphPluginResources.getIcon(af.getImage()));
        this.btnAggFct.setToolTipText(af.getToolTip());
        this._columnInfo.getQueryData().setAggregateFunction(af);
        if (fireChanged) {
            this._columnInfo.getColumnInfoModelEventDispatcher().fireChanged(TableFramesModelChangeType.COLUMN_SELECT);
        }
    }

    private void onSortingSelected(Sorting sorting, boolean fireChanged) {
        this.btnSorting.setIcon(this._graphPluginResources.getIcon(sorting.getImage()));
        this.btnSorting.setToolTipText(sorting.getToolTip());
        this._columnInfo.getQueryData().setSorting(sorting);
        if (fireChanged) {
            this._columnInfo.getColumnInfoModelEventDispatcher().fireChanged(TableFramesModelChangeType.COLUMN_SELECT);
        }
    }

    private void onBtnAggFct(ActionEvent e) {
        this._popUpAggregate.show(this.btnAggFct, 0, 0);
    }

    private void initFilterButtonIcon() {
        if (this._columnInfo.getQueryData().isFiltered()) {
            this.btnFilter.setIcon(this._graphPluginResources.getIcon("FilterChecked"));
        } else {
            this.btnFilter.setIcon(this._graphPluginResources.getIcon("Filter"));
        }
    }

    private void showFilterDialog(GraphPlugin graphPlugin) {
        QueryFilterListener queryFilterListener = new QueryFilterListener(){

            @Override
            public void filterChanged() {
                QueryColumnPanel.this.initFilterButtonIcon();
            }
        };
        Window parent = SwingUtilities.windowForComponent(this.txtColumn);
        new QueryFilterController(parent, this._tableName, this._columnInfo, graphPlugin, this._session, queryFilterListener);
    }

    int getMaxWidth(ColumnInfo[] allColumnInfos) {
        int maxSize = 0;
        FontMetrics fm = this.txtColumn.getFontMetrics(this.txtColumn.getFont());
        for (int i = 0; i < allColumnInfos.length; ++i) {
            int buf = fm.stringWidth(allColumnInfos[i].toString());
            if (maxSize >= buf) continue;
            maxSize = buf;
        }
        return maxSize + this._pnlButtons.getWidth();
    }

    public void addColumnMouseListener(MouseListener mouseListener) {
        this.txtColumn.addMouseListener(mouseListener);
    }

    public void setHidden() {
        this._columnInfo.setHidden(true);
    }
}

