/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Window;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.TableColumnHideConfigDlg;
import org.apache.commons.lang3.StringUtils;

public class TableColumnHideConfigCtrl {
    private final TableColumnHideConfigDlg _dlg;
    private final ColumnInfoModel _columnInfoModel;
    private boolean _columnHidingChanged;

    public TableColumnHideConfigCtrl(Window owningWindow, ColumnInfoModel columnInfoModel, String tableName) {
        this._columnInfoModel = columnInfoModel;
        this._dlg = new TableColumnHideConfigDlg(owningWindow, tableName);
        this._dlg.lstLeft.setModel(new DefaultListModel());
        this._dlg.lstRight.setModel(new DefaultListModel());
        this.initLists(this._columnInfoModel);
        this._dlg.btnRight.addActionListener(e -> this.onToRight());
        this._dlg.btnLeft.addActionListener(e -> this.onToLeft());
        this._dlg.txtFilterLeft.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }
        });
        this._dlg.txtFilterRight.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableColumnHideConfigCtrl.this.initListAndApplyFilter();
            }
        });
        this._dlg.btnApplyHiding.addActionListener(e -> this.onApplyHiding());
        this._dlg.setVisible(true);
    }

    private void initListAndApplyFilter() {
        this.initLists(this._columnInfoModel);
        TableColumnHideConfigCtrl._applyFilter(this._dlg.txtFilterLeft, this._dlg.lstLeft);
        TableColumnHideConfigCtrl._applyFilter(this._dlg.txtFilterRight, this._dlg.lstRight);
    }

    private static void _applyFilter(JTextField txtFilter, JList<ColumnInfo> lst) {
        ArrayList<ColumnInfo> toRemove = new ArrayList<ColumnInfo>();
        for (int i = 0; i < lst.getModel().getSize(); ++i) {
            ColumnInfo colInfo = lst.getModel().getElementAt(i);
            if (StringUtilities.isEmpty((String)txtFilter.getText(), (boolean)true) || StringUtils.containsIgnoreCase((CharSequence)colInfo.getColumnName(), (CharSequence)txtFilter.getText())) continue;
            toRemove.add(colInfo);
        }
        toRemove.forEach(c -> ((DefaultListModel)lst.getModel()).removeElement(c));
    }

    private void initLists(ColumnInfoModel colInfoModel) {
        ArrayList<ColumnInfo> leftCols = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> rightCols = new ArrayList<ColumnInfo>();
        for (int i = 0; i < colInfoModel.getColCount(); ++i) {
            if (colInfoModel.getOrderedColAt(i).isHidden()) {
                rightCols.add(colInfoModel.getOrderedColAt(i));
                continue;
            }
            leftCols.add(colInfoModel.getOrderedColAt(i));
        }
        ((DefaultListModel)this._dlg.lstLeft.getModel()).clear();
        ((DefaultListModel)this._dlg.lstRight.getModel()).clear();
        ((DefaultListModel)this._dlg.lstLeft.getModel()).addAll(leftCols);
        ((DefaultListModel)this._dlg.lstRight.getModel()).addAll(rightCols);
    }

    private void onApplyHiding() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onToLeft() {
        ArrayList<ColumnInfo> rightSelCols = new ArrayList<ColumnInfo>(this._dlg.lstRight.getSelectedValuesList());
        rightSelCols.forEach(c -> c.setHidden(false));
        this.initListAndApplyFilter();
        this.selectColumnsAndScrollToFirst(rightSelCols, this._dlg.lstLeft);
        this._columnHidingChanged = true;
    }

    private void onToRight() {
        ArrayList<ColumnInfo> leftSelCols = new ArrayList<ColumnInfo>(this._dlg.lstLeft.getSelectedValuesList());
        leftSelCols.forEach(c -> c.setHidden(true));
        this.initListAndApplyFilter();
        this.selectColumnsAndScrollToFirst(leftSelCols, this._dlg.lstRight);
        this._columnHidingChanged = true;
    }

    private void selectColumnsAndScrollToFirst(ArrayList<ColumnInfo> colsToSelect, JList<ColumnInfo> lstToSelectIn) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (ColumnInfo leftSelCol : colsToSelect) {
            for (int i2 = 0; i2 < lstToSelectIn.getModel().getSize(); ++i2) {
                if (lstToSelectIn.getModel().getElementAt(i2) != leftSelCol) continue;
                indexes.add(i2);
            }
        }
        lstToSelectIn.setSelectedIndices(indexes.stream().mapToInt(i -> i).toArray());
        if (!indexes.isEmpty()) {
            lstToSelectIn.ensureIndexIsVisible((Integer)indexes.get(0));
        }
    }

    public boolean columnHidingChanged() {
        return this._columnHidingChanged;
    }
}

