/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabButton;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;

public class TableColumnHideConfigDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableColumnHideConfigDlg.class);
    JTextField txtFilterLeft = new JTextField();
    JTextField txtFilterRight = new JTextField();
    JList<ColumnInfo> lstLeft = new JList();
    TabButton btnRight = new TabButton(Main.getApplication().getResourcesFw().getIcon("right.arrow"));
    TabButton btnLeft = new TabButton(Main.getApplication().getResourcesFw().getIcon("left.arrow"));
    JList<ColumnInfo> lstRight = new JList();
    JButton btnApplyHiding = new JButton(s_stringMgr.getString("TableColumnHideConfigDlg.apply.hiding"));

    public TableColumnHideConfigDlg(Window owningWindow, String tableName) {
        super(owningWindow);
        this.setModal(true);
        this.setTitle(s_stringMgr.getString("TableColumnHideConfigDlg.title", new Object[]{tableName}));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createCentralPanel(), "Center");
        this.getContentPane().add((Component)this.createBottomPanel(), "South");
        GUIUtils.enableCloseByEscape((JDialog)this);
        this.setSize(new Dimension(600, 500));
        SwingUtilities.invokeLater(() -> GUIUtils.centerWithinParent((Window)this));
    }

    private JPanel createBottomPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 3, 3, 0), 0, 0);
        ret.add((Component)this.btnApplyHiding, gbc);
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 3, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JPanel createCentralPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 3, 3, 0), 0, 0);
        ret.add((Component)this.createLeftPane(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, new Insets(0, 0, 0, 3), 0, 0);
        ret.add((Component)this.createMiddleButtonPane(), gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 0, 3, 3), 0, 0);
        ret.add((Component)this.createRightPanel(), gbc);
        return ret;
    }

    private JPanel createLeftPane() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel lblFilter = new JLabel(s_stringMgr.getString("TableColumnHideConfigDlg.filter.visible"));
        ret.add((Component)lblFilter, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.txtFilterLeft, gbc);
        JScrollPane scrLeft = new JScrollPane(this.lstLeft);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 0, 0, 0), 0, 0);
        ret.add((Component)scrLeft, gbc);
        return (JPanel)GUIUtils.setPreferredWidth((Component)ret, (int)0);
    }

    private JPanel createMiddleButtonPane() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, new Insets(0, 3, 3, 0), 0, 0);
        ret.add((Component)this.btnRight, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 256, 0, new Insets(0, 3, 0, 0), 0, 0);
        ret.add((Component)this.btnLeft, gbc);
        return ret;
    }

    private JPanel createRightPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel lblFilter = new JLabel(s_stringMgr.getString("TableColumnHideConfigDlg.filter.hidden"));
        ret.add((Component)lblFilter, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.txtFilterRight, gbc);
        JScrollPane scrLeft = new JScrollPane(this.lstRight);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 0, 0, 0), 0, 0);
        ret.add((Component)scrLeft, gbc);
        return (JPanel)GUIUtils.setPreferredWidth((Component)ret, (int)0);
    }
}

