/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnHiddenListener;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnHideConfigListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphColoring;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopPane;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.GraphTextAreaFactory;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManager;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManagerListener;
import net.sourceforge.squirrel_sql.plugins.graph.SortColumnsListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableToolTipProvider;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomerListener;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.TableFrameXmlBean;

public class TableFrame
extends JInternalFrame {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableFrame.class);
    GraphTextAreaFactory txtColumsFactory;
    JScrollPane scrollPane;
    private MyUI _myUI;
    private GraphPlugin _plugin;
    private ModeManager _modeManager;
    private SortColumnsListener _sortColumnsListener;
    private ColumnHideConfigListener _columnHideConfigListener;
    private ModeManagerListener _modeManagerListener;
    private ZoomerListener _zoomerListener;

    public TableFrame(ISession session, GraphPlugin plugin, String tableName, TableFrameXmlBean xmlBean, TableToolTipProvider toolTipProvider, ModeManager modeManager, DndCallback dndCallback, SortColumnsListener sortColumnsListener, ColumnHideConfigListener columnHideConfigListener, ColumnHiddenListener columnHiddenListener) {
        this._plugin = plugin;
        this._modeManager = modeManager;
        this._sortColumnsListener = sortColumnsListener;
        this._columnHideConfigListener = columnHideConfigListener;
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(null);
        this.getContentPane().add(this.scrollPane);
        this.setMaximizable(true);
        this.setTitleBarIconsVisible(true);
        this.setTitle(tableName);
        GraphColoring.setTableFrameBackground(this);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1, true), BorderFactory.createLineBorder(this.getBackground(), 3)));
        this.setResizable(true);
        this.setFrameIcon(null);
        this._myUI = new MyUI(this);
        this.setUI(this._myUI);
        this.txtColumsFactory = new GraphTextAreaFactory(tableName, session, plugin, toolTipProvider, modeManager, dndCallback, columnHiddenListener);
        this.scrollPane.setViewportView(this.txtColumsFactory.getComponent(modeManager.getMode()));
        if (null != xmlBean) {
            double zoom = this._modeManager.getZoomer().getZoom();
            Rectangle r = new Rectangle();
            r.x = (int)(zoom * (double)xmlBean.getX() + 0.5);
            r.y = (int)(zoom * (double)xmlBean.getY() + 0.5);
            r.width = (int)(zoom * (double)xmlBean.getWidht() + 0.5);
            r.height = (int)(zoom * (double)xmlBean.getHeight() + 0.5);
            this.setBounds(r);
            this.setTitleBarIconsVisible(Mode.ZOOM_PRINT != this._modeManager.getMode());
        }
        this._zoomerListener = new ZoomerListener(){

            @Override
            public void zoomChanged(double newZoom, double oldZoom, boolean adjusting) {
            }

            @Override
            public void setHideScrollBars(boolean b) {
            }
        };
        this._modeManagerListener = new ModeManagerListener(){

            @Override
            public void modeChanged(Mode newMode) {
                TableFrame.this.onModeChanged(newMode);
            }
        };
    }

    private void setTitleBarIconsVisible(boolean visible) {
        this.setClosable(visible);
        this.setIconifiable(visible);
    }

    @Override
    public void setVisible(boolean b) {
        if (null != this._modeManager) {
            if (b) {
                this._modeManager.getZoomer().addZoomListener(this._zoomerListener);
                this._modeManager.addModeManagerListener(this._modeManagerListener);
                this.onModeChanged(this._modeManager.getMode());
            } else {
                this._modeManager.getZoomer().removeZoomListener(this._zoomerListener);
                this._modeManager.removeModeManagerListener(this._modeManagerListener);
            }
        }
        super.setVisible(b);
    }

    private void onModeChanged(Mode newMode) {
        this.scrollPane.setViewportView(this.txtColumsFactory.getComponent(this._modeManager.getMode()));
        this.setTitleBarIconsVisible(Mode.ZOOM_PRINT != newMode);
    }

    public MyTitlePaneUI getTitlePane() {
        return this._myUI.getTitlePane();
    }

    public TableFrameXmlBean getXmlBean() {
        TableFrameXmlBean ret = new TableFrameXmlBean();
        double zoom = this._modeManager.getZoomer().getZoom();
        Rectangle bounds = this.getBounds();
        ret.setX((int)((double)bounds.x / zoom + 0.5));
        ret.setY((int)((double)bounds.y / zoom + 0.5));
        ret.setWidht((int)((double)bounds.width / zoom + 0.5));
        ret.setHeight((int)((double)bounds.height / zoom + 0.5));
        return ret;
    }

    class MyTitlePaneUI
    extends BasicInternalFrameTitlePane {
        public static final int UNZOOMED_PREF_HEIGHT = 18;
        private Color groupTitleColor;

        public MyTitlePaneUI(JInternalFrame f) {
            super(f);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MyTitlePaneUI.this.onMouseClickedTitlePane(e);
                }
            });
        }

        private void onMouseClickedTitlePane(MouseEvent e) {
            if (e.getButton() == 1) {
                GraphDesktopPane desktopPane = (GraphDesktopPane)((Object)TableFrame.this.getDesktopPane());
                if (e.isControlDown()) {
                    if (desktopPane.isGroupFrame(TableFrame.this)) {
                        desktopPane.removeGroupFrame(TableFrame.this);
                    } else {
                        desktopPane.addGroupFrame(TableFrame.this);
                    }
                } else {
                    desktopPane.setGroupFrame(TableFrame.this);
                }
            }
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            GraphPluginResources rsc = new GraphPluginResources((IPlugin)TableFrame.this._plugin);
            this.closeIcon = rsc.getIcon("TableFrameClose");
            this.maxIcon = rsc.getIcon("sort");
            this.groupTitleColor = GraphColoring.getGroupTitleColor();
            this.selectedTitleColor = GraphColoring.getInternalFrameTitleSelectedColor(this.selectedTitleColor);
            this.notSelectedTitleColor = GraphColoring.getInternalFrameTitleNotSelectedTitleColor(this.notSelectedTitleColor);
            this.selectedTextColor = GraphColoring.getInternalFrameTitleSelectedTextColor(this.selectedTextColor);
            this.notSelectedTextColor = GraphColoring.getInternalFrameTitleNotSelectedTextColor(this.notSelectedTextColor);
            this.setFont(new Font(this.getFont().getFontName(), 1, this.getFont().getSize()));
        }

        @Override
        protected void createActions() {
            super.createActions();
            this.maximizeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableFrame.this._sortColumnsListener.sortButtonClicked(MyTitlePaneUI.this.maxButton);
                }
            };
            this.iconifyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableFrame.this._columnHideConfigListener.showColumnHideConfig();
                }
            };
        }

        private void onConfigureColumnHiding() {
            System.out.println("MyTitlePaneUI.onConfigureColumnHiding");
        }

        @Override
        protected void createButtons() {
            super.createButtons();
            this.maxButton.setToolTipText(s_stringMgr.getString("TableFrame.change.sorting"));
            this.iconButton.setToolTipText(s_stringMgr.getString("TableFrame.configure.column.hiding"));
        }

        @Override
        protected void paintTitleBackground(Graphics g) {
            if (((GraphDesktopPane)((Object)this.frame.getDesktopPane())).isGroupFrame(TableFrame.this)) {
                g.setColor(this.groupTitleColor);
            } else {
                g.setColor(this.notSelectedTitleColor);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintTitleBackground(g);
            if (this.frame.getTitle() != null) {
                boolean isSelected = this.frame.isSelected();
                Font f = g.getFont();
                g.setFont(this.getFont());
                if (isSelected) {
                    g.setColor(this.selectedTextColor);
                } else {
                    g.setColor(this.notSelectedTextColor);
                }
                FontMetrics fm = g.getFontMetrics();
                double s = TableFrame.this._modeManager.getZoomer().getZoom();
                int baseline = ((int)((double)this.getHeight() / s) + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
                Rectangle r = new Rectangle(0, 0, 0, 0);
                if (this.frame.isIconifiable()) {
                    r = this.iconButton.getBounds();
                } else if (this.frame.isMaximizable()) {
                    r = this.maxButton.getBounds();
                } else if (this.frame.isClosable()) {
                    r = this.closeButton.getBounds();
                }
                String title = this.frame.getTitle();
                if (r.x == 0) {
                    r.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                int titleX = this.menuBar.getX() + this.menuBar.getWidth() + 2;
                int titleW = (int)((double)(r.x - titleX - 3) / TableFrame.this._modeManager.getZoomer().getZoom() + 0.5);
                title = this.getTitle(this.frame.getTitle(), fm, titleW);
                Graphics2D g2d = (Graphics2D)g;
                AffineTransform origTrans = g2d.getTransform();
                AffineTransform at = new AffineTransform(origTrans);
                at.scale(TableFrame.this._modeManager.getZoomer().getZoom(), TableFrame.this._modeManager.getZoomer().getZoom());
                g2d.setTransform(at);
                g.drawString(title, titleX, baseline);
                g2d.setTransform(origTrans);
                g.setFont(f);
            }
        }

        @Override
        protected LayoutManager createLayout() {
            return new MyTitlePaneLayout();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension ret = super.getPreferredSize();
            ret.height = (int)(18.0 * TableFrame.this._modeManager.getZoomer().getZoom() + 0.5);
            return ret;
        }

        @Override
        protected JMenuBar createSystemMenuBar() {
            this.menuBar = new JMenuBar(){

                @Override
                public void setSize(int width, int height) {
                    super.setSize(0, 0);
                }

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    super.setBounds(0, 0, 0, 0);
                }
            };
            this.menuBar.setBorderPainted(false);
            this.menuBar.setSize(0, 0);
            this.menuBar.setBounds(0, 0, 0, 0);
            return this.menuBar;
        }

        public void setHideIconChecked(boolean b) {
            this.iconIcon = b ? new GraphPluginResources((IPlugin)TableFrame.this._plugin).getIcon("eyeConfigChecked") : new GraphPluginResources((IPlugin)TableFrame.this._plugin).getIcon("eyeConfig");
            this.iconButton.setIcon(this.iconIcon);
            this.repaint();
        }

        class MyTitlePaneLayout
        extends BasicInternalFrameTitlePane.TitlePaneLayout {
            MyTitlePaneLayout() {
                super(MyTitlePaneUI.this);
            }

            @Override
            public Dimension minimumLayoutSize(Container c) {
                Dimension ret = super.minimumLayoutSize(c);
                ret.width = (int)((double)ret.width * TableFrame.this._modeManager.getZoomer().getZoom());
                ret.height = (int)((double)ret.height * TableFrame.this._modeManager.getZoomer().getZoom());
                return ret;
            }
        }
    }

    class MyUI
    extends BasicInternalFrameUI {
        public MyUI(JInternalFrame frame) {
            super(frame);
        }

        @Override
        protected JComponent createNorthPane(JInternalFrame w) {
            this.titlePane = new MyTitlePaneUI(w);
            return this.titlePane;
        }

        public MyTitlePaneUI getTitlePane() {
            return (MyTitlePaneUI)TableFrame.this._myUI.titlePane;
        }
    }
}

