/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptServices;
import net.sourceforge.squirrel_sql.client.session.objecttreesearch.ObjectTreeSearch;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.MetaDataTimeOutProxyFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.AddTableRequestListener;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnSortListener;
import net.sourceforge.squirrel_sql.plugins.graph.ConnectionPoints;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewListener;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewsModel;
import net.sourceforge.squirrel_sql.plugins.graph.FoldingPoint;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManagerListener;
import net.sourceforge.squirrel_sql.plugins.graph.NonExistentingTableInfoPlaceHolder;
import net.sourceforge.squirrel_sql.plugins.graph.OrderType;
import net.sourceforge.squirrel_sql.plugins.graph.TableColumnHideConfigCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrame;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameControllerListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomerListener;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndEvent;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ColumnInfoXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.TableFrameControllerXmlBean;

public class TableFrameController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableFrameController.class);
    private static final ILogger s_log = LoggerController.createLogger(TableFrameController.class);
    private String _schema;
    private String _catalog;
    private String _tableName;
    private TableFrame _frame;
    private ColumnInfoModel _colInfoModel = new ColumnInfoModel();
    private ConstraintViewsModel _constraintViewsModel;
    private String[] _tablesExportedTo;
    private ISession _session;
    private Rectangle _startSize;
    private GraphDesktopController _desktopController;
    private Vector<TableFrameControllerListener> _listeners = new Vector();
    private Vector<TableFrameController> _openFramesConnectedToMe = new Vector();
    private Hashtable<TableFrameController, ComponentAdapter> _compListenersToOtherFramesByFrameCtrlr = new Hashtable();
    private Hashtable<TableFrameController, AdjustmentListener> _scrollListenersToOtherFramesByFrameCtrlr = new Hashtable();
    private Hashtable<TableFrameController, ColumnSortListener> _columnSortListenersToOtherFramesByFrameCtrlr = new Hashtable();
    private Vector<ColumnSortListener> _mySortListeners = new Vector();
    private JMenuItem _mnuAddTableForForeignKey;
    private JMenuItem _mnuAddChildTables;
    private JMenuItem _mnuAddParentTables;
    private JMenuItem _mnuAddAllRelatedTables;
    private JMenuItem _mnuRefreshTable;
    private JMenuItem _mnuScriptTable;
    private JMenuItem _mnuCopyTableName;
    private JMenuItem _mnuCopyQualifiedTableName;
    private JMenuItem _mnuViewTableInObjectTree;
    private JCheckBoxMenuItem _mnuOrderByName;
    private JCheckBoxMenuItem _mnuPksAndConstraintsOnTop;
    private JCheckBoxMenuItem _mnuDbOrder;
    private JCheckBoxMenuItem _mnuQueryFiltersAndSelectedOnTop;
    private JMenuItem _mnuQuerySelectAll;
    private JMenuItem _mnuQueryUnselectAll;
    private JMenuItem _mnuQueryClearAllFilters;
    private JMenuItem _mnuClose;
    private AddTableRequestListener _addTablelRequestListener;
    private ConstraintViewListener _constraintViewListener;
    private OrderType _columnOrderType = OrderType.ORDER_DB;
    private static final String MNU_PROP_COLUMN_INFO = "MNU_PROP_COLUMN_INFO";
    private ModeManagerListener _modeManagerListener;
    private ZoomerListener _zoomerListener;
    private Rectangle _adjustBeginBounds;
    private double _adjustBeginZoom;
    private TableFramesModelListener _tableFramesModelListener;
    private ComponentAdapter _componentListener;
    private InternalFrameAdapter _internalFrameListener;
    private NonExistentingTableInfoPlaceHolder _nonExistentingTableInfoPlaceHolder;

    public TableFrameController(GraphPlugin plugin, ISession session, GraphDesktopController desktopController, AddTableRequestListener listener, String tableName, String schemaName, String catalogName, TableFrameControllerXmlBean xmlBean) {
        try {
            this._session = session;
            this._constraintViewsModel = new ConstraintViewsModel(this._session);
            this._desktopController = desktopController;
            this._addTablelRequestListener = listener;
            if (null == xmlBean) {
                this._catalog = catalogName;
                this._schema = schemaName;
                this._tableName = tableName;
                this._frame = new TableFrame(this._session, plugin, this.getDisplayName(), null, event -> this.onGetToolTipText(event), this._desktopController.getModeManager(), this.createDndCallback(), sortButton -> this.onSortButtonClicked(sortButton), () -> this.onColumnHideConfig(), () -> this.initColumnHideIcon(this._colInfoModel));
                this.initFromDB();
            } else {
                this._catalog = xmlBean.getCatalog();
                this._schema = xmlBean.getSchema();
                this._tableName = xmlBean.getTablename();
                this._frame = new TableFrame(this._session, plugin, this.getDisplayName(), xmlBean.getTableFrameXmlBean(), event -> this.onGetToolTipText(event), this._desktopController.getModeManager(), this.createDndCallback(), sortButton -> this.onSortButtonClicked(sortButton), () -> this.onColumnHideConfig(), () -> this.initColumnHideIcon(this._colInfoModel));
                this._columnOrderType = OrderType.getByIx(xmlBean.getColumOrder());
                ColumnInfo[] colInfos = new ColumnInfo[xmlBean.getColumnIfoXmlBeans().length];
                for (int i = 0; i < colInfos.length; ++i) {
                    colInfos[i] = new ColumnInfo(xmlBean.getColumnIfoXmlBeans()[i]);
                }
                this._colInfoModel.initCols(colInfos, this._columnOrderType);
                this._constraintViewsModel.initByXmlBeans(xmlBean.getConstraintViewXmlBeans(), this._desktopController);
            }
            this._frame.txtColumsFactory.setColumnInfoModel(this._colInfoModel);
            this.initColumnHideIcon(this._colInfoModel);
            this._constraintViewListener = new ConstraintViewListener(){

                @Override
                public void foldingPointMoved(ConstraintView source) {
                    TableFrameController.this.onFoldingPointMoved(source);
                }

                @Override
                public void removeNonDbConstraint(ConstraintView constraintView) {
                    TableFrameController.this.onRemoveNonDbConstraint(constraintView);
                }
            };
            this._componentListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    TableFrameController.this.recalculateAllConnections(false);
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    TableFrameController.this.recalculateAllConnections(false);
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    TableFrameController.this.recalculateAllConnections(false);
                }
            };
            this._internalFrameListener = new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    TableFrameController.this.onClose();
                }
            };
            this._frame.addInternalFrameListener(this._internalFrameListener);
            this._frame.addComponentListener(this._componentListener);
            this._frame.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    TableFrameController.this.recalculateAllConnections(false);
                }
            });
            this.preparePopUp();
            this.orderColumns();
            this._zoomerListener = new ZoomerListener(){

                @Override
                public void zoomChanged(double newZoom, double oldZoom, boolean adjusting) {
                    TableFrameController.this.onZoomChanged(newZoom, oldZoom, adjusting);
                }

                @Override
                public void setHideScrollBars(boolean b) {
                    TableFrameController.this.onHideScrollBars(b);
                }
            };
            this._modeManagerListener = new ModeManagerListener(){

                @Override
                public void modeChanged(Mode newMode) {
                    TableFrameController.this.onModeChanged(newMode);
                }
            };
            this._tableFramesModelListener = new TableFramesModelListener(){

                @Override
                public void modelChanged(TableFramesModelChangeType changeType) {
                    TableFrameController.this.onTableFramesModelChanged(changeType);
                }
            };
            this._desktopController.getModeManager().addModeManagerListener(this._modeManagerListener);
            this._desktopController.getZoomer().addZoomListener(this._zoomerListener);
            this._desktopController.getTableFramesModel().addTableFramesModelListener(this._tableFramesModelListener);
            if (Mode.ZOOM_PRINT == this._desktopController.getModeManager().getMode()) {
                this.onHideScrollBars(this._desktopController.getZoomer().isHideScrollbars());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initColumnHideIcon(ColumnInfoModel colInfoModel) {
        if (Arrays.stream(colInfoModel.getAll()).anyMatch(c -> c.isHidden())) {
            this._frame.getTitlePane().setHideIconChecked(true);
        } else {
            this._frame.getTitlePane().setHideIconChecked(false);
        }
    }

    private void onSortButtonClicked(JButton sortButton) {
        JPopupMenu popupMenu = new JPopupMenu();
        this.addColumnOrderMenuItems(popupMenu);
        popupMenu.show(sortButton, 0, 0);
    }

    private void onColumnHideConfig() {
        if (new TableColumnHideConfigCtrl(GUIUtils.getOwningWindow((Component)this._frame), this._colInfoModel, this._frame.getTitle()).columnHidingChanged()) {
            this._frame.txtColumsFactory.setColumnInfoModel(this._colInfoModel);
            this.initColumnHideIcon(this._colInfoModel);
        }
    }

    private void onTableFramesModelChanged(TableFramesModelChangeType changeType) {
        if (TableFramesModelChangeType.TABLE == changeType) {
            DatabaseMetaData metaData = MetaDataTimeOutProxyFactory.wrap(() -> this._session.getSQLConnection().getConnection().getMetaData());
            this.completeConstraints(metaData);
        }
    }

    private DndCallback createDndCallback() {
        return new DndCallback(){

            @Override
            public void dndImportDone(DndEvent e, Point dropPoint) {
                TableFrameController.this.onDndImportDone(e, dropPoint);
            }

            @Override
            public DndEvent createDndEvent(MouseEvent lastDndExportedMousePressedEvent) {
                return TableFrameController.this.onCreateDndEvent(lastDndExportedMousePressedEvent);
            }
        };
    }

    private DndEvent onCreateDndEvent(MouseEvent lastDndExportedMousePressedEvent) {
        return new DndEvent(this, this.getColumnInfoForPoint(lastDndExportedMousePressedEvent.getPoint()));
    }

    private void onDndImportDone(DndEvent e, Point dropPoint) {
        TableFrameController fkTable = e.getTableFrameController();
        ConstraintView constraintView = fkTable._constraintViewsModel.createConstraintView(e, this, this.getColumnInfoForPoint(dropPoint), this._desktopController, this._session);
        if (null != constraintView) {
            fkTable.recalculateAllConnections(true);
            ArrayList<ConstraintView> toRemove = fkTable._constraintViewsModel.checkMerges(this._desktopController, fkTable, this, constraintView);
            for (ConstraintView view : toRemove) {
                fkTable.onRemoveNonDbConstraint(view);
            }
        }
    }

    private void onRemoveNonDbConstraint(ConstraintView constraintView) {
        this._constraintViewsModel.removeConst(constraintView);
        this._desktopController.removeConstraintViews(new ConstraintView[]{constraintView}, false);
        this.recalculateAllConnections(true);
        this._desktopController.repaint();
    }

    public String getDisplayName() {
        if (this._desktopController.isShowQualifiedTableNames()) {
            return this.getQualifiedName();
        }
        return this._tableName;
    }

    private String getQualifiedName() {
        return SQLUtilities.getQualifiedTableName((String)this._catalog, (String)this._schema, (String)this._tableName);
    }

    private boolean initFromDB() throws SQLException {
        DatabaseMetaData metaData = MetaDataTimeOutProxyFactory.wrap(() -> this._session.getSQLConnection().getConnection().getMetaData());
        ArrayList<ColumnInfo> colInfosBuf = GraphUtil.createColumnInfos(this._session, this._catalog, this._schema, this._tableName);
        this._colInfoModel.initCols(colInfosBuf.toArray(new ColumnInfo[colInfosBuf.size()]), this._columnOrderType);
        if (0 == this._colInfoModel.getColCount()) {
            this._desktopController.removeConstraintViews(this._constraintViewsModel.getConstViews(), false);
            return false;
        }
        this.completeConstraints(metaData);
        return true;
    }

    private void completeConstraints(DatabaseMetaData metaData) {
        this._constraintViewsModel.initFromDB(metaData, this._catalog, this._schema, this._tableName, this._colInfoModel, this._desktopController);
    }

    private void onModeChanged(Mode mode) {
        if (Mode.ZOOM_PRINT == mode) {
            this.onHideScrollBars(this._desktopController.getZoomer().isHideScrollbars());
        } else {
            this.onHideScrollBars(false);
        }
    }

    private void onHideScrollBars(boolean b) {
        if (b) {
            this._frame.scrollPane.setHorizontalScrollBarPolicy(31);
            this._frame.scrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this._frame.scrollPane.setHorizontalScrollBarPolicy(30);
            this._frame.scrollPane.setVerticalScrollBarPolicy(20);
        }
    }

    private void onZoomChanged(double newZoom, double oldZoom, boolean adjusting) {
        if (null == this._adjustBeginBounds) {
            this._adjustBeginZoom = oldZoom;
            this._adjustBeginBounds = new Rectangle(this._frame.getBounds());
        }
        Rectangle bounds = new Rectangle();
        bounds.x = (int)((double)this._adjustBeginBounds.x * newZoom / this._adjustBeginZoom + 0.5);
        bounds.y = (int)((double)this._adjustBeginBounds.y * newZoom / this._adjustBeginZoom + 0.5);
        bounds.width = (int)((double)this._adjustBeginBounds.width * newZoom / this._adjustBeginZoom + 0.5);
        bounds.height = (int)((double)this._adjustBeginBounds.height * newZoom / this._adjustBeginZoom + 0.5);
        this._frame.setBounds(bounds);
        this.recalculateAllConnections(false);
        if (!adjusting) {
            this._adjustBeginZoom = newZoom;
            this._adjustBeginBounds = null;
        }
    }

    private String onGetToolTipText(MouseEvent event) {
        ColumnInfo ci = this.getColumnInfoForPoint(event.getPoint());
        if (null == ci) {
            return null;
        }
        return ci.getConstraintToolTipText();
    }

    private ColumnInfo getColumnInfoForPoint(Point point) {
        int zoomedFontHeight = (int)((double)this._frame.txtColumsFactory.getColumnHeight() * this._desktopController.getZoomer().getZoom() + 0.5);
        for (int i = 0; i < this._colInfoModel.getColCount(); ++i) {
            int unscrolledHeight = this._colInfoModel.getColAt(i).getIndex() * zoomedFontHeight;
            if (unscrolledHeight > point.y || point.y > unscrolledHeight + zoomedFontHeight) continue;
            return this._colInfoModel.getColAt(i);
        }
        return null;
    }

    public TableFrameControllerXmlBean getXmlBean() {
        TableFrameControllerXmlBean ret = new TableFrameControllerXmlBean();
        ret.setSchema(this._schema);
        ret.setCatalog(this._catalog);
        ret.setTablename(this._tableName);
        ret.setTableFrameXmlBean(this._frame.getXmlBean());
        ret.setColumOrder(this._columnOrderType.getIx());
        ColumnInfoXmlBean[] colXmlBeans = new ColumnInfoXmlBean[this._colInfoModel.getColCount()];
        for (int i = 0; i < this._colInfoModel.getColCount(); ++i) {
            colXmlBeans[i] = this._colInfoModel.getColAt(i).getXmlBean();
        }
        ret.setColumnIfoXmlBeans(colXmlBeans);
        ret.setConstraintViewXmlBeans(this._constraintViewsModel.getXmlBeans());
        ret.setTablesExportedTo(this._tablesExportedTo);
        return ret;
    }

    private void preparePopUp() {
        this._mnuAddTableForForeignKey = new JMenuItem();
        this._mnuAddTableForForeignKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onAddTableForForeignKey((ColumnInfo)TableFrameController.this._mnuAddTableForForeignKey.getClientProperty(TableFrameController.MNU_PROP_COLUMN_INFO));
            }
        });
        this._mnuAddChildTables = new JMenuItem(s_stringMgr.getString("graph.addChildTables"));
        this._mnuAddChildTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onAddChildTables();
            }
        });
        this._mnuAddParentTables = new JMenuItem(s_stringMgr.getString("graph.addParentTables"));
        this._mnuAddParentTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onAddParentTables();
            }
        });
        this._mnuAddAllRelatedTables = new JMenuItem(s_stringMgr.getString("graph.addRelTables"));
        this._mnuAddAllRelatedTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onAddAllRelatedTables();
            }
        });
        this._mnuRefreshTable = new JMenuItem(s_stringMgr.getString("graph.refreshTable"));
        this._mnuRefreshTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onRefresh();
            }
        });
        this._mnuScriptTable = new JMenuItem(s_stringMgr.getString("graph.scriptTable"));
        this._mnuScriptTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onScriptTable();
            }
        });
        this._mnuCopyTableName = new JMenuItem(s_stringMgr.getString("graph.copyTableName"));
        this._mnuCopyTableName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onCopyTableName(false);
            }
        });
        this._mnuCopyQualifiedTableName = new JMenuItem(s_stringMgr.getString("graph.copyQualifiedTableName"));
        this._mnuCopyQualifiedTableName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onCopyTableName(true);
            }
        });
        this._mnuViewTableInObjectTree = new JMenuItem(s_stringMgr.getString("graph.viewTableInObjectTree"));
        this._mnuViewTableInObjectTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onViewTableInObjectTree();
            }
        });
        this._mnuDbOrder = new JCheckBoxMenuItem(s_stringMgr.getString("graph.dbOrder"));
        this._mnuDbOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.dbOrder();
            }
        });
        this._mnuOrderByName = new JCheckBoxMenuItem(s_stringMgr.getString("graph.orderyName"));
        this._mnuOrderByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.nameOrder();
            }
        });
        this._mnuPksAndConstraintsOnTop = new JCheckBoxMenuItem(s_stringMgr.getString("graph.orderPksConstr"));
        this._mnuPksAndConstraintsOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.pkConstraintOrder();
            }
        });
        this._mnuQueryFiltersAndSelectedOnTop = new JCheckBoxMenuItem(s_stringMgr.getString("graph.orderFilteredSelected"));
        this._mnuQueryFiltersAndSelectedOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.filteredSelectedOrder();
            }
        });
        this._mnuClose = new JMenuItem(s_stringMgr.getString("graph.close"));
        this._mnuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onClose();
                TableFrameController.this._frame.setVisible(false);
                TableFrameController.this._frame.dispose();
            }
        });
        this._mnuQuerySelectAll = new JMenuItem(s_stringMgr.getString("graph.QuerySelectAll"));
        this._mnuQuerySelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onQuerySelectAll(true);
            }
        });
        this._mnuQueryUnselectAll = new JMenuItem(s_stringMgr.getString("graph.QueryUnselectAll"));
        this._mnuQueryUnselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onQuerySelectAll(false);
            }
        });
        this._mnuQueryClearAllFilters = new JMenuItem(s_stringMgr.getString("graph.QueryClearAllFilters"));
        this._mnuQueryClearAllFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrameController.this.onQueryClearAllFilters();
            }
        });
        this._frame.txtColumsFactory.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableFrameController.this.maybeShowPopup(e, false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TableFrameController.this.maybeShowPopup(e, false);
            }
        });
        this._frame.getTitlePane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableFrameController.this.maybeShowPopup(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TableFrameController.this.maybeShowPopup(e, true);
            }
        });
    }

    private JPopupMenu createFramePopup() {
        JPopupMenu ret = new JPopupMenu();
        ret.add(this._mnuAddTableForForeignKey);
        ret.add(this._mnuAddChildTables);
        ret.add(this._mnuAddParentTables);
        ret.add(this._mnuAddAllRelatedTables);
        ret.add(new JSeparator());
        ret.add(this._mnuCopyTableName);
        ret.add(this._mnuCopyQualifiedTableName);
        ret.add(new JSeparator());
        ret.add(this._mnuRefreshTable);
        ret.add(this._mnuScriptTable);
        ret.add(this._mnuViewTableInObjectTree);
        ret.add(new JSeparator());
        this.addColumnOrderMenuItems(ret);
        ret.add(new JSeparator());
        ret.add(this._mnuQuerySelectAll);
        ret.add(this._mnuQueryUnselectAll);
        ret.add(this._mnuQueryClearAllFilters);
        ret.add(new JSeparator());
        ret.add(this._mnuClose);
        return ret;
    }

    private void addColumnOrderMenuItems(JPopupMenu popUp) {
        ButtonGroup bg = new ButtonGroup();
        popUp.add(this._mnuDbOrder);
        bg.add(this._mnuDbOrder);
        popUp.add(this._mnuOrderByName);
        bg.add(this._mnuOrderByName);
        popUp.add(this._mnuPksAndConstraintsOnTop);
        bg.add(this._mnuPksAndConstraintsOnTop);
        popUp.add(this._mnuQueryFiltersAndSelectedOnTop);
        bg.add(this._mnuQueryFiltersAndSelectedOnTop);
        this._mnuQueryFiltersAndSelectedOnTop.setEnabled(this._desktopController.getModeManager().getMode().isQueryBuilder());
    }

    private void onQueryClearAllFilters() {
        Window parent = SwingUtilities.windowForComponent(this._frame);
        int opt = JOptionPane.showConfirmDialog(parent, s_stringMgr.getString("graph.tableFrameController.queryClearAllFilters"));
        if (0 != opt) {
            return;
        }
        this._colInfoModel.clearAllFilters();
    }

    private void onQuerySelectAll(boolean b) {
        Window parent;
        int opt;
        if (!b && 0 != (opt = JOptionPane.showConfirmDialog(parent = SwingUtilities.windowForComponent(this._frame), s_stringMgr.getString("graph.tableFrameController.queryUnselectAll")))) {
            return;
        }
        this._colInfoModel.querySelectAll(b);
    }

    private void onCopyTableName(boolean qualified) {
        String toCopy = "";
        toCopy = qualified ? this.getQualifiedName() : this._tableName;
        StringSelection ss = new StringSelection(toCopy);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    private void onViewTableInObjectTree() {
        new ObjectTreeSearch().viewObjectInObjectTree(this.getTableInfo().getQualifiedName(), this._session);
    }

    private void onScriptTable() {
        Window parent = SwingUtilities.windowForComponent(this._frame);
        ITableInfo[] tableInfos = new ITableInfo[]{this.getTableInfo()};
        SQLScriptServices.scriptTablesToSQLEntryArea((ISession)this._session, (ITableInfo[])tableInfos);
    }

    public ITableInfo getTableInfo() {
        this._session.getSchemaInfo().waitTillTablesLoaded();
        ITableInfo[] tableInfos = this._session.getSchemaInfo().getITableInfos(this._catalog, this._schema, new ObjFilterMatcher(this._tableName), new String[]{"TABLE"});
        if (0 == tableInfos.length) {
            if (null == this._nonExistentingTableInfoPlaceHolder) {
                this._nonExistentingTableInfoPlaceHolder = new NonExistentingTableInfoPlaceHolder(this._catalog, this._schema, this._tableName);
                String errMsg = s_stringMgr.getString("TableFrameController.tableDoesNotExist", new Object[]{this._tableName});
                this._session.getApplication().getMessageHandler().showErrorMessage(errMsg);
                s_log.error((Object)("Table does not exits: " + this._tableName), (Throwable)new IllegalStateException(errMsg));
            }
            return this._nonExistentingTableInfoPlaceHolder;
        }
        return tableInfos[0];
    }

    private void onRefresh() {
        this.refresh();
    }

    void refresh() {
        try {
            if (this.initFromDB()) {
                this.orderColumns();
                this.recalculateAllConnections(true);
                this._desktopController.repaint();
            } else {
                this.onClose();
                this._frame.setVisible(false);
                this._frame.dispose();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void onAddTableForForeignKey(ColumnInfo columnInfo) {
        this._addTablelRequestListener.addTablesRequest(new String[]{columnInfo.getDBImportedTableName()}, this._schema, this._catalog);
    }

    void filteredSelectedOrder() {
        this.orderBy(OrderType.ORDER_FILTERED_SELECTED);
    }

    void pkConstraintOrder() {
        this.orderBy(OrderType.ORDER_PK_CONSTRAINT);
    }

    void nameOrder() {
        this.orderBy(OrderType.ORDER_NAME);
    }

    void dbOrder() {
        this.orderBy(OrderType.ORDER_DB);
    }

    private void orderBy(OrderType orderType) {
        this._columnOrderType = orderType;
        this.orderColumns();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableFrameController.this.recalculateAllConnections(false);
                TableFrameController.this.fireSortListeners();
            }
        });
    }

    public void refreshTableName() {
        this._frame.setTitle(this.getDisplayName());
    }

    private void fireSortListeners() {
        ColumnSortListener[] listeners = this._mySortListeners.toArray(new ColumnSortListener[this._mySortListeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].columnOrderChanged();
        }
    }

    private void orderColumns() {
        this._colInfoModel.orderBy(this._columnOrderType);
        switch (this._columnOrderType) {
            case ORDER_DB: {
                this._mnuDbOrder.setSelected(true);
                break;
            }
            case ORDER_NAME: {
                this._mnuOrderByName.setSelected(true);
                break;
            }
            case ORDER_PK_CONSTRAINT: {
                this._mnuPksAndConstraintsOnTop.setSelected(true);
                break;
            }
            case ORDER_FILTERED_SELECTED: {
                this._mnuQueryFiltersAndSelectedOnTop.setSelected(true);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent bestReadyComponent = TableFrameController.this._frame.txtColumsFactory.getBestReadyComponent();
                if (null != bestReadyComponent) {
                    TableFrameController.this._frame.txtColumsFactory.getBestReadyComponent().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                }
            }
        });
    }

    private void onAddAllRelatedTables() {
        this.onAddChildTables();
        this.onAddParentTables();
    }

    private void onAddChildTables() {
        try {
            DatabaseMetaData metaData = MetaDataTimeOutProxyFactory.wrap(() -> this._session.getSQLConnection().getConnection().getMetaData());
            if (null == this._tablesExportedTo) {
                Hashtable<String, String> exportBuf = new Hashtable<String, String>();
                ResultSet res = metaData.getExportedKeys(this._catalog, this._schema, this._tableName);
                while (res.next()) {
                    String tableName = res.getString("FKTABLE_NAME");
                    exportBuf.put(tableName, tableName);
                }
                this._tablesExportedTo = exportBuf.keySet().toArray(new String[0]);
            }
            this._addTablelRequestListener.addTablesRequest(this._tablesExportedTo, this._schema, this._catalog);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void onAddParentTables() {
        HashSet<String> tablesToAdd = new HashSet<String>();
        for (ColumnInfo columnInfo : this._colInfoModel.getAll()) {
            if (null == columnInfo.getDBImportedTableName()) continue;
            tablesToAdd.add(columnInfo.getDBImportedTableName());
        }
        this._addTablelRequestListener.addTablesRequest(tablesToAdd.toArray(new String[tablesToAdd.size()]), this._schema, this._catalog);
    }

    private void maybeShowPopup(MouseEvent e, boolean isOnTitlePane) {
        ColumnInfo ci;
        if (e.isPopupTrigger()) {
            ColumnInfo ci2 = null;
            if (!isOnTitlePane) {
                ci2 = this.getColumnInfoForPoint(e.getPoint());
            }
            if (null == ci2 || null == ci2.getDBImportedTableName()) {
                this._mnuAddTableForForeignKey.setEnabled(false);
                this._mnuAddTableForForeignKey.setText(s_stringMgr.getString("graph.addTableRefByNoHit"));
            } else {
                this._mnuAddTableForForeignKey.setEnabled(true);
                this._mnuAddTableForForeignKey.setText(s_stringMgr.getString("graph.addTableRefBy", new Object[]{ci2.getName()}));
                this._mnuAddTableForForeignKey.putClientProperty(MNU_PROP_COLUMN_INFO, ci2);
            }
            this._mnuQuerySelectAll.setEnabled(this._desktopController.getModeManager().getMode().isQueryBuilder());
            this._mnuQueryUnselectAll.setEnabled(this._desktopController.getModeManager().getMode().isQueryBuilder());
            this._mnuQueryClearAllFilters.setEnabled(this._desktopController.getModeManager().getMode().isQueryBuilder());
            this.createFramePopup().show(e.getComponent(), e.getX(), e.getY());
        } else if (2 == e.getClickCount() && e.getID() == 501 && null != (ci = this.getColumnInfoForPoint(e.getPoint())) && null != ci.getDBImportedTableName()) {
            this._addTablelRequestListener.addTablesRequest(new String[]{ci.getDBImportedTableName()}, this._schema, this._catalog);
        }
    }

    void initAfterAddedToDesktop(TableFrameController[] openFrames, boolean resetBounds) {
        this.calculateStartSize();
        for (int i = 0; i < openFrames.length; ++i) {
            this.tableFrameOpen(openFrames[i]);
        }
        if (resetBounds) {
            this._frame.setBounds(this._startSize);
        }
        this._frame.setVisible(true);
        this._frame.txtColumsFactory.getBestReadyComponent().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    private void onClose() {
        Object listenerToRemove;
        this._desktopController.removeConstraintViews(this._constraintViewsModel.getConstViews(), false);
        this._desktopController.getModeManager().removeModeManagerListener(this._modeManagerListener);
        this._desktopController.getZoomer().removeZoomListener(this._zoomerListener);
        this._desktopController.getTableFramesModel().removeTableFramesModelListener(this._tableFramesModelListener);
        this._frame.removeComponentListener(this._componentListener);
        this._frame.removeInternalFrameListener(this._internalFrameListener);
        for (TableFrameController tfc : this._compListenersToOtherFramesByFrameCtrlr.keySet()) {
            listenerToRemove = this._compListenersToOtherFramesByFrameCtrlr.get(tfc);
            tfc._frame.removeComponentListener((ComponentListener)listenerToRemove);
        }
        for (TableFrameController tfc : this._scrollListenersToOtherFramesByFrameCtrlr.keySet()) {
            listenerToRemove = this._scrollListenersToOtherFramesByFrameCtrlr.get(tfc);
            tfc._frame.scrollPane.getVerticalScrollBar().removeAdjustmentListener((AdjustmentListener)listenerToRemove);
        }
        for (TableFrameController tfc : this._columnSortListenersToOtherFramesByFrameCtrlr.keySet()) {
            listenerToRemove = this._columnSortListenersToOtherFramesByFrameCtrlr.get(tfc);
            tfc.removeSortListener((ColumnSortListener)listenerToRemove);
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            TableFrameControllerListener tableFrameControllerListener = this._listeners.elementAt(i);
            tableFrameControllerListener.closed(this);
        }
    }

    void tableFrameOpen(final TableFrameController tfc) {
        if (this._openFramesConnectedToMe.contains(tfc)) {
            return;
        }
        if (!this.recalculateConnectionsTo(tfc)) {
            return;
        }
        this._openFramesConnectedToMe.add(tfc);
        ComponentAdapter compListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                TableFrameController.this.recalculateConnectionsTo(tfc);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                TableFrameController.this.recalculateConnectionsTo(tfc);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TableFrameController.this.recalculateConnectionsTo(tfc);
            }
        };
        this._compListenersToOtherFramesByFrameCtrlr.put(tfc, compListener);
        tfc._frame.addComponentListener(compListener);
        AdjustmentListener adjListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TableFrameController.this.recalculateConnectionsTo(tfc);
            }
        };
        tfc._frame.scrollPane.getVerticalScrollBar().addAdjustmentListener(adjListener);
        this._scrollListenersToOtherFramesByFrameCtrlr.put(tfc, adjListener);
        ColumnSortListener sortListener = new ColumnSortListener(){

            @Override
            public void columnOrderChanged() {
                TableFrameController.this.recalculateConnectionsTo(tfc);
            }
        };
        tfc.addSortListener(sortListener);
        this._columnSortListenersToOtherFramesByFrameCtrlr.put(tfc, sortListener);
    }

    private void addSortListener(ColumnSortListener sortListener) {
        this._mySortListeners.add(sortListener);
    }

    private void removeSortListener(ColumnSortListener sortListener) {
        this._mySortListeners.remove(sortListener);
    }

    public void recalculateConnections() {
        this.recalculateAllConnections(true);
    }

    private void recalculateAllConnections(boolean checkConnections) {
        if (checkConnections) {
            Vector<TableFrameController> openTableFrameControllers = this._desktopController.getModeManager().getTableFramesModel().getTblCtrls();
            for (int i = 0; i < openTableFrameControllers.size(); ++i) {
                boolean found = false;
                TableFrameController tfc = openTableFrameControllers.get(i);
                if (this == tfc) continue;
                for (int j = 0; j < this._openFramesConnectedToMe.size(); ++j) {
                    if (tfc != this._openFramesConnectedToMe.get(j)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    if (0 != this.findConstraintViews(tfc.getTableInfo().getSimpleName()).length) continue;
                    this.disconnectTableFrame(tfc);
                    continue;
                }
                this.tableFrameOpen(tfc);
            }
        }
        for (int i = 0; i < this._openFramesConnectedToMe.size(); ++i) {
            TableFrameController tableFrameController = this._openFramesConnectedToMe.elementAt(i);
            this.recalculateConnectionsTo(tableFrameController);
        }
    }

    public void disconnectTableFrame(TableFrameController tfc) {
        ColumnSortListener columnSortListener;
        AdjustmentListener adjListenerToRemove;
        this._openFramesConnectedToMe.remove(tfc);
        ConstraintView[] constraintDataToRemove = this._constraintViewsModel.removeConstraintsForTable(tfc._tableName);
        ComponentAdapter compListenerToRemove = this._compListenersToOtherFramesByFrameCtrlr.remove(tfc);
        if (null != compListenerToRemove) {
            tfc._frame.removeComponentListener(compListenerToRemove);
        }
        if (null != (adjListenerToRemove = this._scrollListenersToOtherFramesByFrameCtrlr.remove(tfc))) {
            tfc._frame.scrollPane.getVerticalScrollBar().removeAdjustmentListener(adjListenerToRemove);
        }
        if (null != (columnSortListener = this._columnSortListenersToOtherFramesByFrameCtrlr.get(tfc))) {
            tfc.removeSortListener(columnSortListener);
        }
        this._desktopController.removeConstraintViews(constraintDataToRemove, false);
    }

    private boolean recalculateConnectionsTo(TableFrameController other) {
        ConstraintView[] constraintView = this.findConstraintViews(other._tableName);
        if (0 == constraintView.length) {
            return false;
        }
        for (int i = 0; i < constraintView.length; ++i) {
            ColumnInfo[] colInfos = constraintView[i].getData().getFkColumnInfos();
            FoldingPoint firstFoldingPoint = constraintView[i].getFirstFoldingPoint();
            FoldingPoint lastFoldingPoint = constraintView[i].getLastFoldingPoint();
            ConnectionPoints fkPoints = TableFrameController.getConnectionPoints(colInfos, this, other, firstFoldingPoint);
            ColumnInfo[] othersColInfos = new ColumnInfo[colInfos.length];
            ColumnInfo[] pkColumnInfos = constraintView[i].getData().getPkColumnInfos();
            for (int j = 0; j < pkColumnInfos.length; ++j) {
                othersColInfos[j] = other.findColumnInfo(pkColumnInfos[j].getColumnName());
            }
            ConnectionPoints pkPoints = TableFrameController.getConnectionPoints(othersColInfos, other, this, lastFoldingPoint);
            constraintView[i].setConnectionPoints(fkPoints, pkPoints, this, other, this._constraintViewListener);
        }
        this._desktopController.putConstraintViews(constraintView);
        this._desktopController.repaint();
        return true;
    }

    private void onFoldingPointMoved(ConstraintView source) {
        this.recalculateConnectionsTo(source.getPkFramePointingTo());
    }

    private static ConnectionPoints getConnectionPoints(ColumnInfo[] colInfos, TableFrameController me, TableFrameController other, FoldingPoint myNextFoldingPoint) {
        int[] relPointHeights = me.calculateRelativeConnectionPointHeights(colInfos);
        Rectangle myBounds = me._frame.getBounds();
        Rectangle othersBounds = other._frame.getBounds();
        ConnectionPoints ret = new ConnectionPoints();
        ret.points = new Point[relPointHeights.length];
        for (int i = 0; i < ret.points.length; ++i) {
            if (null == myNextFoldingPoint) {
                if (myBounds.x + myBounds.width * 3 / 4 < othersBounds.x) {
                    ret.points[i] = new Point(myBounds.x + myBounds.width, myBounds.y + relPointHeights[i]);
                    ret.pointsAreLeftOfWindow = false;
                    continue;
                }
                ret.points[i] = new Point(myBounds.x, myBounds.y + relPointHeights[i]);
                ret.pointsAreLeftOfWindow = true;
                continue;
            }
            if (myBounds.x + myBounds.width / 2 < myNextFoldingPoint.getZoomedPoint().x) {
                ret.points[i] = new Point(myBounds.x + myBounds.width, myBounds.y + relPointHeights[i]);
                ret.pointsAreLeftOfWindow = false;
                continue;
            }
            ret.points[i] = new Point(myBounds.x, myBounds.y + relPointHeights[i]);
            ret.pointsAreLeftOfWindow = true;
        }
        return ret;
    }

    public ConstraintView[] findConstraintViews(String tableName) {
        return this._constraintViewsModel.findConstraintViews(tableName);
    }

    private int[] calculateRelativeConnectionPointHeights(ColumnInfo[] colInfos) {
        Hashtable<Integer, Integer> buf = new Hashtable<Integer, Integer>();
        int height = this._frame.txtColumsFactory.getColumnHeight();
        for (int i = 0; i < colInfos.length; ++i) {
            double zoom = this._desktopController.getZoomer().getZoom();
            int unscrolledHeight = (int)((double)(colInfos[i].getIndex() * height + height / 2) * zoom + 0.5);
            Rectangle viewRect = this._frame.scrollPane.getViewport().getViewRect();
            int scrolledHeight = unscrolledHeight - viewRect.y;
            if (scrolledHeight < 0) {
                scrolledHeight = 0;
            }
            if (scrolledHeight > viewRect.height) {
                scrolledHeight = viewRect.height;
            }
            buf.put(scrolledHeight += this._frame.getTitlePane().getSize().height + 2, scrolledHeight);
        }
        int[] ret = new int[buf.size()];
        int i = 0;
        for (Integer key : buf.keySet()) {
            ret[i++] = key;
        }
        return ret;
    }

    private ColumnInfo findColumnInfo(String colName) {
        return this._colInfoModel.findColumnInfo(colName);
    }

    private void calculateStartSize() {
        int maxViewingCols = 15;
        int height1 = this._frame.txtColumsFactory.getColumnHeight();
        int width = this._frame.txtColumsFactory.getMaxWidht() + 30;
        int height = Math.min(this._colInfoModel.getColCount(), maxViewingCols) * height1 + 47;
        this._startSize = new Rectangle(width, height);
    }

    public TableFrame getFrame() {
        return this._frame;
    }

    public void addTableFrameControllerListener(TableFrameControllerListener l) {
        this._listeners.add(l);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableFrameController) {
            TableFrameController other = (TableFrameController)obj;
            return other._tableName.equals(this._tableName);
        }
        return false;
    }

    public int hashCode() {
        return this._tableName.hashCode();
    }

    public ColumnInfo[] getColumnInfos() {
        return this._colInfoModel.getAll();
    }

    public ConstraintViewsModel getConstraintViewsModel() {
        return this._constraintViewsModel;
    }

    public ColumnInfoModel getColumnInfoModel() {
        return this._colInfoModel;
    }
}

