/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.graphtofiles;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

public class ImageSelection
extends TransferHandler
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor, new DataFlavor("image/jpeg", "JPEG image"), new DataFlavor("image/gif", "GIF Image"), new DataFlavor("mage/x-pict", "X Pict")};
    private Image image;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (!(comp instanceof JLabel) || comp instanceof AbstractButton) {
            return false;
        }
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            if (!flavor[i].equals(flavors[0])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        this.image = null;
        Icon icon = null;
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            icon = label.getIcon();
        } else if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            icon = button.getIcon();
        }
        if (icon instanceof ImageIcon) {
            this.image = ((ImageIcon)icon).getImage();
            return this;
        }
        return null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        ImageIcon icon = null;
        try {
            if (t.isDataFlavorSupported(flavors[0])) {
                this.image = (Image)t.getTransferData(flavors[0]);
                icon = new ImageIcon(this.image);
            }
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                label.setIcon(icon);
                return true;
            }
            if (comp instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)comp;
                button.setIcon(icon);
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (this.isDataFlavorSupported(flavor)) {
            return this.image;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(flavors[0]);
    }
}

