/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.link;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.IMainPanelTabAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.graph.GraphController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphMainPanelTab;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;

public class CopyGraphAction
extends SquirrelAction
implements IMainPanelTabAction {
    private GraphPlugin _graphPlugin;
    private ISession _session;
    private GraphMainPanelTab _selectedMainTab;

    public CopyGraphAction(IApplication app, PluginResources resources, GraphPlugin graphPlugin) {
        super(app, (IResources)resources);
        this._graphPlugin = graphPlugin;
    }

    public void actionPerformed(ActionEvent e) {
        if (null == this._session || null == this._selectedMainTab) {
            return;
        }
        GraphController graphController = this._graphPlugin.getGraphControllerForMainTab(this._selectedMainTab, this._session);
        CopyGraphAction.copyGraph(graphController, false);
    }

    public static void copyGraph(GraphController graphController, boolean selectionOnly) {
        try {
            GraphControllerXmlBean xmlBean = graphController.createXmlBean(selectionOnly);
            xmlBean.setConverted32(true);
            StringSelection ss = new StringSelection(new XMLBeanWriter((Object)xmlBean).getAsString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }

    public void setSelectedMainPanelTab(IMainPanelTab selectedMainTab) {
        if (selectedMainTab instanceof GraphMainPanelTab) {
            this._selectedMainTab = (GraphMainPanelTab)selectedMainTab;
            this.setEnabled(true);
        } else {
            this._selectedMainTab = null;
            this.setEnabled(false);
        }
    }
}

