/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.link;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanArrayDataSet;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.link.GraphFileDisplayBean;
import net.sourceforge.squirrel_sql.plugins.graph.link.LinkGraphDialog;
import net.sourceforge.squirrel_sql.plugins.graph.link.LinkXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.link.NameLoadFinishListener;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;

public class LinkGraphController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LinkGraphDialog.class);
    private static final String COL_HEADER_NAME = s_stringMgr.getString("linkGraph.col.name");
    private static final String COL_HEADER_FILE = s_stringMgr.getString("linkGraph.col.graphFile");
    private static final String PREF_KEY_LINK_COL_WIDTH_NAME = "Squirrel.graph.link.dlg.col.name.width";
    private static final String PREF_KEY_LINK_COL_WIDTH_FILE = "Squirrel.graph.link.dlg.col.graphFile.width";
    private LinkGraphDialog _linkGraphDialog;
    private SessionAdapter _sessionAdapter;
    private Timer _timer;
    private ExecutorService _executorService;
    private GraphPlugin _plugin;
    private ISession _session;
    private ArrayList<GraphFileDisplayBean> _graphFileDisplayBeans;
    private final ArrayList<LinkXmlBean> _existingLinks;

    public LinkGraphController(GraphPlugin graphPlugin, final ISession session) {
        this._plugin = graphPlugin;
        this._session = session;
        try {
            this._linkGraphDialog = new LinkGraphDialog(graphPlugin, session);
            this._existingLinks = this.getExistingLinks(this._plugin);
            this.loadTable(graphPlugin, session, graphPlugin.getPluginUserSettingsFolder());
            this._linkGraphDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LinkGraphController.this.onWindowClosing();
                }
            });
            this._sessionAdapter = new SessionAdapter(){

                public void sessionClosing(SessionEvent evt) {
                    LinkGraphController.this.onSessionClosing(evt, session);
                }
            };
            session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionAdapter);
            this._linkGraphDialog.txtDir.setText(graphPlugin.getPluginUserSettingsFolder().getPath());
            this._linkGraphDialog.btnExplore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkGraphController.this.onExplore();
                }
            });
            this._linkGraphDialog.btnChangeDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkGraphController.this.onChangeDir();
                }
            });
            this._linkGraphDialog.btnHomeDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkGraphController.this.onHomeDir();
                }
            });
            this._linkGraphDialog.btnCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkGraphController.this.onCreate();
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private ArrayList<LinkXmlBean> getExistingLinks(GraphPlugin plugin) {
        try {
            String[] linkFileNames = plugin.getPluginUserSettingsFolder().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("lnk_");
                }
            });
            ArrayList<LinkXmlBean> ret = new ArrayList<LinkXmlBean>();
            XMLBeanReader br = new XMLBeanReader();
            for (String linkFileName : linkFileNames) {
                br.load(new File(plugin.getPluginUserSettingsFolder().getPath(), linkFileName), LinkGraphController.class.getClassLoader());
                ret.add((LinkXmlBean)br.iterator().next());
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onCreate() {
        try {
            int[] seletedRowIndexes;
            for (int seletedRowIndex : seletedRowIndexes = this._linkGraphDialog.tblGraphFiles.getSelectedModelRows()) {
                GraphFileDisplayBean gdb = this._graphFileDisplayBeans.get(seletedRowIndex);
                String linkName = this._plugin.patchName(gdb.getName().toString(), this._session);
                File pathOfLinkXmlFile = new File(this._plugin.getPluginUserSettingsFolder().getPath(), this.createLinkFileName(gdb));
                LinkXmlBean linkXmlBean = new LinkXmlBean(linkName, gdb.getName().toString(), gdb.getGraphFile().getAbsolutePath());
                XMLBeanWriter bw = new XMLBeanWriter((Object)linkXmlBean);
                bw.save(pathOfLinkXmlFile.getAbsolutePath());
                GraphXmlSerializer graphXmlSerializer = new GraphXmlSerializer(this._plugin, this._session, linkXmlBean, pathOfLinkXmlFile.getAbsolutePath());
                this._plugin.createNewGraphControllerForSession(this._session, graphXmlSerializer, false);
            }
            this.onWindowClosing();
            this._linkGraphDialog.setVisible(false);
            this._linkGraphDialog.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String createLinkFileName(GraphFileDisplayBean gdb) {
        return "lnk_" + GraphUtil.createGraphFileName(this._session.getAlias().getUrl(), this._plugin.patchName(gdb.getLoadedName(), this._session)) + ".graph.xml";
    }

    private void onHomeDir() {
        try {
            this._linkGraphDialog.txtDir.setText(this._plugin.getPluginUserSettingsFolder().getPath());
            this.loadTable(this._plugin, this._session, this._plugin.getPluginUserSettingsFolder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onChangeDir() {
        try {
            JFileChooser chooser = new JFileChooser(this._linkGraphDialog.txtDir.getText());
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this._linkGraphDialog);
            if (returnVal == 0) {
                this._linkGraphDialog.txtDir.setText(chooser.getSelectedFile().getAbsolutePath());
                this.loadTable(this._plugin, this._session, new FileWrapperFactoryImpl().create(chooser.getSelectedFile()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onExplore() {
        DesktopUtil.openInFileManager((File)new File(this._linkGraphDialog.txtDir.getText()));
    }

    private void loadTable(GraphPlugin graphPlugin, ISession session, FileWrapper path) throws IOException, DataSetException {
        GraphXmlSerializer[] serializers;
        this._graphFileDisplayBeans = new ArrayList();
        this._timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkGraphController.this.doRepaintToShowLoadedNames();
            }
        });
        this._timer.setRepeats(false);
        this._executorService = Executors.newFixedThreadPool(3);
        NameLoadFinishListener nameLoadFinishListener = new NameLoadFinishListener(){

            @Override
            public void finishedNameLoad() {
                LinkGraphController.this._timer.restart();
            }
        };
        boolean isInUserSettingsFolder = graphPlugin.getPluginUserSettingsFolder().getPath().equals(path.getPath());
        for (GraphXmlSerializer serializer : serializers = GraphXmlSerializer.getGraphXmlSerializersInPath(graphPlugin, session, path)) {
            if (isInUserSettingsFolder && this.belongsToUrl(serializer, session.getAlias().getUrl()) || this.linkExists(serializer)) continue;
            GraphFileDisplayBean bean = new GraphFileDisplayBean(new File(serializer.getGraphFile()), serializer, nameLoadFinishListener, this._executorService);
            this._graphFileDisplayBeans.add(bean);
        }
        JavabeanArrayDataSet javabeanArrayDataSet = new JavabeanArrayDataSet(GraphFileDisplayBean.class);
        javabeanArrayDataSet.setIgnoreProperty("graphFile");
        javabeanArrayDataSet.setIgnoreProperty("loadedName");
        javabeanArrayDataSet.setColHeader("name", COL_HEADER_NAME);
        javabeanArrayDataSet.setColPos("name", 1);
        javabeanArrayDataSet.setAbsoluteWidht("name", Props.getInt((String)PREF_KEY_LINK_COL_WIDTH_NAME, (int)200));
        javabeanArrayDataSet.setColHeader("graphFileName", COL_HEADER_FILE);
        javabeanArrayDataSet.setColPos("graphFileName", 2);
        javabeanArrayDataSet.setAbsoluteWidht("graphFileName", Props.getInt((String)PREF_KEY_LINK_COL_WIDTH_FILE, (int)200));
        javabeanArrayDataSet.setJavaBeanList(this._graphFileDisplayBeans);
        this._linkGraphDialog.tblGraphFiles.show((IDataSet)javabeanArrayDataSet);
    }

    private boolean belongsToUrl(GraphXmlSerializer serializer, String url) {
        return new File(serializer.getGraphFile()).getName().startsWith(GraphUtil.createGraphFileNamePrefixForUrl(url));
    }

    private boolean linkExists(GraphXmlSerializer serializer) {
        for (LinkXmlBean existingLink : this._existingLinks) {
            if (!Utilities.equalsRespectNull((Object)existingLink.getFilePathOfLinkedGraph(), (Object)serializer.getGraphFile())) continue;
            return true;
        }
        return false;
    }

    private void doRepaintToShowLoadedNames() {
        if (this._linkGraphDialog.isVisible()) {
            this._linkGraphDialog.tblGraphFiles.getComponent().repaint();
        }
    }

    private void onSessionClosing(SessionEvent evt, ISession session) {
        if (evt.getSession().getIdentifier().equals((Object)session.getIdentifier())) {
            this.onWindowClosing();
            this._linkGraphDialog.setVisible(false);
            this._linkGraphDialog.dispose();
            evt.getSession().getApplication().getSessionManager().removeSessionListener((ISessionListener)this._sessionAdapter);
        }
    }

    private void onWindowClosing() {
        Props.putInt((String)PREF_KEY_LINK_COL_WIDTH_NAME, (int)this._linkGraphDialog.tblGraphFiles.getColumnWidthForHeader(COL_HEADER_NAME));
        Props.putInt((String)PREF_KEY_LINK_COL_WIDTH_FILE, (int)this._linkGraphDialog.tblGraphFiles.getColumnWidthForHeader(COL_HEADER_FILE));
    }
}

