/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.nondbconst;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndColumn;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndEvent;

public class DndHandler {
    private static final ILogger s_log = LoggerController.createLogger(DndHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DndHandler.class);
    private DndCallback _dndCallback;
    private MouseEvent _lastExportedMouseEvent;
    private Point _dropPoint;
    private static boolean _dndMessageShown = false;

    public DndHandler(DndCallback dndCallback, final JComponent comp, final ISession session) {
        this._dndCallback = dndCallback;
        comp.setTransferHandler(this.createTransferHandler());
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DndHandler.this.onMousePressed(e, comp, session);
            }
        });
    }

    private void onMousePressed(MouseEvent e, JComponent comp, ISession session) {
        if (1 == e.getClickCount() && !e.isPopupTrigger() && 0 != (e.getModifiersEx() & 0x80)) {
            this._lastExportedMouseEvent = e;
            if (comp instanceof DndColumn) {
                Point lp = ((DndColumn)((Object)comp)).getLocationInColumnTextArea();
                this._lastExportedMouseEvent.translatePoint(lp.x, lp.y);
            }
            comp.getTransferHandler().exportAsDrag(comp, e, 1);
        } else if (!_dndMessageShown && 1 == e.getClickCount() && !e.isPopupTrigger()) {
            session.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("graph.DndHandler.dndMessage"));
            _dndMessageShown = true;
        }
    }

    private TransferHandler createTransferHandler() {
        return new TransferHandler("dndEvent"){

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                DndHandler.this._dropPoint = support.getDropLocation().getDropPoint();
                Component comp = support.getComponent();
                if (comp instanceof DndColumn) {
                    Point lp = ((DndColumn)((Object)comp)).getLocationInColumnTextArea();
                    DndHandler.this._dropPoint.translate(lp.x, lp.y);
                }
                return super.importData(support);
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                if (comp instanceof DndColumn) {
                    return true;
                }
                return super.canImport(comp, transferFlavors);
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (c instanceof DndColumn) {
                    DndColumn dndCol = (DndColumn)((Object)c);
                    DndEvent dndEvent = dndCol.getDndEvent();
                    if (null == dndEvent) {
                        return super.createTransferable(c);
                    }
                    return new DataHandler((Object)dndEvent, "application/x-java-jvm-local-objectref");
                }
                return super.createTransferable(c);
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                if (comp instanceof JTextComponent) {
                    JTextComponent txtComp = (JTextComponent)comp;
                    String selText = txtComp.getSelectedText();
                    if (null == selText || 0 == selText.length()) {
                        super.exportToClipboard(comp, clip, action);
                    } else {
                        StringSelection data = new StringSelection(selText);
                        clip.setContents(data, data);
                    }
                } else {
                    super.exportToClipboard(comp, clip, action);
                }
            }
        };
    }

    public DndEvent getDndEvent() {
        if (null == this._lastExportedMouseEvent) {
            return null;
        }
        return this._dndCallback.createDndEvent(this._lastExportedMouseEvent);
    }

    public void setDndEvent(DndEvent dndEvent) {
        try {
            this._dndCallback.dndImportDone(dndEvent, this._dropPoint);
        }
        catch (Throwable t) {
            s_log.error((Object)"Error on drag and drop constraint", t);
        }
    }
}

