/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.util.ArrayList;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.OrderCol;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.OrderStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.QueryOrderTableModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumn;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SortedColumnsPanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;

public class GraphQueryOrderPanelCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphQueryOrderPanelCtrl.class);
    private SortedColumnsPanelCtrl _delegate;

    public GraphQueryOrderPanelCtrl(HideDockButtonHandler hideDockButtonHandler, OrderStructureXmlBean orderStructure) {
        this._delegate = new SortedColumnsPanelCtrl(hideDockButtonHandler, new QueryOrderTableModel(orderStructure), s_stringMgr.getString("graph.GraphQueryOrderPanel.orderLabel"));
    }

    public JPanel getGraphQueryOrderPanel() {
        return this._delegate.getSortedColumnsPanel();
    }

    public OrderStructure syncOrderCols(TableFramesModel tableFramesModel) {
        return new OrderStructure((OrderCol[])this._delegate.syncSortedColumns(OrderCol.class, this.getOrderedCols(tableFramesModel)));
    }

    private ArrayList<SortedColumn> getOrderedCols(TableFramesModel tableFramesModel) {
        ArrayList<SortedColumn> newOrderCols = new ArrayList<SortedColumn>();
        for (TableFrameController tfc : tableFramesModel.getTblCtrls()) {
            for (ColumnInfo columnInfo : tfc.getColumnInfos()) {
                if (!columnInfo.getQueryData().isSorted()) continue;
                newOrderCols.add(new OrderCol(tfc, columnInfo));
            }
        }
        return newOrderCols;
    }

    public OrderStructureXmlBean getOrderStructure() {
        return new OrderStructureXmlBean((OrderCol[])this._delegate.getSortedColumns(OrderCol.class));
    }
}

