/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.Rectangle;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.EntryPanelManager;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandler;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQueryWherePanel;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereClauseOperator;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereConditionColumnWrapper;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeNodeStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeSync;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.sqlgen.QueryBuilderSQLGenerator;

public class GraphQueryWherePanelCtrl {
    private GraphQueryWherePanel _panel;
    private EntryPanelManager _entryPanelManager;
    private DefaultMutableTreeNode _rootNode;
    private ISession _session;
    private WhereTreeNodeStructure _initialWhereTreeNodeStructure;

    public GraphQueryWherePanelCtrl(ISession session, HideDockButtonHandler hideDockButtonHandler, GraphPluginResources rsrc, WhereTreeNodeStructure whereTreeNodeStructure) {
        this._session = session;
        this._initialWhereTreeNodeStructure = whereTreeNodeStructure;
        this._entryPanelManager = new EntryPanelManager(session);
        this._entryPanelManager.init(null, null);
        this._panel = new GraphQueryWherePanel(hideDockButtonHandler, this._entryPanelManager.getComponent(), rsrc);
        this._rootNode = new DefaultMutableTreeNode((Object)WhereClauseOperator.WHERE);
        this._panel.treeWhere.setModel(new DefaultTreeModel(this._rootNode));
        this.initDnd();
        this._panel.btnAddNewAndFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphQueryWherePanelCtrl.this.onAddNewFolder(WhereClauseOperator.AND);
            }
        });
        this._panel.btnAddNewOrFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphQueryWherePanelCtrl.this.onAddNewFolder(WhereClauseOperator.OR);
            }
        });
        this._panel.btnDeleteFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphQueryWherePanelCtrl.this.onDeleteFolder();
            }
        });
        this._panel.btnDeleteFolder.setEnabled(false);
        this._panel.treeWhere.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                GraphQueryWherePanelCtrl.this.onTreeSelectionChanged();
            }
        });
    }

    private void onTreeSelectionChanged() {
        TreePath[] selectionPaths = this._panel.treeWhere.getSelectionPaths();
        if (null == selectionPaths) {
            this._panel.btnDeleteFolder.setEnabled(false);
            return;
        }
        boolean deleteable = false;
        for (TreePath treePath : selectionPaths) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!this.isDeleteable(selNode.getUserObject())) continue;
            deleteable = true;
            break;
        }
        this._panel.btnDeleteFolder.setEnabled(deleteable);
    }

    private void onDeleteFolder() {
        TreePath[] paths;
        for (TreePath path : paths = this._panel.treeWhere.getSelectionPaths()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!this.isDeleteable(userObject)) continue;
            new WhereTreeSync().removeFolder(node);
        }
        this.nodeChanged(this._rootNode);
    }

    private boolean isDeleteable(Object userObject) {
        WhereClauseOperator op;
        return userObject instanceof WhereClauseOperator && ((op = (WhereClauseOperator)((Object)userObject)) == WhereClauseOperator.OR || op == WhereClauseOperator.AND);
    }

    private void initDnd() {
        TreeDnDHandlerCallback treeDnDHandlerCallback = new TreeDnDHandlerCallback(){

            public boolean nodeAcceptsKids(DefaultMutableTreeNode selNode) {
                return GraphQueryWherePanelCtrl.this.onNodeAcceptsKids(selNode);
            }

            public void dndExecuted() {
                GraphQueryWherePanelCtrl.this.syncWherePreview();
            }

            public ArrayList<DefaultMutableTreeNode> getPasteTreeNodesFromExternalTransfer(DropTargetDropEvent dtde, TreePath targetPath) {
                return null;
            }
        };
        new TreeDnDHandler(this._panel.treeWhere, treeDnDHandlerCallback);
    }

    private boolean onNodeAcceptsKids(DefaultMutableTreeNode selNode) {
        return selNode.getUserObject() instanceof WhereClauseOperator;
    }

    private void onAddNewFolder(WhereClauseOperator oper) {
        TreePath selPath = this._panel.treeWhere.getSelectionPath();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode((Object)oper);
        newNode.setAllowsChildren(true);
        if (null == selPath) {
            this._rootNode.insert(newNode, 0);
            this.nodeChanged(this._rootNode);
            this._panel.treeWhere.setSelectionPath(new TreePath(newNode.getPath()));
            return;
        }
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        if (selNode.getUserObject() instanceof WhereClauseOperator) {
            selNode.add(newNode);
            this.nodeChanged(selNode);
            this._panel.treeWhere.expandPath(new TreePath(selNode.getPath()));
        } else {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
            if (parent == null) {
                this._rootNode.insert(newNode, 0);
                this.nodeChanged(this._rootNode);
                this._panel.treeWhere.setSelectionPath(new TreePath(newNode.getPath()));
                return;
            }
            int selIx = parent.getIndex(selNode);
            parent.insert(newNode, selIx + 1);
            this.nodeChanged(parent);
            this._panel.treeWhere.setSelectionPath(new TreePath(newNode.getPath()));
        }
    }

    WhereTreeNodeStructure syncWhereCols(TableFramesModel tfm) {
        ArrayList<WhereConditionColumnWrapper> filteredCols = new ArrayList<WhereConditionColumnWrapper>();
        for (TableFrameController tfc : tfm.getTblCtrls()) {
            for (ColumnInfo ci : tfc.getColumnInfoModel().getAll()) {
                if (!ci.getQueryData().isFiltered()) continue;
                filteredCols.add(new WhereConditionColumnWrapper(tfc, ci));
            }
        }
        if (null != this._initialWhereTreeNodeStructure) {
            this._initialWhereTreeNodeStructure.initTree(this._rootNode, filteredCols, this._panel.treeWhere);
            this._initialWhereTreeNodeStructure = null;
        } else {
            new WhereTreeSync().sync(this._rootNode, filteredCols);
        }
        WhereTreeNodeStructure ts = new WhereTreeNodeStructure(this._rootNode, this._panel.treeWhere);
        this.nodeChanged(this._rootNode);
        return ts;
    }

    private void nodeChanged(DefaultMutableTreeNode node) {
        WhereTreeNodeStructure ts = new WhereTreeNodeStructure(node, this._panel.treeWhere);
        DefaultTreeModel dtm = (DefaultTreeModel)this._panel.treeWhere.getModel();
        dtm.nodeStructureChanged(node);
        ts.applyExpansion(node, this._panel.treeWhere);
        this.syncWherePreview();
    }

    private void syncWherePreview() {
        String whereClause = new WhereTreeNodeStructure(this._rootNode, this._panel.treeWhere).generateWhereClause();
        this._entryPanelManager.getEntryPanel().setText(QueryBuilderSQLGenerator.format(whereClause, this._session), false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GraphQueryWherePanelCtrl.this._entryPanelManager.getEntryPanel().getTextComponent().scrollRectToVisible(new Rectangle(0, 0));
                GraphQueryWherePanelCtrl.this._entryPanelManager.getEntryPanel().setCaretPosition(0);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public JPanel getGraphQueryWherePanel() {
        return this._panel;
    }

    public WhereTreeNodeStructure getWhereTreeNodeStructure() {
        return new WhereTreeNodeStructure(this._rootNode, this._panel.treeWhere);
    }
}

