/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerFacade;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.StartButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.TrippleStateCheckBox;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphDockHandle;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphDockHandleAdmin;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphDockHandleAdminListerner;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQueryOrderPanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQueryResultPanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQuerySQLPanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQuerySelectPanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.GraphQueryWherePanelCtrl;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.OrderStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SelectStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SyncListener;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereTreeNodeStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.sqlgen.QueryBuilderSQLGenerator;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.OrderStructureXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.SelectStructureXmlBean;

public class QueryBuilderController {
    private static final String PREF_KEY_SQL_DOCK_HEIGHT = "Squirrel.graph.sqldock.height";
    private static final String PREF_KEY_RESULT_DOCK_HEIGHT = "Squirrel.graph.resultdock.height";
    private static final String PREF_KEY_SELECT_DOCK_HEIGHT = "Squirrel.graph.selectdock.height";
    private static final String PREF_KEY_WHERE_DOCK_HEIGHT = "Squirrel.graph.wheredock.height";
    private static final String PREF_KEY_ORDER_DOCK_HEIGHT = "Squirrel.graph.orderdock.height";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryBuilderController.class);
    private JPanel _panel;
    private JToggleButton _btnSQL;
    private JToggleButton _btnResult;
    private JToggleButton _btnSelect;
    private JToggleButton _btnOrder;
    private JToggleButton _btnWhere;
    private TrippleStateCheckBox _chkHideNoJoins;
    private GraphDockHandle _sqlDockHandle;
    private GraphDockHandle _resultDockHandle;
    private GraphDockHandle _selectDockHandle;
    private GraphDockHandle _whereDockHandle;
    private GraphDockHandle _orderDockHandle;
    private TableFramesModel _tableFramesModel;
    private GraphControllerFacade _graphControllerFacade;
    private ISession _session;
    private GraphQuerySQLPanelCtrl _graphQuerySQLPanelCtrl;
    private GraphQueryResultPanelCtrl _graphQueryResultPanelCtrl;
    private GraphQuerySelectPanelCtrl _graphQuerySelectPanelCtrl;
    private GraphQueryOrderPanelCtrl _graphQueryOrderPanelCtrl;
    private GraphQueryWherePanelCtrl _graphQueryWherePanelCtrl;
    private SessionAdapter _sessionAdapter;
    private GraphDockHandleAdmin _graphDockHandleAdmin;

    public QueryBuilderController(TableFramesModel tableFramesModel, GraphControllerFacade graphControllerFacade, boolean queryHideNoJoins, SelectStructureXmlBean selectStructure, WhereTreeNodeStructure whereTreeNodeStructure, OrderStructureXmlBean orderStructure, ISession session, GraphPlugin plugin, StartButtonHandler startButtonHandler) {
        this._tableFramesModel = tableFramesModel;
        this._graphControllerFacade = graphControllerFacade;
        this._session = session;
        this._panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._panel.add((Component)startButtonHandler.getButton(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        this._btnSQL = this.fixWidth(new JToggleButton(s_stringMgr.getString("QueryBuilderController.SQL")));
        this._panel.add((Component)this._btnSQL, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0);
        this._btnResult = this.fixWidth(new JToggleButton(s_stringMgr.getString("QueryBuilderController.Result")));
        this._panel.add((Component)this._btnResult, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._btnSelect = this.fixWidth(new JToggleButton(s_stringMgr.getString("QueryBuilderController.Select")));
        this._panel.add((Component)this._btnSelect, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._btnWhere = this.fixWidth(new JToggleButton(s_stringMgr.getString("QueryBuilderController.Where")));
        this._panel.add((Component)this._btnWhere, gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._btnOrder = this.fixWidth(new JToggleButton(s_stringMgr.getString("QueryBuilderController.Order")));
        this._panel.add((Component)this._btnOrder, gbc);
        gbc = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._chkHideNoJoins = new TrippleStateCheckBox(s_stringMgr.getString("QueryBuilderController.HideNoJoins"));
        this._panel.add((Component)this._chkHideNoJoins, gbc);
        this._chkHideNoJoins.setSelected(queryHideNoJoins);
        gbc = new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this._panel.add((Component)new JPanel(), gbc);
        GraphPluginResources rsrc = new GraphPluginResources((IPlugin)plugin);
        this._graphQuerySQLPanelCtrl = new GraphQuerySQLPanelCtrl(this._session, new HideDockButtonHandler(this._btnSQL, rsrc), this.createSQLSyncListener());
        this._graphQueryResultPanelCtrl = new GraphQueryResultPanelCtrl(this._session, new HideDockButtonHandler(this._btnResult, rsrc), this.createResultSyncListener());
        this._graphQuerySelectPanelCtrl = new GraphQuerySelectPanelCtrl(new HideDockButtonHandler(this._btnSelect, rsrc), selectStructure);
        this._graphQueryOrderPanelCtrl = new GraphQueryOrderPanelCtrl(new HideDockButtonHandler(this._btnOrder, rsrc), orderStructure);
        this._graphQueryWherePanelCtrl = new GraphQueryWherePanelCtrl(this._session, new HideDockButtonHandler(this._btnWhere, rsrc), rsrc, whereTreeNodeStructure);
        this.initHandels();
        this._sessionAdapter = new SessionAdapter(){

            public void sessionClosing(SessionEvent evt) {
                QueryBuilderController.this.onSessionClosing();
            }
        };
        this._session.getApplication().getSessionManager().addSessionListener((ISessionListener)this._sessionAdapter);
        this._tableFramesModel.addTableFramesModelListener(new TableFramesModelListener(){

            @Override
            public void modelChanged(TableFramesModelChangeType changeType) {
                QueryBuilderController.this.onModelChanged(changeType);
            }
        });
        this._chkHideNoJoins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBuilderController.this.onNoJoin();
            }
        });
    }

    private JToggleButton fixWidth(JToggleButton btn) {
        int width = btn.getFontMetrics(btn.getFont()).stringWidth(btn.getText()) + 50;
        return (JToggleButton)GUIUtils.setPreferredWidth((Component)btn, (int)width);
    }

    private void onNoJoin() {
        this._tableFramesModel.hideNoJoins(this._chkHideNoJoins.isSelected());
        this._graphControllerFacade.repaint();
    }

    private SyncListener createResultSyncListener() {
        return new SyncListener(){

            @Override
            public void synRequested(boolean force) {
                QueryBuilderController.this.syncResult(force);
            }
        };
    }

    private SyncListener createSQLSyncListener() {
        return new SyncListener(){

            @Override
            public void synRequested(boolean force) {
                QueryBuilderController.this.syncSql();
            }
        };
    }

    private void onModelChanged(TableFramesModelChangeType changeType) {
        if (this._sqlDockHandle.isShowing() && this._graphQuerySQLPanelCtrl.isAutoSync()) {
            this.syncSql();
        } else if (this._resultDockHandle.isShowing() && this._graphQueryResultPanelCtrl.isAutoSync()) {
            this.syncResult(false);
        } else if (this._selectDockHandle.isShowing()) {
            this._graphQuerySelectPanelCtrl.syncSelectCols(this._tableFramesModel);
        } else if (this._whereDockHandle.isShowing()) {
            this._graphQueryWherePanelCtrl.syncWhereCols(this._tableFramesModel);
        } else if (this._orderDockHandle.isShowing()) {
            this._graphQueryOrderPanelCtrl.syncOrderCols(this._tableFramesModel);
        }
        if (null != changeType && changeType == TableFramesModelChangeType.CONSTRAINT && this._chkHideNoJoins.isSelected() && this._tableFramesModel.containsUniddenNoJoins()) {
            this._chkHideNoJoins.setUndefined(true);
        }
        if (null != changeType && changeType == TableFramesModelChangeType.TABLE && !this._chkHideNoJoins.isUndefined()) {
            this.onNoJoin();
        }
    }

    private void syncResult(boolean force) {
        SelectStructure selS = this._graphQuerySelectPanelCtrl.syncSelectCols(this._tableFramesModel);
        WhereTreeNodeStructure wts = this._graphQueryWherePanelCtrl.syncWhereCols(this._tableFramesModel);
        OrderStructure os = this._graphQueryOrderPanelCtrl.syncOrderCols(this._tableFramesModel);
        this._graphQueryResultPanelCtrl.execSQL(new QueryBuilderSQLGenerator(this._session).generateSQL(this._tableFramesModel, wts, os, selS), force);
    }

    private void syncSql() {
        SelectStructure selS = this._graphQuerySelectPanelCtrl.syncSelectCols(this._tableFramesModel);
        WhereTreeNodeStructure wts = this._graphQueryWherePanelCtrl.syncWhereCols(this._tableFramesModel);
        OrderStructure os = this._graphQueryOrderPanelCtrl.syncOrderCols(this._tableFramesModel);
        this._graphQuerySQLPanelCtrl.setSQL(new QueryBuilderSQLGenerator(this._session).generateSQL(this._tableFramesModel, wts, os, selS));
    }

    private void initHandels() {
        this._graphDockHandleAdmin = new GraphDockHandleAdmin(new GraphDockHandleAdminListerner(){

            @Override
            public void newDockOpened() {
                QueryBuilderController.this.onModelChanged(null);
            }
        });
        int sqlHeight = Props.getInt((String)PREF_KEY_SQL_DOCK_HEIGHT, (int)250);
        this._sqlDockHandle = new GraphDockHandle(this._graphControllerFacade, this._graphQuerySQLPanelCtrl.getGraphQuerySQLPanel(), sqlHeight);
        this._graphDockHandleAdmin.add(this._sqlDockHandle, this._btnSQL);
        int resHeight = Props.getInt((String)PREF_KEY_RESULT_DOCK_HEIGHT, (int)250);
        this._resultDockHandle = new GraphDockHandle(this._graphControllerFacade, this._graphQueryResultPanelCtrl.getGraphQueryResultPanel(), resHeight);
        this._graphDockHandleAdmin.add(this._resultDockHandle, this._btnResult);
        int selectHeight = Props.getInt((String)PREF_KEY_ORDER_DOCK_HEIGHT, (int)250);
        this._selectDockHandle = new GraphDockHandle(this._graphControllerFacade, this._graphQuerySelectPanelCtrl.getGraphQueryOrderPanel(), selectHeight);
        this._graphDockHandleAdmin.add(this._selectDockHandle, this._btnSelect);
        int whereHeight = Props.getInt((String)PREF_KEY_WHERE_DOCK_HEIGHT, (int)250);
        this._whereDockHandle = new GraphDockHandle(this._graphControllerFacade, this._graphQueryWherePanelCtrl.getGraphQueryWherePanel(), whereHeight);
        this._graphDockHandleAdmin.add(this._whereDockHandle, this._btnWhere);
        int orderHeight = Props.getInt((String)PREF_KEY_ORDER_DOCK_HEIGHT, (int)250);
        this._orderDockHandle = new GraphDockHandle(this._graphControllerFacade, this._graphQueryOrderPanelCtrl.getGraphQueryOrderPanel(), orderHeight);
        this._graphDockHandleAdmin.add(this._orderDockHandle, this._btnOrder);
    }

    private void onSessionClosing() {
        Props.putInt((String)PREF_KEY_SQL_DOCK_HEIGHT, (int)this._sqlDockHandle.getLastHeigth());
        Props.putInt((String)PREF_KEY_RESULT_DOCK_HEIGHT, (int)this._resultDockHandle.getLastHeigth());
        this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this._sessionAdapter);
    }

    public JPanel getBottomPanel() {
        return this._panel;
    }

    public void activate(boolean b) {
        if (!b) {
            this._graphDockHandleAdmin.deselectAllButtons();
        }
    }

    public boolean isHideNoJoins() {
        return this._chkHideNoJoins.isSelected();
    }

    public WhereTreeNodeStructure getWhereTreeNodeStructure() {
        return this._graphQueryWherePanelCtrl.getWhereTreeNodeStructure();
    }

    public OrderStructureXmlBean getOrderStructure() {
        return this._graphQueryOrderPanelCtrl.getOrderStructure();
    }

    public SelectStructureXmlBean getSelectStructure() {
        return this._graphQuerySelectPanelCtrl.getSelectStructure();
    }

    public void graphClosed() {
        this._graphQueryResultPanelCtrl.graphClosed();
    }
}

