/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;

public class QueryFilterDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryFilterDlg.class);
    private static final int MIN_HEIGHT = 270;
    JTextField _txtFilter;
    JButton _btnOk;
    JButton _btnCancel;
    JButton _btnClearFilter;
    JCheckBox _chkApplyQuotes;
    JComboBox _cboOperator;
    JButton _btnEscapeDate;
    private static final String PREF_KEY_QUERY_FILTER_WIDTH = "Squirrel.queryFilterDlg.widht";
    private static final String PREF_KEY_QUERY_FILTER_HEIGHT = "Squirrel.queryFilterDlg.height";

    public QueryFilterDlg(Window parent, GraphPluginResources rsrc, String qualifiedColumn) {
        super(parent, s_stringMgr.getString("QueryFilterDlg.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(15, 5, 20, 5), 0, 0);
        JLabel lbl = new JLabel(s_stringMgr.getString("QueryFilterDlg.column", new Object[]{qualifiedColumn}));
        lbl.setFont(lbl.getFont().deriveFont(1));
        this.getContentPane().add((Component)lbl, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JLabel(s_stringMgr.getString("QueryFilterDlg.operator")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._cboOperator = new JComboBox();
        this.getContentPane().add((Component)this._cboOperator, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JLabel(s_stringMgr.getString("QueryFilterDlg.filterValue")), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createFilterPanel(rsrc), gbc);
        gbc = new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 2, new Insets(30, 5, 5, 5), 0, 0);
        this._chkApplyQuotes = new JCheckBox(s_stringMgr.getString("QueryFilterDlg.AlwaysAppendQuotes"));
        JPanel pnl = new JPanel(new GridLayout(1, 1));
        pnl.add(this._chkApplyQuotes);
        pnl.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)pnl, gbc);
        gbc = new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JPanel(), gbc);
        GUIUtils.enableCloseByEscape((JDialog)this);
        this.getRootPane().setDefaultButton(this._btnOk);
        int width = Props.getInt((String)PREF_KEY_QUERY_FILTER_WIDTH, (int)500);
        int height = Props.getInt((String)PREF_KEY_QUERY_FILTER_HEIGHT, (int)270);
        this.setSize(new Dimension(width, height));
    }

    private JPanel createFilterPanel(GraphPluginResources rsrc) {
        JPanel ret = new JPanel(new BorderLayout(5, 0));
        this._txtFilter = new JTextField();
        ret.add((Component)this._txtFilter, "Center");
        this._btnEscapeDate = new JButton(rsrc.getIcon("escapedate"));
        this._btnEscapeDate.setToolTipText(s_stringMgr.getString("QueryFilterDlg.btnEscapeDate"));
        this._btnEscapeDate.setBorder(BorderFactory.createEmptyBorder());
        ret.add((Component)this._btnEscapeDate, "East");
        return ret;
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnOk = new JButton(s_stringMgr.getString("QueryFilterDlg.btnOK"));
        ret.add((Component)this._btnOk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnClearFilter = new JButton(s_stringMgr.getString("QueryFilterDlg.btnClearFilter"));
        ret.add((Component)this._btnClearFilter, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnCancel = new JButton(s_stringMgr.getString("QueryFilterDlg.btnCancel"));
        ret.add((Component)this._btnCancel, gbc);
        return ret;
    }

    void saveCurrentSize() {
        Props.putInt((String)PREF_KEY_QUERY_FILTER_WIDTH, (int)this.getSize().width);
        Props.putInt((String)PREF_KEY_QUERY_FILTER_HEIGHT, (int)Math.max(this.getSize().height, 270));
    }
}

