/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereClauseOperator;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereConditionColumnWrapper;

public class WhereTreeNodeStructure {
    private boolean _expanded;
    private WhereClauseOperator _whereOp;
    private String _whereCondDef;
    private String _whereCondDisplay;
    private WhereTreeNodeStructure[] _kids;

    public WhereTreeNodeStructure(DefaultMutableTreeNode node, JTree tree) {
        this._expanded = tree.isExpanded(new TreePath(node.getPath()));
        if (node.getUserObject() instanceof WhereClauseOperator) {
            this._whereOp = (WhereClauseOperator)((Object)node.getUserObject());
        } else {
            this._whereCondDef = ((WhereConditionColumnWrapper)node.getUserObject()).getDefinition();
            this._whereCondDisplay = ((WhereConditionColumnWrapper)node.getUserObject()).getDisplay();
        }
        this._kids = new WhereTreeNodeStructure[node.getChildCount()];
        for (int i = 0; i < node.getChildCount(); ++i) {
            this._kids[i] = new WhereTreeNodeStructure((DefaultMutableTreeNode)node.getChildAt(i), tree);
        }
    }

    public void applyExpansion(DefaultMutableTreeNode node, JTree tree) {
        if (this.equals(new WhereTreeNodeStructure(node, tree)) && this._expanded) {
            tree.expandPath(new TreePath(node.getPath()));
        }
        for (int i = 0; i < node.getChildCount() && i < this._kids.length; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!this._kids[i].equals(new WhereTreeNodeStructure(child, tree))) continue;
            this._kids[i].applyExpansion(child, tree);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WhereTreeNodeStructure)) {
            return false;
        }
        WhereTreeNodeStructure other = (WhereTreeNodeStructure)obj;
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    private String getKey() {
        return this._whereOp + "#" + this._whereCondDef;
    }

    public void initTree(DefaultMutableTreeNode root, ArrayList<WhereConditionColumnWrapper> filteredCols, JTree tree) {
        this._initTree(root, filteredCols);
        for (WhereConditionColumnWrapper filteredCol : filteredCols) {
            root.add(new DefaultMutableTreeNode(filteredCol));
        }
        this.applyExpansion(root, tree);
    }

    private void _initTree(DefaultMutableTreeNode node, ArrayList<WhereConditionColumnWrapper> filteredCols) {
        for (int i = 0; i < this._kids.length; ++i) {
            if (null == this._kids[i]._whereCondDef) {
                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode((Object)this._kids[i]._whereOp);
                node.add(newChild);
                this._kids[i]._initTree(newChild, filteredCols);
                continue;
            }
            WhereConditionColumnWrapper wrapper = this.getAndRemove(this._kids[i]._whereCondDef, filteredCols);
            if (null == wrapper) continue;
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(wrapper);
            node.add(newChild);
        }
    }

    private WhereConditionColumnWrapper getAndRemove(String whereCondDef, ArrayList<WhereConditionColumnWrapper> filteredCols) {
        for (WhereConditionColumnWrapper filteredCol : filteredCols) {
            if (!filteredCol.getDefinition().equalsIgnoreCase(whereCondDef)) continue;
            filteredCols.remove(filteredCol);
            return filteredCol;
        }
        return null;
    }

    public String generateWhereClause() {
        if (WhereClauseOperator.WHERE != this._whereOp) {
            throw new UnsupportedOperationException("This method should only be called on the where node");
        }
        Object ret = null;
        for (int i = 0; i < this._kids.length; ++i) {
            String kidClause = this._kids[i]._getWhereClause();
            if (null == kidClause) continue;
            ret = null == ret ? kidClause : (String)ret + " " + WhereClauseOperator.AND.getOpSQL() + " " + kidClause;
        }
        if (null != ret) {
            return WhereClauseOperator.WHERE.getOpSQL() + " " + ret;
        }
        return "";
    }

    private String _getWhereClause() {
        if (null == this._whereOp) {
            return this._whereCondDisplay;
        }
        Object ret = null;
        for (int i = 0; i < this._kids.length; ++i) {
            String kidClause = this._kids[i]._getWhereClause();
            if (null == kidClause) continue;
            ret = null == ret ? kidClause : (String)ret + " " + this._whereOp.getOpSQL() + " " + kidClause;
        }
        if (null != ret) {
            ret = "(" + ret + ")";
        }
        return ret;
    }

    public WhereTreeNodeStructure() {
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    public int getWhereOpIdx() {
        if (null == this._whereOp) {
            return -1;
        }
        return this._whereOp.getIdx();
    }

    public void setWhereOpIdx(int whereOpIdx) {
        this._whereOp = -1 == whereOpIdx ? null : WhereClauseOperator.getByIx(whereOpIdx);
    }

    public String getWhereCondDef() {
        return this._whereCondDef;
    }

    public void setWhereCondDef(String whereCondDef) {
        this._whereCondDef = whereCondDef;
    }

    public WhereTreeNodeStructure[] getKids() {
        return this._kids;
    }

    public void setKids(WhereTreeNodeStructure[] kids) {
        this._kids = kids;
    }
}

