/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.xmlbeans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.link.LinkXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.DefaultGraphXmlSerializerConfig;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.LegacyNanoxmlConverter;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.Version32Converter;

public class GraphXmlSerializer {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphXmlSerializer.class);
    private static final ILogger s_log = LoggerController.createLogger(GraphXmlSerializer.class);
    private DefaultGraphXmlSerializerConfig _cfg;
    private ISession _session;

    public GraphXmlSerializer(GraphPlugin plugin, ISession session, String graphFileName) {
        this._session = session;
        this._cfg = new DefaultGraphXmlSerializerConfig(plugin, session, graphFileName);
    }

    public GraphXmlSerializer(GraphPlugin plugin, ISession session, LinkXmlBean linkXmlBean, String pathOfLinkXmlFile) {
        this._session = session;
        this._cfg = new DefaultGraphXmlSerializerConfig(plugin, session, linkXmlBean, pathOfLinkXmlFile);
    }

    public void write(GraphControllerXmlBean xmlBean) {
        try {
            this._cfg.checkTargetWritable();
            Version32Converter.markConverted(xmlBean);
            XMLBeanWriter bw = new XMLBeanWriter((Object)xmlBean);
            bw.save(this._cfg.getGraphFilePath());
            String[] params = new String[]{xmlBean.getTitle(), this._cfg.getGraphFilePath()};
            String msg = s_stringMgr.getString("graph.graphSaved", params);
            this._session.showMessage(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveLinkAsLocalCopy(GraphControllerXmlBean xmlBean) {
        if (!this.isLink()) {
            throw new IllegalStateException("Not a link");
        }
        this._cfg.transformToLocalCopy();
        this.write(xmlBean);
    }

    public GraphControllerXmlBean read() {
        try {
            XMLBeanReader br = new XMLBeanReader();
            br.load(LegacyNanoxmlConverter.convertXml(this._cfg.getGraphFilePath()), this.getClass().getClassLoader());
            GraphControllerXmlBean ret = (GraphControllerXmlBean)br.iterator().next();
            Version32Converter.convert(ret);
            if (this._cfg.isLink()) {
                ret.setTitle(this._cfg.getTitle());
            } else {
                this._cfg.setTitle(ret.getTitle());
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphXmlSerializer[] getGraphXmSerializers(GraphPlugin plugin, ISession session) {
        try {
            final String urlPrefix = StringUtilities.javaNormalize((String)session.getAlias().getUrl()) + ".";
            FileWrapper[] graphXmlFiles = plugin.getPluginUserSettingsFolder().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(urlPrefix);
                }
            });
            return GraphXmlSerializer.createSerializers(plugin, session, graphXmlFiles);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphXmlSerializer[] getLinkedGraphXmSerializers(GraphPlugin plugin, ISession session) {
        try {
            final String linkPrefix = DefaultGraphXmlSerializerConfig.getLinkPrefix(session);
            FileWrapper[] linkXmlFiles = plugin.getPluginUserSettingsFolder().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(linkPrefix);
                }
            });
            ArrayList<GraphXmlSerializer> xmlSerializers = new ArrayList<GraphXmlSerializer>();
            for (FileWrapper linkXmlFile : linkXmlFiles) {
                XMLBeanReader br = new XMLBeanReader();
                br.load(linkXmlFile, GraphXmlSerializer.class.getClassLoader());
                LinkXmlBean linkXmlBean = (LinkXmlBean)br.iterator().next();
                if (new File(linkXmlBean.getFilePathOfLinkedGraph()).canRead()) {
                    xmlSerializers.add(new GraphXmlSerializer(plugin, session, linkXmlBean, linkXmlFile.getAbsolutePath()));
                    continue;
                }
                String msg = s_stringMgr.getString("graph.link.cannotRead", new Object[]{linkXmlBean.getNameOfLinkedGraph(), linkXmlBean.getFilePathOfLinkedGraph(), linkXmlFile.getAbsolutePath()});
                session.getApplication().getMessageHandler().showErrorMessage(msg);
                s_log.error((Object)msg, (Throwable)new IllegalStateException(msg));
            }
            return xmlSerializers.toArray(new GraphXmlSerializer[xmlSerializers.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static GraphXmlSerializer[] createSerializers(GraphPlugin plugin, ISession session, FileWrapper[] graphXmlFiles) {
        GraphXmlSerializer[] ret = new GraphXmlSerializer[graphXmlFiles.length];
        for (int i = 0; i < graphXmlFiles.length; ++i) {
            ret[i] = new GraphXmlSerializer(plugin, session, graphXmlFiles[i].getPath());
        }
        return ret;
    }

    public static GraphXmlSerializer[] getGraphXmlSerializersInPath(GraphPlugin graphPlugin, ISession session, FileWrapper path) {
        FileWrapper[] graphXmlFiles = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml") && GraphXmlSerializer.containsGraphControllerXmlBeanTag(new File(dir, name));
            }
        });
        return GraphXmlSerializer.createSerializers(graphPlugin, session, graphXmlFiles);
    }

    private static boolean containsGraphControllerXmlBeanTag(File file) {
        try {
            BufferedReader br = new FileWrapperFactoryImpl().create(file).getBufferedReader();
            String line = br.readLine();
            while (null != line) {
                if (-1 < line.indexOf(GraphControllerXmlBean.class.getName())) {
                    br.close();
                    return true;
                }
                line = br.readLine();
            }
            br.close();
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void rename(String newName) {
        try {
            this._cfg.renameGraph(newName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        this._cfg.removeGraphFile();
    }

    public void detach() {
        this._cfg.detachGraphFile();
    }

    public String getGraphFile() {
        return this._cfg.getGraphFilePath();
    }

    public boolean isLink() {
        return this._cfg.isLink();
    }

    public void removeLink() {
        this._cfg.removeLink();
    }

    public LinkXmlBean getLinkXmlBean() {
        return this._cfg.getLinkXmlBean();
    }

    public String getTitle() {
        return this._cfg.getTitle();
    }

    public boolean isLoadable() {
        return this._cfg.isLoadable();
    }

    public String getLinkFile() {
        return this._cfg.getPathOfLinkXmlFile();
    }
}

