/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;

public class RadianceColorSchemeBundle {
    private RadianceColorScheme activeColorScheme;
    private RadianceColorScheme enabledColorScheme;
    private RadianceColorScheme disabledColorScheme;
    private Map<ComponentState, Float> stateAlphaMap;
    private Map<ComponentState, Float> stateHighlightSchemeAlphaMap;
    private RadianceColorScheme pressedScheme;
    private RadianceColorScheme disabledSelectedScheme;
    private RadianceColorScheme selectedScheme;
    private RadianceColorScheme rolloverSelectedScheme;
    private Map<RadianceThemingSlices.ColorSchemeAssociationKind, Map<ComponentState, RadianceColorScheme>> colorSchemeMap;
    private Map<RadianceThemingSlices.ColorSchemeAssociationKind, Map<ComponentState, ComponentState>> bestFillMap;

    public RadianceColorSchemeBundle(RadianceColorScheme activeColorScheme, RadianceColorScheme enabledColorScheme, RadianceColorScheme disabledColorScheme) {
        if (activeColorScheme == null || enabledColorScheme == null || disabledColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null schemes");
        }
        this.activeColorScheme = activeColorScheme;
        this.enabledColorScheme = enabledColorScheme;
        this.disabledColorScheme = disabledColorScheme;
        this.stateAlphaMap = new HashMap<ComponentState, Float>();
        this.stateHighlightSchemeAlphaMap = new HashMap<ComponentState, Float>();
        this.colorSchemeMap = new HashMap<RadianceThemingSlices.ColorSchemeAssociationKind, Map<ComponentState, RadianceColorScheme>>();
        for (RadianceThemingSlices.ColorSchemeAssociationKind associationKind : RadianceThemingSlices.ColorSchemeAssociationKind.values()) {
            this.colorSchemeMap.put(associationKind, new HashMap());
        }
        this.bestFillMap = new HashMap<RadianceThemingSlices.ColorSchemeAssociationKind, Map<ComponentState, ComponentState>>();
        for (RadianceThemingSlices.ColorSchemeAssociationKind associationKind : RadianceThemingSlices.ColorSchemeAssociationKind.values()) {
            this.bestFillMap.put(associationKind, new HashMap());
        }
    }

    public void registerAlpha(float alpha, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.getAllStates()) {
                this.stateAlphaMap.put(state, Float.valueOf(alpha));
            }
        } else {
            for (ComponentState state : states) {
                this.stateAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public void registerColorScheme(RadianceColorScheme stateColorScheme, ComponentState ... states) {
        this.registerColorScheme(stateColorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, states);
    }

    public void registerHighlightColorScheme(RadianceColorScheme stateHighlightScheme, ComponentState ... states) {
        if (stateHighlightScheme == null) {
            throw new IllegalArgumentException("Cannot pass null color scheme");
        }
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.getAllStates()) {
                if (this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT).containsKey(state) || state.isDisabled() || state == ComponentState.ENABLED) continue;
                this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
            }
        }
    }

    public void registerHighlightAlpha(float alpha, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.getAllStates()) {
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        } else {
            for (ComponentState state : states) {
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public RadianceColorScheme getColorScheme(ComponentState componentState) {
        ComponentState bestFit;
        RadianceColorScheme registered = this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.FILL).get(componentState);
        if (registered != null) {
            return registered;
        }
        Map<ComponentState, ComponentState> bestFitForFill = this.bestFillMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.FILL);
        if (!bestFitForFill.containsKey(componentState)) {
            Set<ComponentState> registeredStates = this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.FILL).keySet();
            bestFitForFill.put(componentState, componentState.bestFit(registeredStates));
        }
        if ((bestFit = bestFitForFill.get(componentState)) != null && (registered = this.colorSchemeMap.get(RadianceThemingSlices.ColorSchemeAssociationKind.FILL).get(bestFit)) != null) {
            return registered;
        }
        if (componentState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.PRESS)) {
            if (this.pressedScheme == null) {
                this.pressedScheme = this.activeColorScheme.shade(0.2).saturate(0.1);
            }
            return this.pressedScheme;
        }
        if (componentState == ComponentState.DISABLED_SELECTED) {
            if (this.disabledSelectedScheme == null) {
                this.disabledSelectedScheme = this.activeColorScheme.blendWith(this.disabledColorScheme, 0.25);
            }
            return this.disabledSelectedScheme;
        }
        if (componentState == ComponentState.SELECTED) {
            if (this.selectedScheme == null) {
                this.selectedScheme = this.activeColorScheme.saturate(0.2);
            }
            return this.selectedScheme;
        }
        if (componentState == ComponentState.ROLLOVER_SELECTED) {
            if (this.rolloverSelectedScheme == null) {
                this.rolloverSelectedScheme = this.activeColorScheme.tint(0.1).saturate(0.1);
            }
            return this.rolloverSelectedScheme;
        }
        ComponentState hardFallback = componentState.getHardFallback();
        if (hardFallback != null) {
            return this.getColorScheme(hardFallback);
        }
        if (componentState == ComponentState.ENABLED) {
            return this.enabledColorScheme;
        }
        if (componentState.isDisabled()) {
            return this.disabledColorScheme;
        }
        return this.activeColorScheme;
    }

    public float getHighlightAlpha(ComponentState componentState) {
        Float registered = this.stateHighlightSchemeAlphaMap.get(componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public float getAlpha(ComponentState componentState) {
        Float registered = this.stateAlphaMap.get(componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public RadianceColorScheme getActiveColorScheme() {
        return this.activeColorScheme;
    }

    public RadianceColorScheme getEnabledColorScheme() {
        return this.enabledColorScheme;
    }

    public RadianceColorScheme getDisabledColorScheme() {
        return this.disabledColorScheme;
    }

    public void registerColorScheme(RadianceColorScheme scheme, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState ... states) {
        if (scheme == null) {
            throw new IllegalArgumentException("Cannot pass null color scheme");
        }
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.getAllStates()) {
                if (this.colorSchemeMap.get(associationKind).containsKey(state)) continue;
                this.colorSchemeMap.get(associationKind).put(state, scheme);
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(associationKind).put(state, scheme);
            }
        }
    }

    public RadianceColorScheme getColorScheme(RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState, boolean allowFallback) {
        ComponentState bestFit;
        if (associationKind == RadianceThemingSlices.ColorSchemeAssociationKind.FILL) {
            return this.getColorScheme(componentState);
        }
        RadianceColorScheme registered = this.colorSchemeMap.get(associationKind).get(componentState);
        if (registered != null) {
            return registered;
        }
        Map<ComponentState, ComponentState> bestFitForState = this.bestFillMap.get(associationKind);
        if (!bestFitForState.containsKey(componentState)) {
            Set<ComponentState> registeredStates = this.colorSchemeMap.get(associationKind).keySet();
            bestFitForState.put(componentState, componentState.bestFit(registeredStates));
        }
        if ((bestFit = bestFitForState.get(componentState)) != null && (registered = this.colorSchemeMap.get(associationKind).get(bestFit)) != null) {
            return registered;
        }
        if (!allowFallback) {
            return null;
        }
        RadianceThemingSlices.ColorSchemeAssociationKind fallback = associationKind.getFallback();
        if (fallback == null) {
            return null;
        }
        return this.getColorScheme(fallback, componentState, allowFallback);
    }

    RadianceColorSchemeBundle transform(ColorSchemeTransform transform) {
        RadianceColorSchemeBundle result = new RadianceColorSchemeBundle(transform.transform(this.activeColorScheme), transform.transform(this.enabledColorScheme), transform.transform(this.disabledColorScheme));
        for (Map.Entry<RadianceThemingSlices.ColorSchemeAssociationKind, Map<ComponentState, RadianceColorScheme>> entry : this.colorSchemeMap.entrySet()) {
            for (Map.Entry<ComponentState, RadianceColorScheme> subEntry : entry.getValue().entrySet()) {
                result.colorSchemeMap.get(entry.getKey()).put(subEntry.getKey(), transform.transform(subEntry.getValue()));
            }
        }
        if (this.stateAlphaMap != null) {
            result.stateAlphaMap = new HashMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            result.stateHighlightSchemeAlphaMap = new HashMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return result;
    }

    Set<ComponentState> getStatesWithAlpha() {
        HashSet<ComponentState> result = new HashSet<ComponentState>();
        for (Map.Entry<ComponentState, Float> alphaEntry : this.stateAlphaMap.entrySet()) {
            if (!(alphaEntry.getValue().floatValue() < 1.0f)) continue;
            result.add(alphaEntry.getKey());
        }
        return result;
    }

    public static interface Overlay {
        public void overlay(RadianceColorSchemeBundle var1);
    }
}

