/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api;

import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceColorSchemeBundle;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SteelBlueColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.painter.highlight.RadianceHighlightPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.trait.RadianceTrait;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.SkinUtilities;

public abstract class RadianceSkin
implements RadianceTrait {
    public static final double DEFAULT_TAB_FADE_START = 0.1;
    public static final double DEFAULT_TAB_FADE_END = 0.3;
    private Map<RadianceThemingSlices.DecorationAreaType, RadianceColorSchemeBundle> colorSchemeBundleMap = new HashMap<RadianceThemingSlices.DecorationAreaType, RadianceColorSchemeBundle>();
    private Map<RadianceThemingSlices.DecorationAreaType, RadianceColorScheme> backgroundColorSchemeMap = new HashMap<RadianceThemingSlices.DecorationAreaType, RadianceColorScheme>();
    private Map<RadianceThemingSlices.DecorationAreaType, List<RadianceOverlayPainter>> overlayPaintersMap = new HashMap<RadianceThemingSlices.DecorationAreaType, List<RadianceOverlayPainter>>();
    protected RadianceButtonShaper buttonShaper;
    protected RadianceFillPainter fillPainter;
    protected RadianceBorderPainter borderPainter;
    protected RadianceBorderPainter highlightBorderPainter;
    protected RadianceHighlightPainter highlightPainter;
    protected RadianceDecorationPainter decorationPainter;
    private Set<RadianceThemingSlices.DecorationAreaType> decoratedAreaSet;
    protected double tabFadeStart;
    protected double tabFadeEnd;
    private Set<ComponentState> statesWithAlpha;
    private Map<RadianceThemingSlices.ColorOverlayType, Map<RadianceThemingSlices.DecorationAreaType, Map<ComponentState, Color>>> colorOverlayMap = new HashMap<RadianceThemingSlices.ColorOverlayType, Map<RadianceThemingSlices.DecorationAreaType, Map<ComponentState, Color>>>();
    private Map<Integer, RadianceColorScheme> optionPaneIconColorSchemeMap;

    protected RadianceSkin() {
        this.decoratedAreaSet = new HashSet<RadianceThemingSlices.DecorationAreaType>();
        this.decoratedAreaSet.add(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.decoratedAreaSet.add(RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        this.tabFadeStart = 0.1;
        this.tabFadeEnd = 0.3;
        this.optionPaneIconColorSchemeMap = new HashMap<Integer, RadianceColorScheme>();
        SunsetColorScheme sunset = new SunsetColorScheme();
        SteelBlueColorScheme steelBlue = new SteelBlueColorScheme();
        this.optionPaneIconColorSchemeMap.put(0, sunset);
        this.optionPaneIconColorSchemeMap.put(2, sunset);
        this.optionPaneIconColorSchemeMap.put(1, steelBlue);
        this.optionPaneIconColorSchemeMap.put(3, steelBlue);
        this.statesWithAlpha = new HashSet<ComponentState>();
    }

    public final RadianceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public final RadianceBorderPainter getHighlightBorderPainter() {
        return this.highlightBorderPainter;
    }

    public final RadianceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public final RadianceFillPainter getFillPainter() {
        return this.fillPainter;
    }

    public final RadianceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public final RadianceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        SkinUtilities.addCustomEntriesToTable(table, this);
    }

    public final RadianceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        RadianceColorScheme registered;
        if (this.colorSchemeBundleMap.size() > 1) {
            RadianceThemingSlices.DecorationAreaType decorationAreaType;
            RadianceThemingSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? RadianceThemingSlices.DecorationAreaType.NONE : RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                RadianceColorScheme registered2 = this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(componentState);
                if (registered2 == null) {
                    throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
                }
                return registered2;
            }
        }
        if ((registered = this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getColorScheme(componentState)) == null) {
            throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
        }
        return registered;
    }

    public final float getHighlightAlpha(Component comp, ComponentState componentState) {
        float registered;
        RadianceThemingSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(comp)) && (double)(registered = this.colorSchemeBundleMap.get(decorationAreaType).getHighlightAlpha(componentState)) >= 0.0) {
            return registered;
        }
        float registered2 = this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getHighlightAlpha(componentState);
        if ((double)registered2 >= 0.0) {
            return registered2;
        }
        boolean isRollover = componentState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER);
        boolean isSelected = componentState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION);
        boolean isArmed = componentState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public final float getAlpha(Component comp, ComponentState componentState) {
        float registered;
        ComponentState fallback = componentState.getHardFallback();
        if (fallback == null && !this.statesWithAlpha.contains(componentState)) {
            return 1.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1) {
            float registered2;
            RadianceThemingSlices.DecorationAreaType decorationAreaType;
            RadianceThemingSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? RadianceThemingSlices.DecorationAreaType.NONE : RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (double)(registered2 = this.colorSchemeBundleMap.get(decorationAreaType).getAlpha(componentState)) >= 0.0) {
                return registered2;
            }
        }
        if ((double)(registered = this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getAlpha(componentState)) >= 0.0) {
            return registered;
        }
        if (fallback == null) {
            return 1.0f;
        }
        return this.getAlpha(comp, fallback);
    }

    public void registerDecorationAreaSchemeBundle(RadianceColorSchemeBundle bundle, RadianceColorScheme backgroundColorScheme, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        if (bundle == null) {
            return;
        }
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (RadianceThemingSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.colorSchemeBundleMap.put(areaType, bundle);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
        this.statesWithAlpha.addAll(bundle.getStatesWithAlpha());
    }

    public void registerDecorationAreaSchemeBundle(RadianceColorSchemeBundle bundle, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        this.registerDecorationAreaSchemeBundle(bundle, bundle.getEnabledColorScheme(), areaTypes);
    }

    public void registerAsDecorationArea(RadianceColorScheme backgroundColorScheme, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (RadianceThemingSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public void registerAsDecorationArea(RadianceColorScheme backgroundColorScheme, RadianceColorSchemeBundle.Overlay noneTransformationOverlay, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        RadianceColorSchemeBundle defaultBundle = this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE);
        if (defaultBundle == null) {
            throw new IllegalStateException("Cannot apply overlay without a registered NONE bundle");
        }
        RadianceColorSchemeBundle noneCopy = defaultBundle.transform(scheme -> scheme);
        noneTransformationOverlay.overlay(noneCopy);
        this.registerDecorationAreaSchemeBundle(noneCopy, backgroundColorScheme, areaTypes);
    }

    public boolean isRegisteredAsDecorationArea(RadianceThemingSlices.DecorationAreaType decorationType) {
        return this.decoratedAreaSet.contains(decorationType);
    }

    public final RadianceColorScheme getActiveColorScheme(RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final RadianceColorScheme getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final RadianceColorScheme getDisabledColorScheme(RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final double getTabFadeStart() {
        return this.tabFadeStart;
    }

    public final double getTabFadeEnd() {
        return this.tabFadeEnd;
    }

    public void setTabFadeEnd(double tabFadeEnd) {
        if (tabFadeEnd < 0.0 || tabFadeEnd > 1.0) {
            throw new IllegalArgumentException("Value for tab fade end should be in 0.0-1.0 range");
        }
        this.tabFadeEnd = tabFadeEnd;
    }

    public void setTabFadeStart(double tabFadeStart) {
        if (tabFadeStart < 0.0 || tabFadeStart > 1.0) {
            throw new IllegalArgumentException("Value for tab fade start should be in 0.0-1.0 range");
        }
        this.tabFadeStart = tabFadeStart;
    }

    public void addOverlayPainter(RadianceOverlayPainter overlayPainter, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        for (RadianceThemingSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                this.overlayPaintersMap.put(areaType, new ArrayList());
            }
            this.overlayPaintersMap.get(areaType).add(overlayPainter);
        }
    }

    public void removeOverlayPainter(RadianceOverlayPainter overlayPainter, RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        for (RadianceThemingSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                return;
            }
            this.overlayPaintersMap.get(areaType).remove(overlayPainter);
            if (this.overlayPaintersMap.get(areaType).size() != 0) continue;
            this.overlayPaintersMap.remove(areaType);
        }
    }

    public void clearOverlayPainters(RadianceThemingSlices.DecorationAreaType ... areaTypes) {
        for (RadianceThemingSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                return;
            }
            this.overlayPaintersMap.get(areaType).clear();
            this.overlayPaintersMap.remove(areaType);
        }
    }

    public List<RadianceOverlayPainter> getOverlayPainters(RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.overlayPaintersMap.get(decorationAreaType));
    }

    public final RadianceColorScheme getColorScheme(RadianceThemingSlices.DecorationAreaType decorationAreaType, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final RadianceColorScheme getColorScheme(Component comp, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1) {
            RadianceThemingSlices.DecorationAreaType decorationAreaType;
            RadianceThemingSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? RadianceThemingSlices.DecorationAreaType.NONE : RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
            }
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final RadianceColorScheme getDirectColorScheme(Component comp, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        RadianceThemingSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(comp))) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, false);
        }
        return this.colorSchemeBundleMap.get(RadianceThemingSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, false);
    }

    public RadianceSkin transform(ColorSchemeTransform transform, final String name) {
        RadianceSkin result = new RadianceSkin(){

            @Override
            public String getDisplayName() {
                return name;
            }
        };
        result.borderPainter = this.borderPainter;
        result.buttonShaper = this.buttonShaper;
        result.decorationPainter = this.decorationPainter;
        result.fillPainter = this.fillPainter;
        result.highlightPainter = this.highlightPainter;
        result.highlightBorderPainter = this.highlightBorderPainter;
        result.tabFadeEnd = this.tabFadeEnd;
        result.tabFadeStart = this.tabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            result.colorSchemeBundleMap = new HashMap<RadianceThemingSlices.DecorationAreaType, RadianceColorSchemeBundle>();
            for (Map.Entry<RadianceThemingSlices.DecorationAreaType, RadianceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                result.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(transform));
            }
        }
        if (this.decoratedAreaSet != null) {
            result.decoratedAreaSet = new HashSet<RadianceThemingSlices.DecorationAreaType>(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            result.backgroundColorSchemeMap = new HashMap<RadianceThemingSlices.DecorationAreaType, RadianceColorScheme>();
            for (Map.Entry<RadianceThemingSlices.DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                result.backgroundColorSchemeMap.put(entry.getKey(), transform.transform((RadianceColorScheme)entry.getValue()));
            }
        }
        result.overlayPaintersMap = new HashMap<RadianceThemingSlices.DecorationAreaType, List<RadianceOverlayPainter>>(this.overlayPaintersMap);
        return result;
    }

    public final RadianceColorScheme getBackgroundColorScheme(RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        RadianceColorScheme registered;
        if (this.backgroundColorSchemeMap.containsKey(decorationAreaType)) {
            return this.backgroundColorSchemeMap.get(decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (registered = this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme()) != null) {
            return registered;
        }
        return this.backgroundColorSchemeMap.get(RadianceThemingSlices.DecorationAreaType.NONE);
    }

    public void setOverlayColor(Color color, RadianceThemingSlices.ColorOverlayType colorOverlayType, RadianceThemingSlices.DecorationAreaType decorationAreaType, ComponentState ... componentStates) {
        Map<RadianceThemingSlices.DecorationAreaType, Map<ComponentState, Color>> forOverlay;
        if (!this.colorOverlayMap.containsKey((Object)colorOverlayType)) {
            this.colorOverlayMap.put(colorOverlayType, new HashMap());
        }
        if (!(forOverlay = this.colorOverlayMap.get((Object)colorOverlayType)).containsKey(decorationAreaType)) {
            forOverlay.put(decorationAreaType, new HashMap());
        }
        Map<ComponentState, Color> forDecorationArea = forOverlay.get(decorationAreaType);
        for (ComponentState componentState : componentStates) {
            forDecorationArea.put(componentState, color);
        }
    }

    public Color getOverlayColor(RadianceThemingSlices.ColorOverlayType colorOverlayType, RadianceThemingSlices.DecorationAreaType decorationAreaType, ComponentState componentState) {
        if (!this.colorOverlayMap.containsKey((Object)colorOverlayType)) {
            return null;
        }
        Map<RadianceThemingSlices.DecorationAreaType, Map<ComponentState, Color>> forOverlay = this.colorOverlayMap.get((Object)colorOverlayType);
        if (!forOverlay.containsKey(decorationAreaType)) {
            return null;
        }
        return forOverlay.get(decorationAreaType).get(componentState);
    }

    public void setOptionPaneIconColorScheme(RadianceColorScheme colorScheme, int ... optionPaneMessageTypes) {
        if (colorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null color scheme");
        }
        for (int optionPaneMessageType : optionPaneMessageTypes) {
            if (optionPaneMessageType == 0 || optionPaneMessageType == 2 || optionPaneMessageType == 1 || optionPaneMessageType == 3) continue;
            throw new IllegalArgumentException("Unsupported message type " + optionPaneMessageType);
        }
        for (int optionPaneMessageType : optionPaneMessageTypes) {
            this.optionPaneIconColorSchemeMap.put(optionPaneMessageType, colorScheme);
        }
    }

    public RadianceColorScheme getOptionPaneIconColorScheme(int optionPaneMessageType) {
        return this.optionPaneIconColorSchemeMap.get(optionPaneMessageType);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey(RadianceThemingSlices.DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getFillPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }

    public static ColorSchemes getColorSchemes(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Can't read color schemes from a null stream");
        }
        return RadianceColorSchemeUtilities.getColorSchemes(inputStream);
    }

    public static interface ColorSchemes {
        public Collection<RadianceColorScheme> getAll();

        public RadianceColorScheme get(String var1);
    }

    public static abstract class Accented
    extends RadianceSkin {
        private final RadianceColorScheme windowChromeAccent;
        private final RadianceColorScheme activeControlsAccent;
        private final RadianceColorScheme enabledControlsAccent;
        private final RadianceColorScheme highlightsAccent;
        private final RadianceColorScheme backgroundAccent;

        protected Accented(AccentBuilder accentBuilder) {
            this.windowChromeAccent = accentBuilder.windowChromeAccent;
            this.activeControlsAccent = accentBuilder.activeControlsAccent;
            this.enabledControlsAccent = accentBuilder.enabledControlsAccent;
            this.highlightsAccent = accentBuilder.highlightsAccent;
            this.backgroundAccent = accentBuilder.backgroundAccent;
        }

        public RadianceColorScheme getBackgroundAccent() {
            return this.backgroundAccent;
        }

        public RadianceColorScheme getActiveControlsAccent() {
            return this.activeControlsAccent;
        }

        public RadianceColorScheme getEnabledControlsAccent() {
            return this.enabledControlsAccent;
        }

        public RadianceColorScheme getHighlightsAccent() {
            return this.highlightsAccent;
        }

        public RadianceColorScheme getWindowChromeAccent() {
            return this.windowChromeAccent;
        }

        public static final class AccentBuilder {
            private RadianceColorScheme windowChromeAccent;
            private RadianceColorScheme enabledControlsAccent;
            private RadianceColorScheme activeControlsAccent;
            private RadianceColorScheme highlightsAccent;
            private RadianceColorScheme backgroundAccent;
            private ColorSchemes accentColorSchemes;

            public AccentBuilder withAccentResource(String colorSchemeResourceName) {
                this.accentColorSchemes = RadianceSkin.getColorSchemes(AccentBuilder.class.getClassLoader().getResourceAsStream(colorSchemeResourceName));
                return this;
            }

            public AccentBuilder withWindowChromeAccent(String windowChromeAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.windowChromeAccent = this.accentColorSchemes.get(windowChromeAccentName);
                return this;
            }

            public AccentBuilder withWindowChromeAccent(RadianceColorScheme windowChromeAccent) {
                this.windowChromeAccent = windowChromeAccent;
                return this;
            }

            public AccentBuilder withActiveControlsAccent(String activeControlsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.activeControlsAccent = this.accentColorSchemes.get(activeControlsAccentName);
                return this;
            }

            public AccentBuilder withActiveControlsAccent(RadianceColorScheme activeControlsAccent) {
                this.activeControlsAccent = activeControlsAccent;
                return this;
            }

            public AccentBuilder withEnabledControlsAccent(String enabledControlsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.enabledControlsAccent = this.accentColorSchemes.get(enabledControlsAccentName);
                return this;
            }

            public AccentBuilder withEnabledControlsAccent(RadianceColorScheme enabledControlsAccent) {
                this.enabledControlsAccent = enabledControlsAccent;
                return this;
            }

            public AccentBuilder withHighlightsAccent(String highlightsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.highlightsAccent = this.accentColorSchemes.get(highlightsAccentName);
                return this;
            }

            public AccentBuilder withHighlightsAccent(RadianceColorScheme highlightsAccent) {
                this.highlightsAccent = highlightsAccent;
                return this;
            }

            public AccentBuilder withBackgroundAccent(String backgroundAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.backgroundAccent = this.accentColorSchemes.get(backgroundAccentName);
                return this;
            }

            public AccentBuilder withBackgroundAccent(RadianceColorScheme backgroundAccent) {
                this.backgroundAccent = backgroundAccent;
                return this;
            }
        }
    }
}

