/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.font.FontPolicy;
import org.pushingpixels.radiance.common.api.font.FontSet;
import org.pushingpixels.radiance.theming.api.RadianceLookAndFeel;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingComponentPlugin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSkinPlugin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.radiance.theming.api.icon.RadianceDefaultIconPack;
import org.pushingpixels.radiance.theming.api.icon.RadianceIconPack;
import org.pushingpixels.radiance.theming.api.painter.preview.PreviewPainter;
import org.pushingpixels.radiance.theming.api.password.PasswordStrengthChecker;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.skin.SkinChangeListener;
import org.pushingpixels.radiance.theming.api.skin.SkinInfo;
import org.pushingpixels.radiance.theming.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.radiance.theming.api.tabbed.TabCloseCallback;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.RadiancePluginRepository;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRootPaneUI;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePaneUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceWidgetManager;
import org.pushingpixels.radiance.theming.internal.utils.TabCloseListenerManager;

public class RadianceThemingCortex {
    private RadianceThemingCortex() {
    }

    public static final class WindowScope {
        public static void setWidgetVisible(Window window, boolean visible, RadianceThemingSlices.WidgetType ... radianceWidgets) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                RadianceWidgetManager.getInstance().register(rootPane, visible, radianceWidgets);
                SwingUtilities.updateComponentTreeUI(rootPane);
            }
        }

        public static void extendContentIntoTitlePane(Window window, RadianceThemingSlices.HorizontalGravity controlButtonGroupHorizontalGravity, RadianceThemingSlices.VerticalGravity controlButtonGroupVerticalGravity) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            if (controlButtonGroupHorizontalGravity != RadianceThemingSlices.HorizontalGravity.LEADING && controlButtonGroupHorizontalGravity != RadianceThemingSlices.HorizontalGravity.TRAILING) {
                throw new IllegalArgumentException("Can only pass LEADING or TRAILING for control button group horizontal gravity.");
            }
            if (controlButtonGroupVerticalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for control button group vertical gravity. Did you mean CENTERED?");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                rootPane.putClientProperty("radiance.theming.internal.rootPaneContentExtendsIntoTitlePane", Boolean.TRUE);
                rootPane.putClientProperty("radiance.theming.internal.titleControlButtonGroupHorizontalGravity", (Object)controlButtonGroupHorizontalGravity);
                rootPane.putClientProperty("radiance.theming.internal.titleControlButtonGroupVerticalGravity", (Object)controlButtonGroupVerticalGravity);
                RadianceRootPaneUI ui = (RadianceRootPaneUI)rootPane.getUI();
                ui.extendContentIntoTitlePane();
            }
        }

        public static JButton createTitlePaneControlButton(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                RadianceRootPaneUI ui = (RadianceRootPaneUI)rootPane.getUI();
                return ui.createTitlePaneControlButton();
            }
            return null;
        }

        public static Insets getTitlePaneControlInsets(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                RadianceRootPaneUI ui = (RadianceRootPaneUI)rootPane.getUI();
                return ui.getTitlePaneControlInsets();
            }
            return null;
        }

        public static void setPreferredTitlePaneHeight(Window window, int preferredTitlePaneHeight) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            if (preferredTitlePaneHeight <= 0) {
                throw new IllegalArgumentException("Should pass positive value");
            }
            JRootPane rootPane = SwingUtilities.getRootPane(window);
            if (rootPane != null) {
                rootPane.putClientProperty("radiance.theming.internal.rootPanePreferredTitlePaneHeight", preferredTitlePaneHeight);
                RadianceRootPaneUI ui = (RadianceRootPaneUI)rootPane.getUI();
                ui.setPreferredTitlePaneHeight(preferredTitlePaneHeight);
            }
        }

        public static RadianceThemingSlices.HorizontalGravity getTitleControlButtonGroupHorizontalGravity(Window window) {
            if (window == null) {
                throw new IllegalArgumentException("Window scope APIs do not accept null windows");
            }
            return RadianceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(SwingUtilities.getRootPane(window));
        }

        public static void markLabelAsTitlePaneText(Window window, JLabel label) {
            if (label == null) {
                throw new IllegalArgumentException("Should pass non-null label");
            }
            label.setFont(GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont());
            label.putClientProperty("radiance.theming.internal.isTitlePaneLabel", true);
        }
    }

    public static final class RootPaneScope {
        public static void setSkin(JRootPane rootPane, RadianceSkin skin) {
            if (rootPane == null) {
                throw new IllegalArgumentException("Root pane scope APIs do not accept null root panes");
            }
            rootPane.putClientProperty("radiance.theming.internal.rootPaneSkin", skin);
        }

        public static void setContentsModified(JRootPane rootPane, Boolean contentsModified) {
            if (rootPane == null) {
                throw new IllegalArgumentException("Root pane scope APIs do not accept null root panes");
            }
            rootPane.putClientProperty("radiance.theming.internal.contentsModified", contentsModified);
        }
    }

    public static final class ComponentOrParentChainScope {
        public static void setSelectTextOnFocus(JComponent comp, Boolean selectTextOnFocus) {
            comp.putClientProperty("radiance.theming.internal.widget.textSelectAllOnFocus", selectTextOnFocus);
        }

        public static void setToolbarButtonCornerRadius(JToolBar toolbar, float toolbarButtonCornerRadius) {
            toolbar.putClientProperty("radiance.theming.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setExtraWidgetsPresence(JComponent comp, Boolean extraWidgetsPresence) {
            comp.putClientProperty("radiance.theming.internal.showExtraWidgets", extraWidgetsPresence);
        }

        public static void setColorizationFactor(JComponent comp, double colorizationFactor) {
            comp.putClientProperty("radiance.theming.internal.colorizationFactor", colorizationFactor);
        }

        public static void setFocusKind(JComponent comp, RadianceThemingSlices.FocusKind focusKind) {
            comp.putClientProperty("radiance.theming.internal.focusKind", (Object)focusKind);
        }

        public static void setDecorationType(JComponent comp, RadianceThemingSlices.DecorationAreaType type) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            DecorationPainterUtils.setDecorationType(comp, type);
        }

        public static RadianceThemingSlices.DecorationAreaType getDecorationType(Component comp) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return DecorationPainterUtils.getDecorationType(comp);
        }
    }

    public static final class ComponentOrParentScope {
        public static void setComponentPreviewPainter(JComponent comp, PreviewPainter previewPainter) {
            comp.putClientProperty("radiance.theming.internal.widget.componentPreviewPainter", previewPainter);
        }

        public static void setButtonIgnoreMinimumSize(JComponent comp, Boolean buttonIgnoreMinimumSize) {
            comp.putClientProperty("radiance.theming.internal.buttonNoMinSize", buttonIgnoreMinimumSize);
        }

        public static void setBackgroundAppearanceStrategy(JComponent comp, RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            comp.putClientProperty("radiance.theming.internal.backgroundAppearanceStrategy", (Object)backgroundAppearanceStrategy);
        }
    }

    public static final class ComponentScope {
        public static RadianceSkin getCurrentSkin(Component c) {
            return RadianceCoreUtilities.getSkin(c);
        }

        public static void registerTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            TabCloseListenerManager.getInstance().registerListener(tabbedPane, tabCloseListener);
        }

        public static void unregisterTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            TabCloseListenerManager.getInstance().unregisterListener(tabbedPane, tabCloseListener);
        }

        public static Set<BaseTabCloseListener> getAllTabCloseListeners(JTabbedPane tabbedPane) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return TabCloseListenerManager.getInstance().getListeners(tabbedPane);
        }

        public static void allowAnimations(Component comp, RadianceThemingSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, comp);
        }

        public static void disallowAnimations(Component comp, RadianceThemingSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, comp);
        }

        public static boolean isAnimationAllowed(Component comp, RadianceThemingSlices.AnimationFacet animationFacet) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, comp);
        }

        public static RadianceThemingSlices.DecorationAreaType getImmediateDecorationType(Component comp) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            return DecorationPainterUtils.getImmediateDecorationType(comp);
        }

        public static void setLockIconVisible(JComponent comp, Boolean visible) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.widget.hasLockIcon", visible);
        }

        public static void setCapsLockIconVisible(JPasswordField passwordField, Boolean visible) {
            if (passwordField == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            passwordField.putClientProperty("radiance.theming.internal.widget.hasCapsLockIcon", visible);
        }

        public static void setPasswordStrengthChecker(JPasswordField passwordField, PasswordStrengthChecker passwordStrengthChecker) {
            if (passwordField == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            passwordField.putClientProperty("radiance.theming.internal.widget.passwordStrengthChecker", passwordStrengthChecker);
        }

        public static void setFlipTextSelectionOnEscape(JTextComponent comp, Boolean flipTextSelectionOnEscape) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.widget.textFlipSelectOnEscape", flipTextSelectionOnEscape);
        }

        public static void setTextEditContextMenuPresence(JTextComponent comp, Boolean hasEditContextMenu) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.widget.textEditContextMenu", hasEditContextMenu);
        }

        public static void setAutomaticDragAndDropSupportPresence(JTree tree, Boolean hasAutomaticDragAndDropSupport) {
            if (tree == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tree.putClientProperty("radiance.theming.internal.widget.treeAutoDnDSupport", hasAutomaticDragAndDropSupport);
        }

        public static void setAutomaticScrollPresence(JScrollPane scrollPane, Boolean hasAutomaticScroll) {
            if (scrollPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            scrollPane.putClientProperty("radiance.theming.internal.widget.autoScroll", hasAutomaticScroll);
        }

        public static void setButtonOpenSide(JComponent comp, RadianceThemingSlices.Side openSide) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.buttonOpenSide", (Object)openSide);
        }

        public static void setButtonOpenSides(JComponent comp, Set<RadianceThemingSlices.Side> openSides) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.buttonOpenSide", openSides);
        }

        public static void setButtonStraightSide(JComponent comp, RadianceThemingSlices.Side straightSide) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.buttonStraightSide", (Object)straightSide);
        }

        public static void setButtonStraightSides(JComponent comp, Set<RadianceThemingSlices.Side> straightSides) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.buttonStraightSide", straightSides);
        }

        public static void setToolbarButtonCornerRadius(AbstractButton button, float toolbarButtonCornerRadius) {
            if (button == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            button.putClientProperty("radiance.theming.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setTabContentsModified(JComponent tabComponent, Boolean contentsModified) {
            if (tabComponent == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabComponent.putClientProperty("radiance.theming.internal.contentsModified", contentsModified);
        }

        public static void setTabCloseButtonsVisible(JTabbedPane tabbedPane, Boolean tabCloseButtonsVisible) {
            tabbedPane.putClientProperty("radiance.theming.internal.tabbedPaneHasCloseButtons", tabCloseButtonsVisible);
        }

        public static void setTabCloseButtonVisible(JComponent tabComponent, Boolean tabCloseButtonVisible) {
            if (tabComponent == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabComponent.putClientProperty("radiance.theming.internal.tabbedPaneHasCloseButtons", tabCloseButtonVisible);
        }

        public static void setTabCloseCallback(JTabbedPane tabbedPane, TabCloseCallback tabCloseCallback) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabbedPane.putClientProperty("radiance.theming.internal.tabbedPaneCloseCallback", tabCloseCallback);
        }

        public static void setTabCloseCallback(JComponent tabComponent, TabCloseCallback tabCloseCallback) {
            if (tabComponent == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabComponent.putClientProperty("radiance.theming.internal.tabbedPaneCloseCallback", tabCloseCallback);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(JTabbedPane tabbedPane, Boolean runModifiedAnimationOnTabCloseButton) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabbedPane.putClientProperty("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(JComponent tabComponent, Boolean runModifiedAnimationOnTabCloseButton) {
            if (tabComponent == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabComponent.putClientProperty("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setTabContentPaneBorderKind(JTabbedPane tabbedPane, RadianceThemingSlices.TabContentPaneBorderKind tabContentPaneBorderKind) {
            if (tabbedPane == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            tabbedPane.putClientProperty("radiance.theming.internal.tabbedPaneContentBorderKind", (Object)tabContentPaneBorderKind);
        }

        public static void setButtonShaper(JComponent comp, RadianceButtonShaper buttonShaper) {
            if (comp == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comp.putClientProperty("radiance.theming.internal.buttonShaper", buttonShaper);
        }

        public static void setNumberOfPasswordEchoesPerCharacter(JPasswordField passwordField, int echoCount) {
            if (passwordField == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            passwordField.putClientProperty("radiance.theming.internal.passwordEchoPerChar", echoCount);
        }

        public static void setComboBoxPrototypeCallback(JComboBox comboBox, ComboPopupPrototypeCallback comboPopupPrototypeCallback) {
            if (comboBox == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comboBox.putClientProperty("radiance.theming.internal.comboPopupPrototype", comboPopupPrototypeCallback);
        }

        public static void setComboBoxPrototypeDisplayValue(JComboBox comboBox, Object comboPopupPrototypeDisplayValue) {
            if (comboBox == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comboBox.putClientProperty("radiance.theming.internal.comboPopupPrototype", comboPopupPrototypeDisplayValue);
        }

        public static void setComboBoxPopupFlyoutOrientation(JComboBox comboBox, Integer comboPopupFlyoutOrientation) {
            if (comboBox == null) {
                throw new IllegalArgumentException("Component scope APIs do not accept null components");
            }
            comboBox.putClientProperty("radiance.theming.internal.comboBoxPopupFlyoutOrientation", comboPopupFlyoutOrientation);
        }

        public static void setIconFilterStrategies(JComponent component, RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            component.putClientProperty("radiance.theming.internal.iconFilterStrategyActive", (Object)activeIconFilterStrategy);
            component.putClientProperty("radiance.theming.internal.iconFilterStrategyEnabled", (Object)enabledIconFilterStrategy);
            component.putClientProperty("radiance.theming.internal.iconFilterStrategyDisabled", (Object)disabledIconFilterStrategy);
        }
    }

    public static final class GlobalScope {
        private static final String RADIANCE_FONT_POLICY_KEY = "radiance.theming.internal.fontPolicyKey";
        private static ResourceBundle labelBundle = null;
        private static ClassLoader labelBundleClassLoader;
        private static RadianceSkin currentSkin;
        private static final Set<SkinChangeListener> skinChangeListeners;
        private static final Set<RadianceThemingSlices.LocaleChangeListener> localeChangeListeners;
        private static RadianceIconPack iconPack;
        private static RadianceThemingSlices.ButtonOrder buttonBarButtonOrder;
        private static RadianceThemingSlices.HorizontalGravity buttonBarGravity;

        static boolean setSkin(RadianceSkin newSkin, boolean toUpdateWindows) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("This method must be called on the Event Dispatch Thread");
            }
            if (!newSkin.isValid()) {
                return false;
            }
            boolean isRadiance = UIManager.getLookAndFeel() instanceof RadianceLookAndFeel;
            if (!isRadiance) {
                class SkinDerivedLookAndFeel
                extends RadianceLookAndFeel {
                    public SkinDerivedLookAndFeel(RadianceSkin newSkin) {
                        super(newSkin);
                    }
                }
                SkinDerivedLookAndFeel derived = new SkinDerivedLookAndFeel(newSkin);
                try {
                    UIManager.setLookAndFeel(derived);
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    ulafe.printStackTrace(System.err);
                    return false;
                }
                if (!(UIManager.getLookAndFeel() instanceof RadianceLookAndFeel)) {
                    return false;
                }
                for (Window window : Window.getWindows()) {
                    SwingUtilities.updateComponentTreeUI(window);
                }
                return true;
            }
            try {
                if (!newSkin.isValid()) {
                    return false;
                }
                UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
                if (lafDefaults != null) {
                    GlobalScope.initFontDefaults(lafDefaults, GlobalScope.getFontPolicy().getFontSet());
                    newSkin.addCustomEntriesToTable(lafDefaults);
                    RadiancePluginRepository.getInstance().processAllDefaultsEntriesComponentPlugins(lafDefaults, newSkin);
                }
                ResourceBundle radianceBundle = GlobalScope.getLabelBundle();
                Enumeration<String> keyEn = radianceBundle.getKeys();
                while (keyEn.hasMoreElements()) {
                    String key = keyEn.nextElement();
                    if (!key.contains("FileChooser")) continue;
                    String value = radianceBundle.getString(key);
                    UIManager.put(key, value);
                }
                LazyResettableHashMap.reset();
                currentSkin = newSkin;
                if (toUpdateWindows) {
                    RadianceCoreUtilities.updateActiveUi();
                }
                for (SkinChangeListener skinChangeListener : skinChangeListeners) {
                    skinChangeListener.skinChanged();
                }
                return true;
            }
            catch (Exception | NoClassDefFoundError e) {
                e.printStackTrace(System.err);
                return false;
            }
        }

        static void unsetSkin() {
            currentSkin = null;
        }

        public static boolean setSkin(RadianceSkin newSkin) {
            return GlobalScope.setSkin(newSkin, true);
        }

        public static boolean setSkin(String skinClassName) {
            try {
                Class<?> skinClass = Class.forName(skinClassName);
                if (skinClass == null) {
                    return false;
                }
                Object obj = skinClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof RadianceSkin)) {
                    return false;
                }
                return GlobalScope.setSkin((RadianceSkin)obj);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return false;
            }
        }

        public static RadianceSkin getCurrentSkin() {
            LookAndFeel current = UIManager.getLookAndFeel();
            if (current instanceof RadianceLookAndFeel) {
                return currentSkin;
            }
            return null;
        }

        static void initFontDefaults(UIDefaults table) {
            FontSet radianceFontSet = GlobalScope.getFontPolicy().getFontSet();
            GlobalScope.initFontDefaults(table, radianceFontSet);
        }

        private static void initFontDefaults(UIDefaults table, FontSet fontSet) {
            FontUIResource controlFont = fontSet.getControlFont();
            FontUIResource menuFont = fontSet.getMenuFont();
            FontUIResource messageFont = fontSet.getMessageFont();
            FontUIResource toolTipFont = fontSet.getSmallFont();
            FontUIResource titleFont = fontSet.getTitleFont();
            FontUIResource windowFont = fontSet.getWindowTitleFont();
            Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextArea.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "DesktopIcon.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "TitledBorder.font", titleFont, "ToolTip.font", toolTipFont, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(defaults);
        }

        public static void registerSkinChangeListener(SkinChangeListener skinChangeListener) {
            skinChangeListeners.add(skinChangeListener);
        }

        public static void unregisterSkinChangeListener(SkinChangeListener skinChangeListener) {
            skinChangeListeners.remove(skinChangeListener);
        }

        public static Map<String, SkinInfo> getAllSkins() {
            TreeMap<String, SkinInfo> result = new TreeMap<String, SkinInfo>();
            for (RadianceThemingSkinPlugin skinPlugin : RadiancePluginRepository.getInstance().getSkinPlugins()) {
                for (SkinInfo skinInfo : skinPlugin.getSkins()) {
                    result.put(skinInfo.getDisplayName(), skinInfo);
                }
            }
            return result;
        }

        public static void registerComponentPlugin(RadianceThemingComponentPlugin componentPlugin) {
            RadiancePluginRepository.getInstance().registerComponentPlugin(componentPlugin);
        }

        public static void registerSkinPlugin(RadianceThemingSkinPlugin skinPlugin) {
            RadiancePluginRepository.getInstance().registerSkinPlugin(skinPlugin);
        }

        public static void registerWidget(String widgetClassName, Class<?> supportedClass, boolean isExact) {
            RadianceThemingWidgetRepository.getRepository().registerWidget(widgetClassName, supportedClass, isExact);
        }

        public static void setFontPolicy(FontPolicy fontPolicy) {
            UIManager.put(RADIANCE_FONT_POLICY_KEY, fontPolicy);
            RadianceSizeUtils.setControlFontSize(-1);
            GlobalScope.setSkin(GlobalScope.getCurrentSkin());
        }

        public static FontPolicy getFontPolicy() {
            FontPolicy policy = (FontPolicy)UIManager.get(RADIANCE_FONT_POLICY_KEY);
            if (policy != null) {
                return policy;
            }
            return RadianceCommonCortex.getDefaultFontPolicy();
        }

        public static void registerTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
            TabCloseListenerManager.getInstance().registerListener(tabCloseListener);
        }

        public static void unregisterTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
            TabCloseListenerManager.getInstance().unregisterListener(tabCloseListener);
        }

        public static Set<BaseTabCloseListener> getAllTabCloseListeners() {
            return TabCloseListenerManager.getInstance().getListeners();
        }

        public static void setIconPack(RadianceIconPack iconPack) {
            if (iconPack == null) {
                throw new IllegalArgumentException("Cannot pass null icon pack");
            }
            GlobalScope.iconPack = iconPack;
            LazyResettableHashMap.reset();
        }

        public static RadianceIconPack getIconPack() {
            if (iconPack == null) {
                iconPack = new RadianceDefaultIconPack();
            }
            return iconPack;
        }

        public static void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet);
        }

        public static void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?> clazz) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, clazz);
        }

        public static void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
            AnimationConfigurationManager.getInstance().allowAnimations(animationFacet, clazz);
        }

        public static void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet);
        }

        public static void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?> clazz) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, clazz);
        }

        public static void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
            AnimationConfigurationManager.getInstance().disallowAnimations(animationFacet, clazz);
        }

        public static boolean isAnimationAllowed(RadianceThemingSlices.AnimationFacet animationFacet) {
            return AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, null);
        }

        public static void setTimelineDuration(long timelineDuration) {
            AnimationConfigurationManager.getInstance().setTimelineDuration(timelineDuration);
        }

        public static long getTimelineDuration() {
            return AnimationConfigurationManager.getInstance().getTimelineDuration();
        }

        public static void registerLocaleChangeListener(RadianceThemingSlices.LocaleChangeListener localeListener) {
            localeChangeListeners.add(localeListener);
        }

        public static void unregisterLocaleChangeListener(RadianceThemingSlices.LocaleChangeListener localeListener) {
            localeChangeListeners.remove(localeListener);
        }

        public static Set<RadianceThemingSlices.LocaleChangeListener> getLocaleChangeListeners() {
            return Collections.unmodifiableSet(localeChangeListeners);
        }

        public static synchronized ResourceBundle getLabelBundle() {
            if (labelBundle == null) {
                labelBundle = labelBundleClassLoader == null ? ResourceBundle.getBundle("org.pushingpixels.radiance.theming.internal.resources.Labels", Locale.getDefault()) : ResourceBundle.getBundle("org.pushingpixels.radiance.theming.internal.resources.Labels", Locale.getDefault(), labelBundleClassLoader);
                for (RadianceThemingSlices.LocaleChangeListener lcl : GlobalScope.getLocaleChangeListeners()) {
                    lcl.localeChanged();
                }
            }
            return labelBundle;
        }

        public static synchronized ResourceBundle getLabelBundle(Locale locale) {
            if (labelBundleClassLoader == null) {
                return ResourceBundle.getBundle("org.pushingpixels.radiance.theming.internal.resources.Labels", locale);
            }
            return ResourceBundle.getBundle("org.pushingpixels.radiance.theming.internal.resources.Labels", locale, labelBundleClassLoader);
        }

        public static synchronized void resetLabelBundle() {
            labelBundle = null;
        }

        public static void setLabelBundleClassLoader(ClassLoader labelBundleClassLoader) {
            GlobalScope.labelBundleClassLoader = labelBundleClassLoader;
        }

        public static ClassLoader getLabelBundleClassLoader() {
            return labelBundleClassLoader;
        }

        public static void setUseConstantThemesOnOptionPanes(Boolean useConstantThemesOnOptionPanes) {
            UIManager.put("radiance.theming.internal.useThemedIconsOnOptionPanes", useConstantThemesOnOptionPanes);
            SwingUtilities.invokeLater(RadianceCoreUtilities::updateActiveUi);
        }

        public static void setIconFilterStrategies(RadianceThemingSlices.IconFilterStrategy activeIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy enabledIconFilterStrategy, RadianceThemingSlices.IconFilterStrategy disabledIconFilterStrategy) {
            UIManager.put("radiance.theming.internal.iconFilterStrategyActive", (Object)activeIconFilterStrategy);
            UIManager.put("radiance.theming.internal.iconFilterStrategyEnabled", (Object)enabledIconFilterStrategy);
            UIManager.put("radiance.theming.internal.iconFilterStrategyDisabled", (Object)disabledIconFilterStrategy);
        }

        public static RadianceThemingSlices.ButtonOrder getButtonBarOrder() {
            return buttonBarButtonOrder;
        }

        public static void setButtonBarOrder(RadianceThemingSlices.ButtonOrder buttonBarButtonOrder) {
            if (buttonBarButtonOrder == null) {
                throw new IllegalArgumentException("Cannot pass null. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            GlobalScope.buttonBarButtonOrder = buttonBarButtonOrder;
            SwingUtilities.invokeLater(RadianceCoreUtilities::updateActiveUi);
        }

        public static RadianceThemingSlices.HorizontalGravity getButtonBarGravity() {
            return buttonBarGravity;
        }

        public static void setButtonBarGravity(RadianceThemingSlices.HorizontalGravity buttonBarGravity) {
            if (buttonBarGravity == null) {
                throw new IllegalArgumentException("Cannot pass null. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            GlobalScope.buttonBarGravity = buttonBarGravity;
            SwingUtilities.invokeLater(RadianceCoreUtilities::updateActiveUi);
        }

        public static void configureTitleContentGravity(RadianceThemingSlices.HorizontalGravity titleTextHorizontalGravity, RadianceThemingSlices.HorizontalGravity titleControlButtonGroupHorizontalGravity, RadianceThemingSlices.TitleIconHorizontalGravity titleIconHorizontalGravity) {
            if (titleTextHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for text gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleControlButtonGroupHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for control button group horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleIconHorizontalGravity == null) {
                throw new IllegalArgumentException("Cannot pass null for icon horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            if (titleControlButtonGroupHorizontalGravity == RadianceThemingSlices.HorizontalGravity.CENTERED) {
                throw new IllegalArgumentException("Cannot pass CENTERED for control button group horizontal gravity. Did you mean PLATFORM or SWING_DEFAULT?");
            }
            UIManager.put("radiance.theming.internal.titleTextHorizontalGravity", (Object)titleTextHorizontalGravity);
            UIManager.put("radiance.theming.internal.titleControlButtonGroupHorizontalGravity", (Object)titleControlButtonGroupHorizontalGravity);
            UIManager.put("radiance.theming.internal.titleIconHorizontalGravity", (Object)titleIconHorizontalGravity);
            SwingUtilities.invokeLater(RadianceCoreUtilities::updateActiveUi);
        }

        public static RadianceThemingSlices.HorizontalGravity getTitleTextHorizontalGravity() {
            return RadianceTitlePaneUtilities.getTitleTextHorizontalGravity();
        }

        public static RadianceThemingSlices.TitleIconHorizontalGravity getTitleIconHorizontalGravity() {
            return RadianceTitlePaneUtilities.getTitleIconHorizontalGravity();
        }

        public static void setWidgetVisible(boolean visible, RadianceThemingSlices.WidgetType ... radianceWidgets) {
            RadianceWidgetManager.getInstance().register(null, visible, radianceWidgets);
            for (Window window : Window.getWindows()) {
                JRootPane root = SwingUtilities.getRootPane(window);
                SwingUtilities.updateComponentTreeUI(root);
            }
        }

        public static void setLockIconVisible(Boolean visible) {
            UIManager.put("radiance.theming.internal.widget.hasLockIcon", visible);
        }

        public static void setCapsLockIconVisible(Boolean visible) {
            UIManager.put("radiance.theming.internal.widget.hasCapsLockIcon", visible);
        }

        public static void setComponentPreviewPainter(PreviewPainter previewPainter) {
            UIManager.put("radiance.theming.internal.widget.componentPreviewPainter", previewPainter);
        }

        public static void setSelectTextOnFocus(Boolean selectTextOnFocus) {
            UIManager.put("radiance.theming.internal.widget.textSelectAllOnFocus", selectTextOnFocus);
        }

        public static void setTextEditContextMenuPresence(Boolean hasEditContextMenu) {
            UIManager.put("radiance.theming.internal.widget.textEditContextMenu", hasEditContextMenu);
        }

        public static void setAutomaticDragAndDropSupportPresence(Boolean hasAutomaticDragAndDropSupport) {
            UIManager.put("radiance.theming.internal.widget.treeAutoDnDSupport", hasAutomaticDragAndDropSupport);
        }

        public static void setAutomaticScrollPresence(Boolean hasAutomaticScroll) {
            UIManager.put("radiance.theming.internal.widget.autoScroll", hasAutomaticScroll);
        }

        public static void setButtonIgnoreMinimumSize(Boolean buttonIgnoreMinimumSize) {
            UIManager.put("radiance.theming.internal.buttonNoMinSize", buttonIgnoreMinimumSize);
        }

        public static void setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy backgroundAppearanceStrategy) {
            UIManager.put("radiance.theming.internal.backgroundAppearanceStrategy", (Object)backgroundAppearanceStrategy);
        }

        public static void setToolbarButtonCornerRadius(float toolbarButtonCornerRadius) {
            UIManager.put("radiance.theming.internal.toolbarButtonCornerRadius", Float.valueOf(toolbarButtonCornerRadius));
        }

        public static void setExtraWidgetsPresence(Boolean extraWidgetsPresence) {
            UIManager.put("radiance.theming.internal.showExtraWidgets", extraWidgetsPresence);
        }

        public static void setColorizationFactor(double colorizationFactor) {
            UIManager.put("radiance.theming.internal.colorizationFactor", colorizationFactor);
        }

        public static void setTabCloseButtonsVisible(Boolean tabCloseButtonsVisible) {
            UIManager.put("radiance.theming.internal.tabbedPaneHasCloseButtons", tabCloseButtonsVisible);
        }

        public static void setTabCloseCallback(TabCloseCallback tabCloseCallback) {
            UIManager.put("radiance.theming.internal.tabbedPaneCloseCallback", tabCloseCallback);
        }

        public static void setRunModifiedAnimationOnTabCloseButton(Boolean runModifiedAnimationOnTabCloseButton) {
            UIManager.put("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation", runModifiedAnimationOnTabCloseButton);
        }

        public static void setTabContentPaneBorderKind(RadianceThemingSlices.TabContentPaneBorderKind tabContentPaneBorderKind) {
            UIManager.put("radiance.theming.internal.tabbedPaneContentBorderKind", (Object)tabContentPaneBorderKind);
        }

        public static void setNumberOfPasswordEchoesPerCharacter(int echoCount) {
            UIManager.put("radiance.theming.internal.passwordEchoPerChar", echoCount);
        }

        public static void setMenuGutterFillAlpha(float menuGutterFillAlpha) {
            if (menuGutterFillAlpha < 0.0f || menuGutterFillAlpha > 1.0f) {
                throw new IllegalArgumentException("Menu gutter fill alpha should be in 0.0-1.0 range");
            }
            UIManager.put("radiance.theming.internal.menuGutterFillAlpha", Float.valueOf(menuGutterFillAlpha));
        }

        public static float getMenuGutterFillAlpha() {
            return RadianceCoreUtilities.getMenuGutterFillAlpha();
        }

        public static void setTraceFilename(String traceFilename) {
            UIManager.put("radiance.theming.internal.traceFile", traceFilename);
        }

        public static void setFocusKind(RadianceThemingSlices.FocusKind focusKind) {
            UIManager.put("radiance.theming.internal.focusKind", (Object)focusKind);
        }

        public static void setComboBoxPrototypeCallback(ComboPopupPrototypeCallback comboPopupPrototypeCallback) {
            UIManager.put("radiance.theming.internal.comboPopupPrototype", comboPopupPrototypeCallback);
        }

        public static void setComboBoxPrototypeDisplayValue(Object comboPopupPrototypeDisplayValue) {
            UIManager.put("radiance.theming.internal.comboPopupPrototype", comboPopupPrototypeDisplayValue);
        }

        public static void setComboBoxPopupFlyoutOrientation(int comboPopupFlyoutOrientation) {
            UIManager.put("radiance.theming.internal.comboBoxPopupFlyoutOrientation", comboPopupFlyoutOrientation);
        }

        public static BufferedImage getBlankImage(double scaleFactor, int width, int height) {
            return RadianceCoreUtilities.getBlankImage(scaleFactor, width, height);
        }

        public static void setUseDefaultColorChooser() {
            UIManager.put("radiance.theming.internal.useDefaultColorChooser", Boolean.TRUE);
        }

        static {
            currentSkin = null;
            skinChangeListeners = new HashSet<SkinChangeListener>();
            localeChangeListeners = new HashSet<RadianceThemingSlices.LocaleChangeListener>();
            buttonBarButtonOrder = RadianceThemingSlices.ButtonOrder.PLATFORM;
            buttonBarGravity = RadianceThemingSlices.HorizontalGravity.PLATFORM;
        }
    }
}

