/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

class DerivedColorsResolverDark
implements SchemeDerivedColors {
    private RadianceColorScheme scheme;

    public DerivedColorsResolverDark(RadianceColorScheme scheme) {
        if (!scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be dark: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    public String toString() {
        return "Resolver for " + this.scheme.getDisplayName();
    }

    @Override
    public Color getLineColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return RadianceColorUtilities.deriveByBrightness(this.scheme.getUltraLightColor(), 0.2f);
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getAccentedBackgroundFillColor() {
        return RadianceColorUtilities.getDarkerColor(this.scheme.getMidColor(), 0.08f);
    }

    @Override
    public Color getFocusRingColor() {
        return RadianceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getLightColor(), 0.4f);
    }

    @Override
    public Color getSeparatorPrimaryColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getSeparatorSecondaryColor() {
        return this.scheme.getDarkColor();
    }

    @Override
    public Color getMarkColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getForegroundColor(), this.scheme.getUltraLightColor(), 0.9);
    }

    @Override
    public Color getEchoColor() {
        return this.scheme.getUltraDarkColor();
    }
}

