/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeBaseColors;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.radiance.theming.api.trait.RadianceTrait;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.filters.ColorSchemeFilter;

public interface RadianceColorScheme
extends RadianceTrait,
SchemeBaseColors,
SchemeDerivedColors {
    public boolean isDark();

    public RadianceColorScheme shift(Color var1, double var2, Color var4, double var5);

    public RadianceColorScheme shiftBackground(Color var1, double var2);

    public RadianceColorScheme tint(double var1);

    public RadianceColorScheme tone(double var1);

    public RadianceColorScheme shade(double var1);

    public RadianceColorScheme saturate(double var1);

    public RadianceColorScheme invert();

    public RadianceColorScheme negate();

    public RadianceColorScheme hueShift(double var1);

    public RadianceColorScheme blendWith(RadianceColorScheme var1, double var2);

    public RadianceColorScheme named(String var1);

    default public RadianceIcon.ColorFilter getColorFilter(float brightnessFactor, float alpha) {
        RadianceColorScheme origin = this;
        return color -> {
            int[] interpolated = ColorSchemeFilter.getInterpolatedColors(origin);
            int steps = interpolated.length;
            int brightness = RadianceColorUtilities.getColorBrightness(color.getRGB());
            int a = color.getAlpha();
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            float[] hsb = Color.RGBtoHSB(r, g, b, null);
            int pixelColor = interpolated[brightness * steps / 256];
            int ri = pixelColor >>> 16 & 0xFF;
            int gi = pixelColor >>> 8 & 0xFF;
            int bi = pixelColor >>> 0 & 0xFF;
            float[] hsbi = Color.RGBtoHSB(ri, gi, bi, null);
            hsb[0] = hsbi[0];
            hsb[1] = hsbi[1];
            hsb[2] = brightnessFactor >= 0.0f ? brightnessFactor * hsb[2] + (1.0f - brightnessFactor) * hsbi[2] : hsb[2] * hsbi[2] * (1.0f + brightnessFactor);
            Color converted = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            int finalAlpha = (int)((float)a * alpha);
            return new Color(converted.getRed(), converted.getGreen(), converted.getBlue(), finalAlpha);
        };
    }
}

