/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;

public class CompositeBorderPainter
implements RadianceBorderPainter {
    private String displayName;
    private RadianceBorderPainter inner;
    private RadianceBorderPainter outer;

    public CompositeBorderPainter(String displayName, RadianceBorderPainter outer, RadianceBorderPainter inner) {
        this.displayName = displayName;
        this.outer = outer;
        this.inner = inner;
    }

    @Override
    public boolean isPaintingInnerContour() {
        return true;
    }

    @Override
    public void paintBorder(Graphics g, Component c, float width, float height, Shape contour, Shape innerContour, RadianceColorScheme borderScheme) {
        if (innerContour != null) {
            this.inner.paintBorder(g, c, width, height, innerContour, null, borderScheme);
        }
        if (contour != null) {
            this.outer.paintBorder(g, c, width, height, contour, null, borderScheme);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme borderScheme) {
        return this.outer.getRepresentativeColor(borderScheme);
    }
}

