/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.StandardBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class DelegateBorderPainter
extends StandardBorderPainter {
    protected String displayName;
    protected StandardBorderPainter delegate;
    protected int topMask;
    protected int midMask;
    protected int bottomMask;
    protected ColorSchemeTransform transform;
    protected static final LazyResettableHashMap<RadianceColorScheme> transformMap = new LazyResettableHashMap("DelegateBorderPainter");

    public DelegateBorderPainter(String displayName, StandardBorderPainter delegate, ColorSchemeTransform transform) {
        this(displayName, delegate, -1, -1, -1, transform);
    }

    public DelegateBorderPainter(String displayName, StandardBorderPainter delegate, int topMask, int midMask, int bottomMask, ColorSchemeTransform transform) {
        this.displayName = displayName;
        this.delegate = delegate;
        this.topMask = topMask;
        this.midMask = midMask;
        this.bottomMask = bottomMask;
        this.transform = transform;
    }

    @Override
    public Color getTopBorderColor(RadianceColorScheme borderScheme) {
        return new Color(this.topMask & this.delegate.getTopBorderColor(borderScheme).getRGB(), true);
    }

    @Override
    public Color getMidBorderColor(RadianceColorScheme borderScheme) {
        return new Color(this.midMask & this.delegate.getMidBorderColor(borderScheme).getRGB(), true);
    }

    @Override
    public Color getBottomBorderColor(RadianceColorScheme borderScheme) {
        return new Color(this.bottomMask & this.delegate.getBottomBorderColor(borderScheme).getRGB(), true);
    }

    @Override
    public void paintBorder(Graphics g, Component c, float width, float height, Shape contour, Shape innerContour, RadianceColorScheme borderScheme) {
        super.paintBorder(g, c, width, height, contour, innerContour, this.getShiftScheme(borderScheme));
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private RadianceColorScheme getShiftScheme(RadianceColorScheme orig) {
        HashMapKey key = RadianceCoreUtilities.getHashKey(orig.getDisplayName(), this.getDisplayName(), this.transform);
        RadianceColorScheme result = transformMap.get(key);
        if (result == null) {
            result = this.transform.transform(orig);
            transformMap.put(key, result);
        }
        return result;
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme borderScheme) {
        return super.getRepresentativeColor(this.getShiftScheme(borderScheme));
    }
}

