/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class StandardBorderPainter
implements RadianceBorderPainter {
    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }

    @Override
    public void paintBorder(Graphics g, Component c, float width, float height, Shape contour, Shape innerContour, RadianceColorScheme borderScheme) {
        if (contour == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Color topBorderColor = this.getTopBorderColor(borderScheme);
        Color midBorderColor = this.getMidBorderColor(borderScheme);
        Color bottomBorderColor = this.getBottomBorderColor(borderScheme);
        if (topBorderColor != null && midBorderColor != null && bottomBorderColor != null) {
            float strokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
            boolean isSpecialButton = c != null && c.getClass().isAnnotationPresent(RadianceInternalArrowButton.class);
            int joinKind = isSpecialButton ? 0 : 1;
            int capKind = isSpecialButton ? 2 : 0;
            graphics.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
            LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{topBorderColor, midBorderColor, bottomBorderColor}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(gradient);
            graphics.draw(contour);
        }
        graphics.dispose();
    }

    public Color getTopBorderColor(RadianceColorScheme borderScheme) {
        return RadianceColorUtilities.getTopBorderColor(borderScheme);
    }

    public Color getMidBorderColor(RadianceColorScheme borderScheme) {
        return RadianceColorUtilities.getMidBorderColor(borderScheme);
    }

    public Color getBottomBorderColor(RadianceColorScheme borderScheme) {
        return RadianceColorUtilities.getBottomBorderColor(borderScheme);
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme borderScheme) {
        return this.getMidBorderColor(borderScheme);
    }
}

