/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.decoration;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class ClassicDecorationPainter
implements RadianceDecorationPainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static final LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("ClassicDecorationPainter");
    protected ClassicFillPainter painter = new ClassicFillPainter();

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        RadianceColorScheme scheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (width * height < 100000) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, scheme.getDisplayName());
            BufferedImage result = smallImageCache.get(key);
            if (result == null) {
                result = RadianceCoreUtilities.getBlankImage(scale, width, height);
                this.internalPaint((Graphics2D)result.getGraphics(), comp, width, height, scheme);
                smallImageCache.put(key, result);
            }
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)result, (int)0, (int)0);
            return;
        }
        this.internalPaint(graphics, comp, width, height, scheme);
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme colorScheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-3, -3);
        this.painter.paintContourBackground(g2d, comp, contour.getBounds().width, contour.getBounds().height, contour, false, colorScheme, false);
        g2d.dispose();
    }

    protected void internalPaint(Graphics2D graphics, Component comp, int width, int height, RadianceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-3, -3);
        this.painter.paintContourBackground(g2d, comp, width + 6, height + 6, new Rectangle(width + 6, height + 6), false, scheme, false);
        g2d.dispose();
    }
}

