/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.FractionBasedPainter;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class FractionBasedDecorationPainter
extends FractionBasedPainter
implements RadianceDecorationPainter {
    private Set<RadianceThemingSlices.DecorationAreaType> decoratedAreas = new HashSet<RadianceThemingSlices.DecorationAreaType>();

    public FractionBasedDecorationPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        this(displayName, fractions, colorQueries, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    public FractionBasedDecorationPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries, RadianceThemingSlices.DecorationAreaType ... decorationAreas) {
        super(displayName, fractions, colorQueries);
        if (decorationAreas != null) {
            for (RadianceThemingSlices.DecorationAreaType decorationArea : decorationAreas) {
                this.decoratedAreas.add(decorationArea);
            }
        }
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        if (this.decoratedAreas.contains(decorationAreaType)) {
            this.paintDecoratedBackground(graphics, comp, decorationAreaType, width, height, colorScheme);
        } else {
            this.paintSolidBackground(graphics, width, height, colorScheme);
        }
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme colorScheme) {
        if (this.decoratedAreas.contains(decorationAreaType)) {
            this.paintDecoratedBackground(graphics, comp, decorationAreaType, contour, colorScheme);
        } else {
            this.paintSolidBackground(graphics, contour, colorScheme);
        }
    }

    private void paintDecoratedBackground(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            fillColors[i] = colorQuery.query(scheme);
        }
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, topMostWithSameDecorationAreaType.getHeight(), this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g2d.setPaint(gradient);
        g2d.translate(0, -dy);
        g2d.fillRect(0, 0, width, topMostWithSameDecorationAreaType.getHeight());
        g2d.dispose();
    }

    private void paintDecoratedBackground(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            fillColors[i] = colorQuery.query(scheme);
        }
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, topMostWithSameDecorationAreaType.getHeight(), this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g2d.setPaint(gradient);
        g2d.translate(0, -dy);
        g2d.fill(contour);
        g2d.dispose();
    }

    private void paintSolidBackground(Graphics2D graphics, int width, int height, RadianceColorScheme scheme) {
        graphics.setColor(scheme.getMidColor());
        graphics.fillRect(0, 0, width, height);
    }

    private void paintSolidBackground(Graphics2D graphics, Shape contour, RadianceColorScheme scheme) {
        graphics.setColor(scheme.getMidColor());
        graphics.fill(contour);
    }
}

